/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.command;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import stevekung.mods.indicatia.command.ClientCommandBase;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.gui.GuiAutoLoginFunction;
import stevekung.mods.indicatia.gui.GuiAutoLoginFunctionHelp;
import stevekung.mods.indicatia.util.AutoLogin;
import stevekung.mods.indicatia.util.Base64Util;
import stevekung.mods.indicatia.util.GameProfileUtil;
import stevekung.mods.indicatia.util.JsonUtil;

public class CommandAutoLogin
extends ClientCommandBase {
    private static final GuiAutoLoginFunction gui = new GuiAutoLoginFunction();
    private static final GuiAutoLoginFunctionHelp guiHelp = new GuiAutoLoginFunctionHelp(false);

    public String func_71517_b() {
        return "autologin";
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        JsonUtil json = IndicatiaMod.json;
        Minecraft mc = IndicatiaMod.MC;
        ServerData data = mc.func_147104_D();
        UUID uuid = GameProfileUtil.getUUID();
        if (args.length < 1) {
            throw new WrongUsageException("commands.autologin.usage", new Object[0]);
        }
        if ("add".equalsIgnoreCase(args[0])) {
            if (args.length <= 2) {
                throw new WrongUsageException("commands.autologin.usage", new Object[0]);
            }
            if (mc.func_71356_B()) {
                if (!mc.func_71356_B()) return;
                sender.func_145747_a(json.text("Cannot add auto login data in singleplayer!").func_150255_a(json.red()));
                return;
            }
            if (data == null) return;
            if (ExtendedConfig.loginData.getAutoLogin(uuid.toString() + data.field_78845_b) != null) {
                sender.func_145747_a(json.text("An auto login data already set for Username: " + uuid.toString() + "!").func_150255_a(json.red()));
                return;
            }
            IChatComponent component = ClientCommandBase.getChatComponentFromNthArg(args, 2);
            String value = component.func_150259_f().func_150260_c();
            ExtendedConfig.loginData.addAutoLogin(data.field_78845_b, "/" + args[1] + " ", Base64Util.encode(value), uuid, "");
            sender.func_145747_a((IChatComponent)json.text("Set auto login data for Server: " + data.field_78845_b));
            ExtendedConfig.save();
            return;
        }
        if ("remove".equalsIgnoreCase(args[0])) {
            if (mc.func_71356_B()) {
                if (!mc.func_71356_B()) return;
                sender.func_145747_a(json.text("Cannot remove auto login data in singleplayer!").func_150255_a(json.red()));
                return;
            }
            if (data == null) return;
            if (ExtendedConfig.loginData.getAutoLogin(uuid.toString() + data.field_78845_b) != null) {
                ExtendedConfig.loginData.removeAutoLogin(uuid + data.field_78845_b);
                sender.func_145747_a((IChatComponent)json.text("Remove auto login data from Username: " + uuid.toString()));
                return;
            }
            sender.func_145747_a(json.text("No auto login data was set for Username: " + uuid.toString() + "!").func_150255_a(json.red()));
            return;
        }
        if ("list".equalsIgnoreCase(args[0])) {
            Collection<AutoLogin.AutoLoginData> collection = ExtendedConfig.loginData.getAutoLoginList();
            if (collection.isEmpty()) {
                throw new CommandException("commands.autologin.list.empty", new Object[0]);
            }
            ChatComponentTranslation component = new ChatComponentTranslation("commands.autologin.list.count", new Object[]{collection.size()});
            component.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
            sender.func_145747_a((IChatComponent)component);
            Iterator<AutoLogin.AutoLoginData> iterator = collection.iterator();
            while (iterator.hasNext()) {
                AutoLogin.AutoLoginData loginData = iterator.next();
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.autologin.list.entry", new Object[]{loginData.getServerIP(), loginData.getUUID()}));
            }
            return;
        }
        if (!"function".equalsIgnoreCase(args[0])) throw new WrongUsageException("commands.autologin.usage", new Object[0]);
        if (args.length == 1) {
            if (mc.func_71356_B()) {
                sender.func_145747_a(json.text("Cannot use function in singleplayer!").func_150255_a(json.red()));
                return;
            }
            gui.display();
        }
        if (args.length != 2) return;
        if (!"help".equalsIgnoreCase(args[1])) throw new WrongUsageException("commands.autologin.function.usage", new Object[0]);
        guiHelp.display();
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list", "function"});
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("function")) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"help"});
        }
        return super.func_180525_a(sender, args, pos);
    }
}

