/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import stevekung.mods.indicatia.command.ClientCommandBase;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.profile.ProfileConfigData;
import stevekung.mods.indicatia.profile.ProfileData;
import stevekung.mods.indicatia.profile.RenderProfileConfig;
import stevekung.mods.indicatia.util.JsonUtil;

public class CommandProfile
extends ClientCommandBase {
    public String func_71517_b() {
        return "profileiu";
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        JsonUtil json = IndicatiaMod.json;
        ProfileConfigData configData = new ProfileConfigData();
        if (args.length < 1) {
            throw new WrongUsageException("commands.profileiu.usage", new Object[0]);
        }
        if ("add".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.profileiu.add.usage", new Object[0]);
            }
            if (RenderProfileConfig.profileData.getProfile(args[1]) != null) {
                sender.func_145747_a(json.text("Profile data was already set for name: " + args[1] + "!").func_150255_a(json.red()));
                return;
            }
            RenderProfileConfig.profileData.addProfileData(args[1], ConfigManager.enableFPS, ConfigManager.enableXYZ, ConfigManager.enableBiome, ConfigManager.enablePing, ConfigManager.enableServerIP, ConfigManager.enableRenderEquippedItem, ConfigManager.enablePotionStatusHUD, ConfigManager.enableKeystroke, ConfigManager.enableCPS, ConfigManager.enableRCPS, ConfigManager.enableSlimeChunkFinder, ConfigManager.enableCurrentRealTime, ConfigManager.enableCurrentGameTime, ConfigManager.enableGameWeather, ConfigManager.enableMoonPhase, ConfigManager.keystrokePosition, ConfigManager.equipmentOrdering, ConfigManager.equipmentDirection, ConfigManager.equipmentStatus, ConfigManager.equipmentPosition, ConfigManager.potionStatusHUDStyle, ConfigManager.potionStatusHUDPosition, ExtendedConfig.ARMOR_STATUS_OFFSET, ExtendedConfig.POTION_STATUS_OFFSET, ExtendedConfig.KEYSTROKE_Y_OFFSET, ExtendedConfig.CPS_X_OFFSET, ExtendedConfig.CPS_Y_OFFSET, ExtendedConfig.TOP_DONATOR_FILE_PATH, ExtendedConfig.RECENT_DONATOR_FILE_PATH);
            sender.func_145747_a((IChatComponent)json.text("Add profile data name: " + args[1]));
            RenderProfileConfig.save();
        } else if ("load".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.profileiu.load.usage", new Object[0]);
            }
            if (RenderProfileConfig.profileData.getProfileList().isEmpty()) {
                sender.func_145747_a((IChatComponent)json.text("Cannot load profile data, empty profile data file"));
                return;
            }
            for (ProfileData.ProfileSettingData data : RenderProfileConfig.profileData.getProfileList()) {
                if (RenderProfileConfig.profileData.getProfile(args[1]) != null) {
                    if (!args[1].equals(data.getProfileName())) continue;
                    configData.load(data);
                    ConfigManager.getConfig().save();
                    ExtendedConfig.save();
                    RenderProfileConfig.save();
                    sender.func_145747_a((IChatComponent)json.text("Load profile data for name: " + args[1]));
                    continue;
                }
                sender.func_145747_a(json.text("Cannot load profile data from: " + args[1]).func_150255_a(json.red()));
                return;
            }
        } else if ("save".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.profileiu.save.usage", new Object[0]);
            }
            for (ProfileData.ProfileSettingData data : RenderProfileConfig.profileData.getProfileList()) {
                if (RenderProfileConfig.profileData.getProfile(args[1]) == null) {
                    sender.func_145747_a(json.text("Cannot save profile data to: " + args[1]).func_150255_a(json.red()));
                    return;
                }
                if (!args[1].equals(data.getProfileName())) continue;
                RenderProfileConfig.profileData.saveProfileData(args[1], ConfigManager.enableFPS, ConfigManager.enableXYZ, ConfigManager.enableBiome, ConfigManager.enablePing, ConfigManager.enableServerIP, ConfigManager.enableRenderEquippedItem, ConfigManager.enablePotionStatusHUD, ConfigManager.enableKeystroke, ConfigManager.enableCPS, ConfigManager.enableRCPS, ConfigManager.enableSlimeChunkFinder, ConfigManager.enableCurrentRealTime, ConfigManager.enableCurrentGameTime, ConfigManager.enableGameWeather, ConfigManager.enableMoonPhase, ConfigManager.keystrokePosition, ConfigManager.equipmentOrdering, ConfigManager.equipmentDirection, ConfigManager.equipmentStatus, ConfigManager.equipmentPosition, ConfigManager.potionStatusHUDStyle, ConfigManager.potionStatusHUDPosition, ExtendedConfig.ARMOR_STATUS_OFFSET, ExtendedConfig.POTION_STATUS_OFFSET, ExtendedConfig.KEYSTROKE_Y_OFFSET, ExtendedConfig.CPS_X_OFFSET, ExtendedConfig.CPS_Y_OFFSET, ExtendedConfig.TOP_DONATOR_FILE_PATH, ExtendedConfig.RECENT_DONATOR_FILE_PATH);
                RenderProfileConfig.save();
                sender.func_145747_a((IChatComponent)json.text("Save profile data for name: " + args[1]));
            }
        } else if ("remove".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.profileiu.remove.usage", new Object[0]);
            }
            if (RenderProfileConfig.profileData.getProfile(args[1]) != null) {
                RenderProfileConfig.profileData.removeProfile(args[1]);
                sender.func_145747_a((IChatComponent)json.text("Remove profile data for name: " + args[1]));
            } else {
                sender.func_145747_a(json.text("Cannot remove or find profile data from: " + args[1]).func_150255_a(json.red()));
            }
        } else if ("list".equalsIgnoreCase(args[0])) {
            Collection<ProfileData.ProfileSettingData> collection = RenderProfileConfig.profileData.getProfileList();
            if (collection.isEmpty()) {
                throw new CommandException("commands.profileiu.list.empty", new Object[0]);
            }
            ChatComponentTranslation textcomponenttranslation = new ChatComponentTranslation("commands.profileiu.list.count", new Object[]{collection.size()});
            textcomponenttranslation.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
            sender.func_145747_a((IChatComponent)textcomponenttranslation);
            for (ProfileData.ProfileSettingData data : collection) {
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("commands.profileiu.list.entry", new Object[]{data.getProfileName()}));
            }
        } else {
            throw new WrongUsageException("commands.profileiu.usage", new Object[0]);
        }
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "load", "save", "remove", "list"});
        }
        if (args.length == 2 && ("load".equalsIgnoreCase(args[0]) || "remove".equalsIgnoreCase(args[0]) || "save".equalsIgnoreCase(args[0]))) {
            Collection<ProfileData.ProfileSettingData> collection = RenderProfileConfig.profileData.getProfileList();
            ArrayList<String> list = new ArrayList<String>();
            for (ProfileData.ProfileSettingData data : collection) {
                list.add(data.getProfileName());
            }
            return CommandBase.func_175762_a((String[])args, list);
        }
        return super.func_180525_a(sender, args, pos);
    }
}

