/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.core;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import stevekung.mods.indicatia.command.CommandAFK;
import stevekung.mods.indicatia.command.CommandAutoClick;
import stevekung.mods.indicatia.command.CommandAutoLogin;
import stevekung.mods.indicatia.command.CommandChangeLog;
import stevekung.mods.indicatia.command.CommandHideName;
import stevekung.mods.indicatia.command.CommandIndicatia;
import stevekung.mods.indicatia.command.CommandMojangStatusCheck;
import stevekung.mods.indicatia.command.CommandProfile;
import stevekung.mods.indicatia.command.CommandSlimeChunkSeed;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.handler.BlockhitAnimationHandler;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.handler.HUDRenderHandler;
import stevekung.mods.indicatia.handler.KeyBindingHandler;
import stevekung.mods.indicatia.handler.PlayerChatHandler;
import stevekung.mods.indicatia.profile.RenderProfileConfig;
import stevekung.mods.indicatia.renderer.ColoredFontRenderer;
import stevekung.mods.indicatia.renderer.RenderArmorStandNew;
import stevekung.mods.indicatia.renderer.RenderFishNew;
import stevekung.mods.indicatia.renderer.TileEntitySkullRendererNew;
import stevekung.mods.indicatia.util.CCMDHandler;
import stevekung.mods.indicatia.util.CapeUtil;
import stevekung.mods.indicatia.util.GameProfileUtil;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.ModLogger;
import stevekung.mods.indicatia.util.VersionChecker;

@Mod(modid="indicatia", name="Indicatia", version="1.1.9", dependencies="after:Forge@[11.15.1.2318,);", clientSideOnly=true, guiFactory="stevekung.mods.indicatia.config.ConfigGuiFactory", certificateFingerprint="b3468b224a74e296555ad7efeb35f482e6f445de", acceptedMinecraftVersions="[1.8.9]")
public class IndicatiaMod {
    public static final String NAME = "Indicatia";
    public static final String MOD_ID = "indicatia";
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    public static final int BUILD_VERSION = 9;
    public static final String VERSION = "1.1.9";
    public static final String MC_VERSION = String.valueOf(FMLInjectionData.data()[4]);
    public static final String GUI_FACTORY = "stevekung.mods.indicatia.config.ConfigGuiFactory";
    public static final String FORGE_VERSION = "after:Forge@[11.15.1.2318,);";
    public static final String URL = "https://minecraft.curseforge.com/projects/indicatia";
    public static final String CERTIFICATE = "b3468b224a74e296555ad7efeb35f482e6f445de";
    private static boolean DEOBFUSCATED;
    public static Minecraft MC;
    public static boolean CHECK_NO_CONNECTION;
    public static boolean SHOW_ANNOUNCE_MESSAGE;
    public static boolean FOUND_LATEST;
    public static ColoredFontRenderer coloredFontRenderer;
    public static JsonUtil json;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IndicatiaMod.init(event.getModMetadata());
        ConfigManager.init(new File(event.getModConfigurationDirectory(), "indicatia.cfg"));
        KeyBindingHandler.init();
        ExtendedConfig.load();
        RenderProfileConfig.load();
        MinecraftForge.EVENT_BUS.register((Object)new HUDRenderHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new CommonHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new BlockhitAnimationHandler(MC));
        MinecraftForge.EVENT_BUS.register((Object)new PlayerChatHandler(MC));
        if (IndicatiaMod.isSteveKunG()) {
            try {
                Class<?> clazz = Class.forName("stevekung.mods.indicatia.internal.InternalEventHandler");
                clazz.getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandMojangStatusCheck());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandChangeLog());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoLogin());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSlimeChunkSeed());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAFK());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandIndicatia());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandProfile());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandHideName());
        if (IndicatiaMod.isSteveKunG()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandAutoClick());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        IndicatiaMod.MC.func_175598_ae().field_78729_o.entrySet().removeIf(entry -> ((Class)entry.getKey()).equals(EntityFishHook.class));
        IndicatiaMod.MC.func_175598_ae().field_78729_o.put(EntityFishHook.class, new RenderFishNew(MC.func_175598_ae()));
        IndicatiaMod.MC.func_175598_ae().field_78729_o.entrySet().removeIf(entry -> ((Class)entry.getKey()).equals(EntityArmorStand.class));
        IndicatiaMod.MC.func_175598_ae().field_78729_o.put(EntityArmorStand.class, new RenderArmorStandNew(MC.func_175598_ae()));
        ModLogger.info("Successfully replacing {}", EntityFishHook.class.getName());
        ModLogger.info("Successfully replacing {}", EntityArmorStand.class.getName());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigManager.enableVersionChecker) {
            VersionChecker.startCheck();
        }
        CapeUtil.loadCapeTextureAtStartup();
        coloredFontRenderer = new ColoredFontRenderer(IndicatiaMod.MC.field_71474_y, new ResourceLocation("textures/font/ascii.png"), IndicatiaMod.MC.field_71446_o, false);
        ((IReloadableResourceManager)MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)coloredFontRenderer);
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.entrySet().removeIf(entry -> ((Class)entry.getKey()).equals(TileEntitySkull.class));
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(TileEntitySkull.class, new TileEntitySkullRendererNew());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!IndicatiaMod.isObfuscatedEnvironment()) {
            throw new RuntimeException("Invalid fingerprint detected! This version will NOT be supported by the author!");
        }
        ModLogger.info("Development environment detected! Ignore certificate check.");
    }

    public static boolean isObfuscatedEnvironment() {
        return DEOBFUSCATED;
    }

    public static boolean isSteveKunG() {
        return GameProfileUtil.getUsername().equals("SteveKunG") && GameProfileUtil.getUUID().equals(UUID.fromString("eef3a603-1c1b-4c98-8264-d2f04b231ef4")) || IndicatiaMod.isObfuscatedEnvironment();
    }

    private static void init(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MOD_ID;
        info.name = NAME;
        info.version = VERSION;
        info.description = "Simple in-game info and utility!";
        info.url = URL;
        info.authorList = Arrays.asList("SteveKunG");
    }

    private static void overrideClientCommandHandler() {
        try {
            Field field = ClientCommandHandler.class.getDeclaredField("instance");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(ClientCommandHandler.class.cast(ClientCommandHandler.instance), (Object)new CCMDHandler());
            ModLogger.info("Successfully replacing {} instance", ClientCommandHandler.class.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            ModLogger.error("Couldn't replace {} instance!", ClientCommandHandler.class.getName());
        }
    }

    static {
        try {
            DEOBFUSCATED = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MC = Minecraft.func_71410_x();
        json = new JsonUtil();
        IndicatiaMod.overrideClientCommandHandler();
    }
}

