/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.renderer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.util.ModLogger;

@SideOnly(value=Side.CLIENT)
public class ColoredFontRenderer
extends FontRenderer {
    private static int marker = 59136;
    private boolean dropShadow;
    private int state = 0;
    private int red;
    private int green;
    private int blue;
    private final String specialUpperChars = "\u0e48\u0e49\u0e4a\u0e4b";
    private final String upperChars = "\u0e31\u0e34\u0e35\u0e36\u0e37\u0e47\u0e4c\u0e4d\u0e4e" + this.specialUpperChars;
    private final String lowerChars = "\u0e38\u0e39\u0e3a";

    public ColoredFontRenderer(GameSettings gameSettings, ResourceLocation location, TextureManager textureManager, boolean unicode) {
        super(gameSettings, location, textureManager, unicode);
        ModLogger.info("Loading {} for fancy text!", ((Object)((Object)this)).getClass().getName());
    }

    protected String func_78280_d(String str, int wrapWidth) {
        int i = this.func_78259_e(str, wrapWidth);
        if (str.length() <= i) {
            return str;
        }
        String s = str.substring(0, i);
        char c0 = str.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = this.getCustomFormatFromString(s) + str.substring(i + (flag ? 1 : 0));
        return s + "\n" + this.func_78280_d(s1, wrapWidth);
    }

    public int func_180455_b(String text, float x, float y, int color, boolean dropShadow) {
        this.dropShadow = dropShadow;
        return super.func_180455_b(text, x, y, color, dropShadow);
    }

    protected float func_78277_a(char charac, boolean italic) {
        return this.renderColoredChar(charac, super.func_78277_a(charac, italic));
    }

    protected float func_78266_a(int charac, boolean italic) {
        return this.renderColoredChar(charac, super.func_78266_a(charac, italic));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        super.func_110549_a(resourceManager);
        this.func_78264_a(IndicatiaMod.MC.func_135016_M().func_135042_a() || IndicatiaMod.MC.field_71474_y.field_151455_aw);
        this.func_78275_b(IndicatiaMod.MC.func_135016_M().func_135044_b());
    }

    public float func_181559_a(char charac, boolean italic) {
        float value = Float.NaN;
        if (this.upperChars.indexOf(charac) != -1 || this.lowerChars.indexOf(charac) != -1) {
            value = this.renderThaiCharacter(charac, italic);
        }
        if (Float.isNaN(value)) {
            value = super.func_181559_a(charac, italic);
        }
        return value;
    }

    public int func_78263_a(char charac) {
        if (this.upperChars.indexOf(charac) != -1 || this.lowerChars.indexOf(charac) != -1) {
            return 0;
        }
        return super.func_78263_a(charac);
    }

    public static String color(int r, int g, int b) {
        return String.format("%c%c%c", Character.valueOf((char)(marker + (r & 0xFF))), Character.valueOf((char)(marker + (g & 0xFF))), Character.valueOf((char)(marker + (b & 0xFF))));
    }

    private float renderThaiCharacter(char charac, boolean italic) {
        this.func_78257_a(14);
        float posYShift = 0.0f;
        float height = 2.99f;
        if (this.lowerChars.indexOf(charac) != -1) {
            height = 1.99f;
            posYShift = 6.0f;
        }
        float heightX2 = height * 2.0f;
        int rawWidth = this.field_78287_e[charac] & 0xFF;
        float startTexcoordX = rawWidth >>> 4;
        float charWidth = (rawWidth & 0xF) + 1;
        float texcoordX = (float)(charac % 16 * 16) + startTexcoordX;
        float texcoordY = (float)((charac & 0xFF) / 16 * 16) + posYShift * 2.0f;
        float texcoordXEnd = charWidth - startTexcoordX - 0.02f;
        float skew = italic ? 1.0f : 0.0f;
        float posX = this.field_78295_j - ((charWidth - startTexcoordX) / 2.0f + 0.5f);
        float posY = this.field_78296_k + posYShift;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(texcoordX / 256.0f), (float)(texcoordY / 256.0f));
        GL11.glVertex3f((float)(posX + skew), (float)posY, (float)0.0f);
        GL11.glTexCoord2f((float)(texcoordX / 256.0f), (float)((texcoordY + heightX2) / 256.0f));
        GL11.glVertex3f((float)(posX - skew), (float)(posY + height), (float)0.0f);
        GL11.glTexCoord2f((float)((texcoordX + texcoordXEnd) / 256.0f), (float)(texcoordY / 256.0f));
        GL11.glVertex3f((float)(posX + texcoordXEnd / 2.0f + skew), (float)posY, (float)0.0f);
        GL11.glTexCoord2f((float)((texcoordX + texcoordXEnd) / 256.0f), (float)((texcoordY + heightX2) / 256.0f));
        GL11.glVertex3f((float)(posX + texcoordXEnd / 2.0f - skew), (float)(posY + height), (float)0.0f);
        GL11.glEnd();
        return 0.0f;
    }

    private float renderColoredChar(int charac, float defaultValue) {
        if (charac >= marker && charac <= marker + 255) {
            int value = charac & 0xFF;
            switch (this.state) {
                case 0: {
                    this.red = value;
                    break;
                }
                case 1: {
                    this.green = value;
                    break;
                }
                case 2: {
                    this.blue = value;
                    break;
                }
                default: {
                    this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    return 0.0f;
                }
            }
            ++this.state;
            this.state %= 3;
            int color = this.red << 16 | this.green << 8 | this.blue | 0xFF000000;
            if ((color & 0xFC000000) == 0) {
                color |= 0xFF000000;
            }
            if (this.dropShadow) {
                color = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
            }
            this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
            return 0.0f;
        }
        if (this.state != 0) {
            this.state = 0;
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return defaultValue;
    }

    private String getCustomFormatFromString(String text) {
        String s = "";
        int j = text.length();
        for (int i = 0; i < j - 1; ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                char c0 = text.charAt(i + 1);
                if (c0 >= '0' && c0 <= '9' || c0 >= 'a' && c0 <= 'f' || c0 >= 'A' && c0 <= 'F') {
                    s = "\u00a7" + c0;
                    ++i;
                    continue;
                }
                if (!(c0 >= 'k' && c0 <= 'o' || c0 >= 'K' && c0 <= 'O' || c0 == 'r') && c0 != 'R') continue;
                s = s + "\u00a7" + c0;
                ++i;
                continue;
            }
            if (c < marker || c > marker + 255) continue;
            s = String.format("%s%s%s", Character.valueOf(c), Character.valueOf(text.charAt(i + 1)), Character.valueOf(text.charAt(i + 2)));
            i += 2;
        }
        return s;
    }
}

