/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.indicatia.config.ConfigManager;
import stevekung.mods.indicatia.core.IndicatiaMod;

@SideOnly(value=Side.CLIENT)
public class TileEntitySkullRendererNew
extends TileEntitySpecialRenderer<TileEntitySkull> {
    private static final ResourceLocation SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation WITHER_SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    private static final ResourceLocation ZOMBIE_TEXTURES = new ResourceLocation("textures/entity/zombie/zombie.png");
    private static final ResourceLocation CREEPER_TEXTURES = new ResourceLocation("textures/entity/creeper/creeper.png");
    private static final ModelSkeletonHead skeletonHead = new ModelSkeletonHead(0, 0, 64, 32);
    private static final ModelSkeletonHead humanoidHead = new ModelHumanoidHead();

    public void renderTileEntityAt(TileEntitySkull tile, double x, double y, double z, float partialTicks, int destroyStage) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(tile.func_145832_p() & 7));
        TileEntitySkullRendererNew.renderSkull((float)x, (float)y, (float)z, facing, (float)(tile.func_145906_b() * 360) / 16.0f, tile.func_145904_a(), tile.func_152108_a(), destroyStage, IndicatiaMod.MC.func_110434_K());
    }

    public static void renderSkull(float x, float y, float z, EnumFacing facing, float netHeadYaw, int skullType, @Nullable GameProfile profile, int destroyStage, TextureManager texture) {
        ModelSkeletonHead model = skeletonHead;
        if (destroyStage >= 0) {
            texture.func_110577_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            switch (skullType) {
                default: {
                    texture.func_110577_a(SKELETON_TEXTURES);
                    break;
                }
                case 1: {
                    texture.func_110577_a(WITHER_SKELETON_TEXTURES);
                    break;
                }
                case 2: {
                    texture.func_110577_a(ZOMBIE_TEXTURES);
                    model = humanoidHead;
                    break;
                }
                case 3: {
                    model = humanoidHead;
                    ResourceLocation resource = DefaultPlayerSkin.func_177335_a();
                    if (profile != null) {
                        MinecraftProfileTexture.Type typeSkin;
                        Map map = IndicatiaMod.MC.func_152342_ad().func_152788_a(profile);
                        if (map.containsKey(typeSkin = MinecraftProfileTexture.Type.SKIN)) {
                            resource = IndicatiaMod.MC.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(typeSkin), typeSkin);
                        } else {
                            UUID uuid = EntityPlayer.func_146094_a((GameProfile)profile);
                            resource = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                        }
                    }
                    texture.func_110577_a(resource);
                    break;
                }
                case 4: {
                    texture.func_110577_a(CREEPER_TEXTURES);
                }
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        } else {
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.74f));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.26f));
                    netHeadYaw = 180.0f;
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)(x + 0.74f), (float)(y + 0.25f), (float)(z + 0.5f));
                    netHeadYaw = 270.0f;
                    break;
                }
                default: {
                    GlStateManager.func_179109_b((float)(x + 0.26f), (float)(y + 0.25f), (float)(z + 0.5f));
                    netHeadYaw = 90.0f;
                }
            }
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        if (skullType == 3 && ConfigManager.enableTransparentSkullRender) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        }
        model.func_78088_a(null, 0.0f, 0.0f, 0.0f, netHeadYaw, 0.0f, 0.0625f);
        if (skullType == 3 && ConfigManager.enableTransparentSkullRender) {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }
}

