/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.indicatia.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import stevekung.mods.indicatia.config.ExtendedConfig;
import stevekung.mods.indicatia.core.IndicatiaMod;
import stevekung.mods.indicatia.handler.CommonHandler;
import stevekung.mods.indicatia.util.JsonUtil;
import stevekung.mods.indicatia.util.LangUtil;
import stevekung.mods.indicatia.util.RenderUtil;

public class InfoUtil {
    public static final InfoUtil INSTANCE = new InfoUtil();
    public Entity extendedPointedEntity;
    private Entity pointedEntity;

    public int getPing() {
        NetworkPlayerInfo info = IndicatiaMod.MC.func_147114_u().func_175102_a(IndicatiaMod.MC.field_71439_g.func_110124_au());
        if (info != null) {
            if (info.func_178853_c() > 0) {
                return info.func_178853_c();
            }
            return CommonHandler.currentServerPing;
        }
        return 0;
    }

    public boolean isHypixel() {
        ServerData server = IndicatiaMod.MC.func_147104_D();
        if (server != null) {
            Pattern pattern = Pattern.compile("^(?:(?:(?:\\w+\\.)?hypixel\\.net)|(?:209\\.222\\.115\\.(?:18|27|8|40|36|33|19|38|16|43|10|46|48|47|39|20|30|23|21|99)))(?::\\d{1,5})?$", 2);
            Matcher matcher = pattern.matcher(server.field_78845_b);
            return matcher.find();
        }
        return false;
    }

    public int getCPS() {
        Iterator<Long> iterator = CommonHandler.LEFT_CLICK.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() >= System.currentTimeMillis() - 1000L) continue;
            iterator.remove();
        }
        return CommonHandler.LEFT_CLICK.size();
    }

    public int getRCPS() {
        Iterator<Long> iterator = CommonHandler.RIGHT_CLICK.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() >= System.currentTimeMillis() - 1000L) continue;
            iterator.remove();
        }
        return CommonHandler.RIGHT_CLICK.size();
    }

    public void setOverlayMessage(String message, boolean isPlaying) {
        IndicatiaMod.MC.field_71456_v.func_110326_a(message, isPlaying);
    }

    public void setOverlayMessage(IChatComponent component, boolean isPlaying) {
        IndicatiaMod.MC.field_71456_v.func_175188_a(component, isPlaying);
    }

    public String getCurrentGameTime(long worldTicks) {
        String ampm;
        int hours = (int)((worldTicks / 1000L + 6L) % 24L);
        int minutes = (int)(60L * (worldTicks % 1000L) / 1000L);
        String sminutes = "" + minutes;
        String shours = "" + hours;
        String string = ampm = hours >= 12 ? "PM" : "AM";
        if (hours <= 9) {
            shours = "0" + hours;
        }
        if (minutes <= 9) {
            sminutes = "0" + minutes;
        }
        return "Game: " + shours + ":" + sminutes + " " + ampm;
    }

    public String getMoonPhase(Minecraft mc) {
        String status;
        int[] moonPhaseFactors = new int[]{4, 3, 2, 1, 0, -1, -2, -3};
        int phase = moonPhaseFactors[mc.field_71441_e.field_73011_w.func_76559_b(mc.field_71441_e.func_72820_D())];
        switch (phase) {
            default: {
                status = "Full Moon";
                break;
            }
            case 3: {
                status = "Waning Gibbous";
                break;
            }
            case 2: {
                status = "Last Quarter";
                break;
            }
            case 1: {
                status = "Waning Crescent";
                break;
            }
            case 0: {
                status = "New Moon";
                break;
            }
            case -1: {
                status = "Waxing Crescent";
                break;
            }
            case -2: {
                status = "First Quarter";
                break;
            }
            case -3: {
                status = "Waxing Gibbous";
            }
        }
        return "Moon Phase: " + status;
    }

    public boolean isSlimeChunk(BlockPos pos) {
        int z;
        int x = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        Random rnd = new Random(ExtendedConfig.SLIME_CHUNK_SEED + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)((z = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16)) * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return rnd.nextInt(10) == 0;
    }

    public int getAlternatePotionHUDTextColor(Potion potion) {
        int color = 0;
        if (potion == Potion.field_76444_x) {
            color = RenderUtil.rgbToDecimal(247, 219, 21);
        } else if (potion == Potion.field_76428_l) {
            color = RenderUtil.rgbToDecimal(244, 120, 226);
        } else if (potion == Potion.field_76420_g) {
            color = RenderUtil.rgbToDecimal(179, 55, 55);
        } else if (potion == Potion.field_76424_c) {
            color = RenderUtil.rgbToDecimal(120, 201, 224);
        } else if (potion == Potion.field_76426_n) {
            color = RenderUtil.rgbToDecimal(233, 157, 73);
        } else if (potion == Potion.field_76429_m) {
            color = RenderUtil.rgbToDecimal(137, 140, 154);
        } else if (potion == Potion.field_76430_j) {
            color = RenderUtil.rgbToDecimal(33, 251, 75);
        } else if (potion == Potion.field_76439_r) {
            color = RenderUtil.rgbToDecimal(97, 97, 224);
        } else if (potion == Potion.field_76427_o) {
            color = RenderUtil.rgbToDecimal(79, 122, 202);
        } else if (potion == Potion.field_76421_d) {
            color = RenderUtil.rgbToDecimal(103, 123, 146);
        } else if (potion == Potion.field_76422_e) {
            color = RenderUtil.rgbToDecimal(182, 169, 80);
        } else if (potion == Potion.field_76419_f) {
            color = RenderUtil.rgbToDecimal(90, 81, 29);
        } else if (potion == Potion.field_76431_k) {
            color = RenderUtil.rgbToDecimal(125, 43, 108);
        } else if (potion == Potion.field_76441_p) {
            color = RenderUtil.rgbToDecimal(139, 142, 156);
        } else if (potion == Potion.field_76440_q) {
            color = RenderUtil.rgbToDecimal(90, 90, 90);
        } else if (potion == Potion.field_76438_s) {
            color = RenderUtil.rgbToDecimal(99, 133, 92);
        } else if (potion == Potion.field_76437_t) {
            color = RenderUtil.rgbToDecimal(102, 108, 102);
        } else if (potion == Potion.field_76436_u) {
            color = RenderUtil.rgbToDecimal(81, 152, 50);
        } else if (potion == Potion.field_82731_v) {
            color = RenderUtil.rgbToDecimal(105, 84, 80);
        } else if (potion == Potion.field_180152_w) {
            color = RenderUtil.rgbToDecimal(245, 124, 35);
        }
        return color;
    }

    public int parseInt(String input, String type) {
        JsonUtil json = IndicatiaMod.json;
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            IndicatiaMod.MC.field_71439_g.func_145747_a(json.text(LangUtil.translate("commands.generic.num.invalid", input) + " in " + type + " setting").func_150255_a(json.red()));
            return 0;
        }
    }

    public void processMouseOverEntity(Minecraft mc, float partialTicks) {
        Entity entity = mc.func_175606_aa();
        double distance = 12.0;
        if (entity != null && mc.field_71441_e != null) {
            mc.field_71424_I.func_76320_a("pick");
            this.extendedPointedEntity = null;
            mc.field_71476_x = entity.func_174822_a(distance, partialTicks);
            Vec3 vec3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            double d1 = distance;
            if (mc.field_71442_b.func_78749_i()) {
                distance = d1 = distance;
            } else if (distance > distance) {
                flag = true;
            }
            if (mc.field_71476_x != null) {
                d1 = mc.field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3 vec3d1 = entity.func_70676_i(1.0f);
            Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
            this.pointedEntity = null;
            Vec3 vec3d3 = null;
            List list = mc.field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72314_b(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, entry -> entry != null && entry.func_70067_L()));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                float size = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)size, (double)size, (double)size);
                MovingObjectPosition raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    this.pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == entity.field_70154_o && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    this.pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                this.pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (this.pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > distance) {
                this.pointedEntity = null;
                mc.field_71476_x = new MovingObjectPosition(MovingObjectPosition.MovingObjectType.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
            }
            if (this.pointedEntity != null && (d2 < d1 || mc.field_71476_x == null)) {
                mc.field_71476_x = new MovingObjectPosition(this.pointedEntity, vec3d3);
                if (this.pointedEntity instanceof EntityLivingBase || this.pointedEntity instanceof EntityItemFrame) {
                    this.extendedPointedEntity = this.pointedEntity;
                }
            }
            mc.field_71424_I.func_76319_b();
        }
    }
}

