/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLinked;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.personal.ContainerTradeOMatClosed;
import ic2.core.block.personal.ContainerTradeOMatOpen;
import ic2.core.block.personal.GuiTradeOMatClosed;
import ic2.core.block.personal.GuiTradeOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.util.StackUtil;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class TileEntityTradeOMat
extends TileEntityInventory
implements IPersonalBlock,
IHasGui,
INetworkTileEntityEventListener,
INetworkClientTileEntityEventListener {
    private int ticker = IC2.random.nextInt(64);
    public String owner = "null";
    public int totalTradeCount = 0;
    public int stock = 0;
    public boolean infinite = false;
    private static final int stockUpdateRate = 64;
    private static final int EventTrade = 0;
    public final InvSlot demandSlot = new InvSlot(this, "demand", 0, InvSlot.Access.NONE, 1);
    public final InvSlot offerSlot = new InvSlot(this, "offer", 1, InvSlot.Access.NONE, 1);
    public final InvSlotConsumableLinked inputSlot = new InvSlotConsumableLinked((TileEntityInventory)this, "input", 2, 1, this.demandSlot);
    public final InvSlotOutput outputSlot = new InvSlotOutput(this, "output", 3, 1);

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
        this.totalTradeCount = nbttagcompound.func_74762_e("totalTradeCount");
        if (nbttagcompound.func_74764_b("infinite")) {
            this.infinite = nbttagcompound.func_74767_n("infinite");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74768_a("totalTradeCount", this.totalTradeCount);
        if (this.infinite) {
            nbttagcompound.func_74757_a("infinite", this.infinite);
        }
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("owner");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        ItemStack tradedIn = this.inputSlot.consumeLinked(true);
        if (!this.offerSlot.isEmpty() && tradedIn != null && this.outputSlot.canAdd(this.offerSlot.get())) {
            if (this.infinite) {
                this.inputSlot.consumeLinked(false);
                this.outputSlot.add(this.offerSlot.get().func_77946_l());
            } else {
                int transferredOut;
                ItemStack transferredIn = StackUtil.fetch(this, this.offerSlot.get(), true);
                if (transferredIn != null && transferredIn.field_77994_a == this.offerSlot.get().field_77994_a && (transferredOut = StackUtil.distribute(this, tradedIn, true)) == tradedIn.field_77994_a) {
                    StackUtil.distribute(this, this.inputSlot.consumeLinked(false), false);
                    this.outputSlot.add(StackUtil.fetch(this, this.offerSlot.get(), false));
                    ++this.totalTradeCount;
                    this.stock -= this.offerSlot.get().field_77994_a;
                    IC2.network.initiateTileEntityEvent(this, 0, true);
                    this.func_70296_d();
                }
            }
        }
        if (this.infinite) {
            this.stock = -1;
        } else if (this.ticker++ % 64 == 0) {
            this.updateStock();
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.updateStock();
        }
    }

    public void updateStock() {
        this.stock = 0;
        ItemStack offer = this.offerSlot.get();
        if (offer != null) {
            ItemStack available = StackUtil.fetch(this, StackUtil.copyWithSize(offer, Integer.MAX_VALUE), true);
            this.stock = available == null ? 0 : available.field_77994_a;
        }
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.permitsAccess(entityPlayer);
    }

    @Override
    public boolean permitsAccess(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.owner.equals("null")) {
            this.owner = player.field_71092_bJ;
            IC2.network.updateTileEntityField(this, "owner");
            return true;
        }
        if (MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71262_S()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.field_71092_bJ);
    }

    @Override
    public boolean permitsAccess(String username) {
        return this.owner.equals(username);
    }

    @Override
    public String getUsername() {
        return this.owner;
    }

    @Override
    public String func_70303_b() {
        return "Trade-O-Mat";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        if (this.permitsAccess(entityPlayer)) {
            return new ContainerTradeOMatOpen(entityPlayer, this);
        }
        return new ContainerTradeOMatClosed(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        if (this.permitsAccess(entityPlayer)) {
            return new GuiTradeOMatOpen(new ContainerTradeOMatOpen(entityPlayer, this), isAdmin);
        }
        return new GuiTradeOMatClosed(new ContainerTradeOMatClosed(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/o-mat.ogg", true, IC2.audioManager.defaultVolume);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ")");
            }
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        MinecraftServer server;
        if (event == 0 && (server = MinecraftServer.func_71276_C()).func_71203_ab().func_72353_e(player.field_71092_bJ)) {
            boolean bl = this.infinite = !this.infinite;
            if (!this.infinite) {
                this.updateStock();
            }
        }
    }
}

