/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerSortingMachine;
import ic2.core.block.machine.gui.GuiSortingMachine;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySortingMachine
extends TileEntityElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener,
IUpgradableBlock {
    public final int defaultTier;
    public final InvSlotUpgrade upgradeSlot;
    public final InvSlot buffer;
    private final ItemStack[][] filters;
    private int amount = 0;
    public EnumFacing defaultRoute = EnumFacing.DOWN;

    public TileEntitySortingMachine() {
        super(100000, 2, false);
        this.defaultTier = 1;
        this.upgradeSlot = new InvSlotUpgrade(this, "upgrade", 3);
        this.buffer = new InvSlot(this, "Buffer", InvSlot.Access.I, 11);
        this.filters = new ItemStack[6][];
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = new ItemStack[7];
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList filtersTag = nbt.func_150295_c("filters", 10);
        for (int i = 0; i < filtersTag.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound filterTag = filtersTag.func_150305_b(i);
            int index = filterTag.func_74771_c("index") & 0xFF;
            this.filters[index / 7][index % 7] = stack = ItemStack.func_77949_a((NBTTagCompound)filterTag);
        }
        byte defaultRouteIdx = nbt.func_74771_c("defaultroute");
        if (defaultRouteIdx >= 0 && defaultRouteIdx < EnumFacing.field_82609_l.length) {
            this.defaultRoute = EnumFacing.field_82609_l[defaultRouteIdx];
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList filtersTag = new NBTTagList();
        for (int i = 0; i < 42; ++i) {
            ItemStack stack = this.filters[i / 7][i % 7];
            if (stack == null) continue;
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag.func_74774_a("index", (byte)i);
            stack.func_77955_b(contentTag);
            filtersTag.func_74742_a((NBTBase)contentTag);
        }
        nbt.func_74782_a("filters", (NBTBase)filtersTag);
        nbt.func_74774_a("defaultroute", (byte)this.defaultRoute.ordinal());
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        block0: for (int index = 0; index < this.buffer.size(); ++index) {
            if (this.energy.getEnergy() < 20.0) {
                return;
            }
            ItemStack stack = this.buffer.get(index);
            if (stack == null) continue;
            if (stack.field_77994_a <= 0) {
                this.buffer.put(index, null);
                continue;
            }
            block1: for (StackUtil.AdjacentInv inv : StackUtil.getAdjacentInventories(this)) {
                if (inv.dir != this.defaultRoute) {
                    for (ItemStack filterStack : this.getFilterSlots(inv.dir)) {
                        if (filterStack == null || !StackUtil.checkItemEquality(filterStack, stack)) continue;
                        this.amount = StackUtil.putInInventory(inv.inv, inv.dir, StackUtil.copyWithSize(stack, 1), false);
                        if (this.amount <= 0) continue block1;
                        stack.field_77994_a -= this.amount;
                        this.energy.useEnergy(20.0);
                        if (stack.field_77994_a > 0) continue block1;
                        this.buffer.put(index, null);
                        continue block0;
                    }
                    continue;
                }
                boolean inFilter = false;
                ItemStack[][] arr$ = this.filters;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ItemStack[] sideFilters;
                    for (ItemStack filter : sideFilters = arr$[i$]) {
                        if (!StackUtil.checkItemEquality(filter, stack)) continue;
                        inFilter = true;
                    }
                }
                if (inFilter) continue;
                this.amount = StackUtil.putInInventory(inv.inv, inv.dir, StackUtil.copyWithSize(stack, 1), false);
                if (this.amount <= 0) continue block0;
                stack.field_77994_a -= this.amount;
                this.energy.useEnergy(20.0);
                if (stack.field_77994_a > 0) continue block0;
                this.buffer.put(index, null);
                continue block0;
            }
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event >= 0 && event <= 5) {
            this.defaultRoute = EnumFacing.field_82609_l[event];
        }
    }

    public ContainerBase<TileEntitySortingMachine> getGuiContainer(EntityPlayer player) {
        return new ContainerSortingMachine(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiSortingMachine(new ContainerSortingMachine(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradableBlock();
        }
    }

    public void setUpgradableBlock() {
        int extraTier = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            IUpgradeItem upgrade = (IUpgradeItem)stack.func_77973_b();
            extraTier += upgrade.getExtraTier(stack, this) * stack.field_77994_a;
        }
        this.energy.setSinkTier(TileEntitySortingMachine.applyModifier(this.defaultTier, extraTier, 1.0));
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public ItemStack[] getFilterSlots(EnumFacing side) {
        return this.filters[side.ordinal()];
    }
}

