/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.core.IC2;
import ic2.core.item.ItemIC2FluidContainer;
import ic2.core.ref.ItemName;
import ic2.core.util.LiquidUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidCell
extends ItemIC2FluidContainer {
    public ItemFluidCell() {
        super(ItemName.fluid_cell, 1000);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        if (world.field_72995_K) {
            return false;
        }
        if (this.interactWithTank(stack, player, world, pos, side)) {
            player.field_71069_bz.func_75142_b();
            return true;
        }
        MovingObjectPosition position = this.func_77621_a(world, player, true);
        if (position == null) {
            return false;
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            pos = position.func_178782_a();
            if (!world.canMineBlockBody(player, pos)) {
                return false;
            }
            if (!player.func_175151_a(pos, position.field_178784_b, stack)) {
                return false;
            }
            if (LiquidUtil.drainBlockToContainer(world, pos, stack, player) || LiquidUtil.fillBlockFromContainer(world, pos, stack, player) || LiquidUtil.fillBlockFromContainer(world, pos.func_177972_a(side), stack, player)) {
                player.field_71069_bz.func_75142_b();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack emptyStack = new ItemStack(item);
        subItems.add(emptyStack);
        for (Fluid fluid : LiquidUtil.getAllFluids()) {
            ItemStack stack;
            if (fluid == null || this.fill(stack = emptyStack.func_77946_l(), new FluidStack(fluid, Integer.MAX_VALUE), true) <= 0) continue;
            subItems.add(stack);
        }
    }

    private boolean interactWithTank(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        FluidStack fs = this.getFluid(stack);
        if (fs == null || player.func_70093_af() && fs.amount < this.capacity) {
            int amount = fs == null ? this.capacity : this.capacity - fs.amount;
            FluidStack input = handler.drain(side, amount, false);
            if (input == null || input.amount <= 0) {
                return true;
            }
            amount = LiquidUtil.fillContainerStack(stack, player, input, false);
            if (amount <= 0) {
                return true;
            }
            handler.drain(side, amount, true);
            return true;
        }
        int amount = handler.fill(side, fs, false);
        if (amount <= 0) {
            return true;
        }
        fs = LiquidUtil.drainContainerStack(stack, player, amount, false);
        if (fs == null || fs.amount <= 0) {
            return true;
        }
        handler.fill(side, fs, true);
        return true;
    }
}

