/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.recipe.Recipes;
import ic2.core.IC2Potion;
import ic2.core.block.BlockSheet;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.item.ItemMulti;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.item.type.IRadioactiveItemType;
import ic2.core.ref.BlockName;
import ic2.core.ref.FluidName;
import ic2.core.ref.TeBlock;
import ic2.core.util.Util;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemHandlers {
    public static ItemMulti.IItemRightClickHandler cfPowderApply = new ItemMulti.IItemRightClickHandler(){

        @Override
        public ItemStack onRightClick(ItemStack stack, EntityPlayer player) {
            MovingObjectPosition position = Util.traceBlocks(player, true);
            if (position == null) {
                return stack;
            }
            if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                if (!player.field_70170_p.canMineBlockBody(player, position.func_178782_a())) {
                    return stack;
                }
                if (player.field_70170_p.func_180495_p(position.func_178782_a()).func_177230_c() == Blocks.field_150355_j) {
                    --stack.field_77994_a;
                    player.field_70170_p.func_175656_a(position.func_178782_a(), FluidName.construction_foam.getInstance().getBlock().func_176223_P());
                }
            }
            return stack;
        }
    };
    public static ItemMulti.IItemRightClickHandler scrapBoxUnpack = new ItemMulti.IItemRightClickHandler(){

        @Override
        public ItemStack onRightClick(ItemStack stack, EntityPlayer player) {
            ItemStack drop;
            if (!player.field_70170_p.field_72995_K && (drop = Recipes.scrapboxDrops.getDrop(stack, false)) != null && player.func_71019_a(drop, false) != null && !player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return stack;
        }
    };
    public static ItemMulti.IItemUseHandler resinUse = new ItemMulti.IItemUseHandler(){

        @Override
        public boolean onUse(ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing side) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150331_J && state.func_177229_b((IProperty)BlockPistonBase.field_176321_a) == side) {
                IBlockState newState = Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176321_a, (Comparable)side).func_177226_a((IProperty)BlockPistonBase.field_176320_b, state.func_177229_b((IProperty)BlockPistonBase.field_176320_b));
                player.field_70170_p.func_180501_a(pos, newState, 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
            if (side != EnumFacing.UP) {
                return false;
            }
            pos = pos.func_177984_a();
            if (!state.func_177230_c().isAir((IBlockAccess)player.field_70170_p, pos) || !BlockName.sheet.getInstance().func_176193_a(player.field_70170_p, pos, side, BlockName.sheet.getItemStack(BlockSheet.SheetType.resin))) {
                return false;
            }
            player.field_70170_p.func_175656_a(pos, BlockName.sheet.getBlockState(BlockSheet.SheetType.resin));
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
    };
    public static ItemMulti.IItemUpdateHandler radioactiveUpdate = new ItemMulti.IItemUpdateHandler(){

        @Override
        public void onUpdate(ItemStack stack, World world, Entity rawEntity, int slotIndex, boolean isCurrentItem) {
            Item item = stack.func_77973_b();
            if (item == null || !(item instanceof ItemMulti)) {
                return;
            }
            Object rawType = ((ItemMulti)item).getType(stack);
            if (!(rawType instanceof IRadioactiveItemType)) {
                return;
            }
            IRadioactiveItemType type = (IRadioactiveItemType)rawType;
            if (!(rawEntity instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase entity = (EntityLivingBase)rawEntity;
            if (ItemArmorHazmat.hasCompleteHazmat(entity)) {
                return;
            }
            IC2Potion.radiation.applyTo(entity, type.getRadiationDuration() * 20, type.getRadiationAmplifier());
        }
    };
    public static TeBlock.ITePlaceHandler reactorChamberPlace = new TeBlock.ITePlaceHandler(){

        @Override
        public boolean canReplace(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
            int count = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
                if (!(te instanceof TileEntityNuclearReactorElectric)) continue;
                ++count;
            }
            return count == 1;
        }
    };
}

