/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import com.google.common.base.Predicate;
import ic2.api.item.IBoxable;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.PositionSpec;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.item.ItemIC2;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemToolCutter
extends ItemIC2
implements IBoxable,
IItemHudInfo {
    public ItemToolCutter() {
        super(ItemName.cutter);
        this.func_77656_e(59);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public boolean func_180614_a(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            Predicate<ItemStack> request = StackUtil.sameStack(ItemName.crafting.getItemStack(CraftingItemType.rubber));
            if (StackUtil.consumeFromPlayerInventory(player, request, 1, true) && cable.tryAddInsulation()) {
                StackUtil.consumeFromPlayerInventory(player, request, 1, false);
                ItemToolCutter.damageCutter(itemstack, 1);
                return true;
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(StatCollector.func_74838_a((String)"ic2.item.ItemTool.tooltip.UsesLeft") + " " + ItemToolCutter.getRemainingUses(stack));
    }

    public static void onInsulationRemoved(ItemStack stack, World world, BlockPos pos) {
        ItemToolCutter.damageCutter(stack, 3);
        if (world.field_72995_K) {
            IC2.audioManager.playOnce(new AudioPosition(world, pos), PositionSpec.Center, "Tools/InsulationCutters.ogg", true, IC2.audioManager.getDefaultVolume());
        }
    }

    private static void damageCutter(ItemStack stack, int damage) {
        if (!stack.func_77984_f()) {
            return;
        }
        stack.func_77964_b(stack.func_77952_i() + damage);
        if (stack.func_77952_i() > stack.func_77958_k()) {
            --stack.field_77994_a;
            if (stack.field_77994_a < 0) {
                stack.field_77994_a = 0;
            }
            stack.func_77964_b(0);
        }
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        return true;
    }

    @Override
    public List<String> getHudInfo(ItemStack stack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add("Uses left: " + ItemToolCutter.getRemainingUses(stack));
        return info;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack ret = stack.func_77946_l();
        if (ret.func_96631_a(1, IC2.random)) {
            return null;
        }
        return ret;
    }
}

