/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IBoxable;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.audio.PositionSpec;
import ic2.core.init.MainConfig;
import ic2.core.item.ItemIC2;
import ic2.core.ref.ItemName;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;

public class ItemToolWrench
extends ItemIC2
implements IBoxable {
    public ItemToolWrench() {
        this(ItemName.wrench);
    }

    protected ItemToolWrench(ItemName name) {
        super(name);
        this.func_77656_e(120);
        this.func_77625_d(1);
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.canTakeDamage(stack, 1)) {
            return false;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(world, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!world.field_72995_K) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/wrench.ogg", true, IC2.audioManager.getDefaultVolume());
            }
            return !world.field_72995_K;
        }
        return false;
    }

    public static WrenchResult wrenchBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player, boolean remove) {
        IBlockState state = Util.getBlockState((IBlockAccess)world, pos);
        Block block = state.func_177230_c();
        if (block.isAir((IBlockAccess)world, pos)) {
            return WrenchResult.Nothing;
        }
        if (block instanceof IWrenchable) {
            EnumFacing currentFacing;
            IWrenchable wrenchable = (IWrenchable)block;
            EnumFacing newFacing = currentFacing = wrenchable.getFacing(world, pos);
            if (IC2.keyboard.isAltKeyDown(player)) {
                EnumFacing.Axis axis = side.func_176740_k();
                if (side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && !player.func_70093_af() || side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && player.func_70093_af()) {
                    newFacing = newFacing.func_176732_a(axis);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        newFacing = newFacing.func_176732_a(axis);
                    }
                }
            } else {
                newFacing = player.func_70093_af() ? side.func_176734_d() : side;
            }
            if (newFacing != currentFacing && wrenchable.setFacing(world, pos, newFacing, player)) {
                return WrenchResult.Rotated;
            }
            if (remove && wrenchable.wrenchCanRemove(world, pos, player)) {
                if (!world.field_72995_K) {
                    int experience;
                    TileEntity te = world.func_175625_s(pos);
                    if (ConfigUtil.getBool(MainConfig.get(), "protection/wrenchLogging")) {
                        String playerName = player.func_146103_bH().getName() + "/" + player.func_146103_bH().getId();
                        String teName = te != null ? te.getClass().getSimpleName().replace("TileEntity", "") : "no te";
                        IC2.log.info(LogCategory.PlayerActivity, "Player %s used a wrench to remove the %s (%s) at %s.", playerName, state, teName, Util.formatPosition((IBlockAccess)world, pos));
                    }
                    if (player instanceof EntityPlayerMP) {
                        experience = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                        if (experience < 0) {
                            return WrenchResult.Nothing;
                        }
                    } else {
                        experience = 0;
                    }
                    block.func_176208_a(world, pos, state, player);
                    if (!block.removedByPlayer(world, pos, player, true)) {
                        return WrenchResult.Nothing;
                    }
                    block.func_176206_d(world, pos, state);
                    List<ItemStack> drops = wrenchable.getWrenchDrops(world, pos, state, te, player, 0);
                    for (ItemStack stack : drops) {
                        StackUtil.dropAsEntity(world, pos, stack);
                    }
                    if (!player.field_71075_bZ.field_75098_d && experience > 0) {
                        block.func_180637_b(world, pos, experience);
                    }
                }
                return WrenchResult.Removed;
            }
        }
        if (block.rotateBlock(world, pos, side)) {
            return WrenchResult.Rotated;
        }
        return WrenchResult.Nothing;
    }

    public void damage(ItemStack is, int damage, EntityPlayer player) {
        is.func_77972_a(damage, (EntityLivingBase)player);
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    private static enum WrenchResult {
        Rotated,
        Removed,
        Nothing;

    }
}

