/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.item.tool.ItemObscurator;
import ic2.core.model.MaskOverlayModel;
import ic2.core.model.ModelUtil;
import ic2.core.util.StackUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderObscurator
extends MaskOverlayModel {
    private static final ResourceLocation baseModelLoc = new ResourceLocation("ic2", "item/tool/electric/obscurator_raw");
    private static final ResourceLocation maskTextureLoc = new ResourceLocation("ic2", "textures/items/tool/electric/obscurator_mask.png");

    public RenderObscurator() {
        super(baseModelLoc, maskTextureLoc, true, 0.001f);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        ItemObscurator.ObscuredRenderInfo renderInfo;
        if (stack == null) {
            return ModelUtil.getMissingModel();
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        IBlockState state = ItemObscurator.getState(nbt);
        EnumFacing side = ItemObscurator.getSide(nbt);
        int[] colorMultipliers = ItemObscurator.getColorMultipliers(nbt);
        if (state == null || side == null || (renderInfo = ItemObscurator.getRenderInfo(state, side)) == null || colorMultipliers == null || colorMultipliers.length * 4 != renderInfo.uvs.length) {
            return this.get();
        }
        return this.get(renderInfo.uvs, colorMultipliers);
    }
}

