/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import com.google.common.base.Predicate;
import ic2.core.IC2;
import ic2.core.Ic2Player;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.util.LogCategory;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class StackUtil {
    private static final int[] emptySlotArray = new int[0];
    static final Set<String> ignoredNbtKeys = new HashSet<String>(Arrays.asList("damage", "charge", "energy"));

    public static AdjacentInv getAdjacentInventory(TileEntity source, EnumFacing dir) {
        TileEntity target = source.func_145831_w().func_175625_s(source.func_174877_v().func_177972_a(dir));
        if (!(target instanceof IInventory)) {
            return null;
        }
        IInventory inventory = (IInventory)target;
        if (target instanceof TileEntityChest && (inventory = Blocks.field_150486_ae.func_180676_d(source.func_145831_w(), target.func_174877_v())) == null) {
            return null;
        }
        if (target instanceof IPersonalBlock) {
            if (source instanceof IPersonalBlock) {
                if (!((IPersonalBlock)target).permitsAccess(((IPersonalBlock)source).getOwner())) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return new AdjacentInv(inventory, dir);
    }

    public static List<AdjacentInv> getAdjacentInventories(TileEntity source) {
        ArrayList<AdjacentInv> inventories = new ArrayList<AdjacentInv>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            AdjacentInv inventory = StackUtil.getAdjacentInventory(source, dir);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        Collections.sort(inventories, new Comparator<AdjacentInv>(){

            @Override
            public int compare(AdjacentInv a, AdjacentInv b) {
                if (a.inv instanceof IPersonalBlock || !(b.inv instanceof IPersonalBlock)) {
                    return -1;
                }
                if (b.inv instanceof IPersonalBlock || !(a.inv instanceof IPersonalBlock)) {
                    return 1;
                }
                return b.inv.func_70302_i_() - a.inv.func_70302_i_();
            }
        });
        return inventories;
    }

    public static int distribute(TileEntity source, ItemStack stack, boolean simulate) {
        int transferred = 0;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            int amount = StackUtil.putInInventory(inventory.inv, inventory.dir.func_176734_d(), stack, simulate);
            transferred += amount;
            stack.field_77994_a -= amount;
            if (stack.field_77994_a != 0) continue;
            break;
        }
        stack.field_77994_a += transferred;
        return transferred;
    }

    public static ItemStack fetch(TileEntity source, ItemStack stack, boolean simulate) {
        ItemStack ret = null;
        int oldStackSize = stack.field_77994_a;
        for (AdjacentInv inventory : StackUtil.getAdjacentInventories(source)) {
            ItemStack transferred = StackUtil.getFromInventory(inventory.inv, inventory.dir.func_176734_d(), stack, stack.field_77994_a, true, simulate);
            if (transferred == null) continue;
            if (ret == null) {
                ret = transferred;
            } else {
                ret.field_77994_a += transferred.field_77994_a;
                stack.field_77994_a -= transferred.field_77994_a;
            }
            if (stack.field_77994_a > 0) continue;
            break;
        }
        stack.field_77994_a = oldStackSize;
        return ret;
    }

    public static int transfer(IInventory src, IInventory dst, EnumFacing dir, int amount) {
        EnumFacing reverseDir = dir.func_176734_d();
        int[] srcSlots = StackUtil.getInventorySlots(src, dir, false, true);
        int[] dstSlots = StackUtil.getInventorySlots(dst, reverseDir, true, false);
        ISidedInventory dstSided = dst instanceof ISidedInventory ? (ISidedInventory)dst : null;
        int total = amount;
        block0: for (int srcSlot : srcSlots) {
            ItemStack srcStack = src.func_70301_a(srcSlot);
            if (srcStack == null) continue;
            int srcTransfer = Math.min(amount, srcStack.field_77994_a);
            assert (srcTransfer > 0);
            for (int pass = 0; pass < 2; ++pass) {
                for (int i = 0; i < dstSlots.length; ++i) {
                    int transfer;
                    int dstSlot = dstSlots[i];
                    if (dstSlot < 0) continue;
                    ItemStack dstStack = dst.func_70301_a(dstSlot);
                    if (pass == 0 && (dstStack == null || !StackUtil.isStackEqualStrict(srcStack, dstStack)) || pass == 1 && dstStack != null || !dst.func_94041_b(dstSlot, srcStack) || dstSided != null && !dstSided.func_180462_a(dstSlot, srcStack, reverseDir)) continue;
                    assert (srcTransfer > 0);
                    if (dstStack == null) {
                        transfer = Math.min(srcTransfer, dst.func_70297_j_());
                        dst.func_70299_a(dstSlot, StackUtil.copyWithSize(srcStack, transfer));
                    } else {
                        transfer = Math.min(srcTransfer, Math.min(dstStack.func_77976_d(), dst.func_70297_j_()) - dstStack.field_77994_a);
                        if (transfer <= 0) {
                            dstSlots[i] = -1;
                            continue;
                        }
                        dstStack.field_77994_a += transfer;
                    }
                    assert (transfer > 0);
                    srcStack.field_77994_a -= transfer;
                    amount -= transfer;
                    if ((srcTransfer -= transfer) <= 0) {
                        if (srcStack.field_77994_a <= 0) {
                            src.func_70299_a(srcSlot, null);
                        }
                        if (amount > 0) continue block0;
                        break block0;
                    }
                    assert (srcStack.field_77994_a > 0);
                    assert (amount > 0);
                }
            }
        }
        amount = total - amount;
        assert (amount >= 0);
        if (amount > 0) {
            src.func_70296_d();
            dst.func_70296_d();
        }
        return amount;
    }

    public static void distributeDrops(TileEntity source, List<ItemStack> stacks) {
        Iterator<ItemStack> it = stacks.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            int amount = StackUtil.distribute(source, stack, false);
            if (amount == stack.field_77994_a) {
                it.remove();
                continue;
            }
            stack.field_77994_a -= amount;
        }
        for (ItemStack stack : stacks) {
            StackUtil.dropAsEntity(source.func_145831_w(), source.func_174877_v(), stack);
        }
        stacks.clear();
    }

    public static ItemStack getFromInventory(IInventory inv, EnumFacing side, ItemStack stackDestination, int max, boolean ignoreMaxStackSize, boolean simulate) {
        if (stackDestination != null && !ignoreMaxStackSize) {
            max = Math.min(max, stackDestination.func_77976_d() - stackDestination.field_77994_a);
        }
        ItemStack ret = null;
        for (int i : StackUtil.getInventorySlots(inv, side, false, true)) {
            if (max <= 0) break;
            ItemStack stack = inv.func_70301_a(i);
            assert (stack != null);
            if (stackDestination != null && !StackUtil.isStackEqualStrict(stack, stackDestination)) continue;
            if (ret == null) {
                ret = StackUtil.copyWithSize(stack, 0);
                if (stackDestination == null) {
                    if (!ignoreMaxStackSize) {
                        max = Math.min(max, ret.func_77976_d());
                    }
                    stackDestination = ret;
                }
            }
            int transfer = Math.min(max, stack.field_77994_a);
            if (!simulate) {
                stack.field_77994_a -= transfer;
                if (stack.field_77994_a == 0) {
                    inv.func_70299_a(i, null);
                }
            }
            max -= transfer;
            ret.field_77994_a += transfer;
        }
        if (!simulate && ret != null) {
            inv.func_70296_d();
        }
        return ret;
    }

    public static int putInInventory(IInventory inv, EnumFacing side, ItemStack stackSource, boolean simulate) {
        int transfer;
        ItemStack stack;
        int[] slots;
        if (stackSource == null) {
            return 0;
        }
        int toTransfer = stackSource.field_77994_a;
        for (int i : slots = StackUtil.getInventorySlots(inv, side, true, false)) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, stackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_180462_a(i, stackSource, side) || (stack = inv.func_70301_a(i)) == null || !StackUtil.isStackEqualStrict(stack, stackSource)) continue;
            transfer = Math.min(toTransfer, Math.min(inv.func_70297_j_(), stack.func_77976_d()) - stack.field_77994_a);
            if (!simulate) {
                stack.field_77994_a += transfer;
            }
            toTransfer -= transfer;
        }
        for (int i : slots) {
            if (toTransfer <= 0) break;
            if (!inv.func_94041_b(i, stackSource) || inv instanceof ISidedInventory && !((ISidedInventory)inv).func_180462_a(i, stackSource, side) || (stack = inv.func_70301_a(i)) != null) continue;
            transfer = Math.min(toTransfer, Math.min(inv.func_70297_j_(), stackSource.func_77976_d()));
            if (!simulate) {
                ItemStack dest = StackUtil.copyWithSize(stackSource, transfer);
                inv.func_70299_a(i, dest);
            }
            toTransfer -= transfer;
        }
        if (!simulate && toTransfer != stackSource.field_77994_a) {
            inv.func_70296_d();
        }
        return stackSource.field_77994_a - toTransfer;
    }

    public static int[] getInventorySlots(IInventory inv, EnumFacing side, boolean checkInsert, boolean checkExtract) {
        int[] ret;
        ISidedInventory sidedInv;
        if (inv.func_70297_j_() <= 0) {
            return emptySlotArray;
        }
        if (inv instanceof ISidedInventory) {
            sidedInv = (ISidedInventory)inv;
            ret = sidedInv.func_180463_a(side);
            if (ret.length == 0) {
                return emptySlotArray;
            }
            ret = Arrays.copyOf(ret, ret.length);
        } else {
            int size = inv.func_70302_i_();
            if (size <= 0) {
                return emptySlotArray;
            }
            sidedInv = null;
            ret = new int[size];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = i;
            }
        }
        if (checkInsert || checkExtract) {
            int writeIdx = 0;
            for (int readIdx = 0; readIdx < ret.length; ++readIdx) {
                int slot = ret[readIdx];
                ItemStack stack = inv.func_70301_a(slot);
                if (checkExtract && (stack == null || stack.field_77994_a <= 0 || sidedInv != null && !sidedInv.func_180461_b(slot, stack, side)) || checkInsert && stack != null && (stack.field_77994_a >= stack.func_77976_d() || stack.field_77994_a >= inv.func_70297_j_() || sidedInv != null && !sidedInv.func_180462_a(slot, stack, side))) continue;
                ret[writeIdx] = slot;
                ++writeIdx;
            }
            if (writeIdx != ret.length) {
                ret = Arrays.copyOf(ret, writeIdx);
            }
        }
        return ret;
    }

    public static boolean consumeFromPlayerInventory(EntityPlayer player, Predicate<ItemStack> request, int amount, boolean simulate) {
        ItemStack[] contents = player.field_71071_by.field_70462_a;
        for (int pass = 0; pass < 2; ++pass) {
            int amountNeeded = amount;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack stack = contents[i];
                if (!request.apply((Object)stack)) continue;
                if (player.field_71075_bZ.field_75098_d) {
                    return true;
                }
                int cAmount = Math.min(stack.field_77994_a, amountNeeded);
                amountNeeded -= cAmount;
                if (pass == 1) {
                    if (stack.field_77994_a == cAmount) {
                        contents[i] = null;
                    } else {
                        contents[i].field_77994_a -= cAmount;
                    }
                }
                if (amountNeeded <= 0) break;
            }
            if (amountNeeded > 0) {
                if (pass == 1) {
                    IC2.log.warn(LogCategory.General, "Inconsistent inventory transaction for player %s, request %s: %d missing", player, request, amountNeeded);
                }
                return false;
            }
            if (!simulate) continue;
            return true;
        }
        return true;
    }

    public static Predicate<ItemStack> sameStack(final ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        return new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return StackUtil.checkItemEquality(input, stack);
            }

            public String toString() {
                return "stack==" + stack;
            }
        };
    }

    public static Predicate<ItemStack> sameItem(final Item item) {
        if (item == null) {
            throw new NullPointerException("null item");
        }
        return new Predicate<ItemStack>(){

            public boolean apply(ItemStack input) {
                return input.func_77973_b() == item;
            }

            public String toString() {
                return "item==" + item;
            }
        };
    }

    public static Predicate<ItemStack> sameItem(Block block) {
        if (block == null) {
            throw new NullPointerException("null block");
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            throw new IllegalArgumentException("block " + block + " doesn't have an associated item");
        }
        return StackUtil.sameItem(item);
    }

    public static ItemStack consumeFromPlayerHand(EntityPlayer player, Predicate<ItemStack> request, int amount) {
        ItemStack stack = player.func_71045_bC();
        if (stack == null || !StackUtil.check(stack)) {
            return null;
        }
        if (!request.apply((Object)stack)) {
            return null;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        if (stack.field_77994_a < amount) {
            return null;
        }
        stack.field_77994_a -= amount;
        if (stack.field_77994_a == 0) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
        }
        return stack;
    }

    public static void dropAsEntity(World world, BlockPos pos, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        double f = 0.7;
        double dx = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dy = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        double dz = (double)world.field_73012_v.nextFloat() * f + (1.0 - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack.func_77946_l());
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack copyWithSize(ItemStack stack, int newSize) {
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static ItemStack copyWithWildCard(ItemStack stack) {
        ItemStack ret = stack.func_77946_l();
        StackUtil.setRawMeta(ret, Short.MAX_VALUE);
        return ret;
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack stack) {
        NBTTagCompound ret = stack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            stack.func_77982_d(ret);
        }
        return ret;
    }

    public static boolean checkItemEquality(ItemStack a, ItemStack b) {
        return a == b || a != null && b != null && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j()) && StackUtil.checkNbtEquality(a, b);
    }

    public static boolean checkItemEquality(ItemStack a, Item b) {
        return a == null && b == null || a != null && b != null && a.func_77973_b() == b;
    }

    public static boolean checkItemEqualityStrict(ItemStack a, ItemStack b) {
        return a == b || a != null && b != null && a.func_77969_a(b) && StackUtil.checkNbtEqualityStrict(a, b);
    }

    private static boolean checkNbtEquality(ItemStack a, ItemStack b) {
        NBTTagCompound nbtB;
        NBTTagCompound nbtA = a.func_77978_p();
        if (nbtA == (nbtB = b.func_77978_p())) {
            return true;
        }
        Set keysA = nbtA != null ? nbtA.func_150296_c() : Collections.emptySet();
        Set keysB = nbtB != null ? nbtB.func_150296_c() : Collections.emptySet();
        HashSet<String> toCheck = new HashSet<String>(Math.max(keysA.size(), keysB.size()));
        for (String key : keysA) {
            if (ignoredNbtKeys.contains(key)) continue;
            if (!keysB.contains(key)) {
                return false;
            }
            toCheck.add(key);
        }
        for (String key : keysB) {
            if (ignoredNbtKeys.contains(key)) continue;
            if (!keysA.contains(key)) {
                return false;
            }
            toCheck.add(key);
        }
        for (String key : toCheck) {
            if (nbtA.func_74781_a(key).equals((Object)nbtB.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkNbtEqualityStrict(ItemStack a, ItemStack b) {
        NBTTagCompound nbtB;
        NBTTagCompound nbtA = a.func_77978_p();
        if (nbtA == (nbtB = b.func_77978_p())) {
            return true;
        }
        return nbtA != null && nbtB != null && nbtA.equals((Object)nbtB);
    }

    @Deprecated
    public static boolean areStacksEqual(ItemStack a, ItemStack b) {
        return a == null && b == null || a != null && b != null && !a.func_77969_a(b);
    }

    @Deprecated
    public static boolean isStackEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 == null && stack2 == null || stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() && !stack1.func_77984_f() || stack1.func_77952_i() == stack2.func_77952_i());
    }

    @Deprecated
    public static boolean isStackEqualStrict(ItemStack stack1, ItemStack stack2) {
        return StackUtil.isStackEqual(stack1, stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean isTagEqual(ItemStack a, ItemStack b) {
        boolean bEmpty;
        boolean aEmpty = !a.func_77942_o() || a.func_77978_p().func_82582_d();
        boolean bl = bEmpty = !b.func_77942_o() || b.func_77978_p().func_82582_d();
        if (aEmpty != bEmpty) {
            return false;
        }
        if (aEmpty) {
            return true;
        }
        return a.func_77978_p().equals((Object)b.func_77978_p());
    }

    public static ItemStack getPickStack(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        Block block = state.func_177230_c();
        MovingObjectPosition target = new MovingObjectPosition(MovingObjectPosition.MovingObjectType.BLOCK, new Vec3((Vec3i)pos), EnumFacing.DOWN, pos);
        ItemStack ret = FMLCommonHandler.instance().getSide().isClient() ? block.getPickBlock(target, world, pos, player) : new ItemStack(block, 1, block.func_176201_c(state));
        if (ret == null || !StackUtil.check(ret)) {
            return null;
        }
        return ret;
    }

    public static List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return state.func_177230_c().getDrops(world, pos, state, fortune);
    }

    public static List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, EntityPlayer player, int fortune, boolean silkTouch) {
        ItemStack drop;
        Block block = state.func_177230_c();
        if (block.isAir(world, pos)) {
            return Collections.emptyList();
        }
        World rawWorld = null;
        if (silkTouch) {
            rawWorld = Util.getWorld(world);
            if (rawWorld == null) {
                throw new IllegalArgumentException("invalid world for silk touch: " + world);
            }
            if (player == null) {
                player = Ic2Player.get(rawWorld);
            }
        }
        if (silkTouch && block.canSilkHarvest(rawWorld, pos, state, player) && (drop = StackUtil.getPickStack(rawWorld, pos, state, player)) != null) {
            return new ArrayList<ItemStack>(Arrays.asList(drop));
        }
        return StackUtil.getDrops(world, pos, state, fortune);
    }

    public static boolean placeBlock(ItemStack stack, World world, BlockPos pos) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (item instanceof ItemBlock || item instanceof ItemReed) {
            int oldSize = stack.field_77994_a;
            boolean ret = item.func_180614_a(stack, (EntityPlayer)Ic2Player.get(world), world, pos, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
            stack.field_77994_a = oldSize;
            return ret;
        }
        return false;
    }

    @Deprecated
    public static Block getBlock(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    @Deprecated
    public static IBlockState getBlockState(ItemStack stack) {
        return StackUtil.getBlock(stack).func_176203_a(stack.func_77952_i());
    }

    @Deprecated
    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtil.getBlock(stack);
    }

    public static boolean damageItemStack(ItemStack stack, int amount) {
        if (stack.func_96631_a(amount, IC2.random)) {
            --stack.field_77994_a;
            stack.func_77964_b(0);
            return stack.field_77994_a <= 0;
        }
        return false;
    }

    public static boolean check2(Iterable<List<ItemStack>> list) {
        for (List<ItemStack> list2 : list) {
            if (StackUtil.check(list2)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack[] array) {
        return StackUtil.check(Arrays.asList(array));
    }

    public static boolean check(Iterable<ItemStack> list) {
        for (ItemStack stack : list) {
            if (StackUtil.check(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean check(ItemStack stack) {
        return stack.func_77973_b() != null;
    }

    public static String toStringSafe2(Iterable<List<ItemStack>> list) {
        String ret = "[";
        for (List<ItemStack> list2 : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(list2);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack[] array) {
        return StackUtil.toStringSafe(Arrays.asList(array));
    }

    public static String toStringSafe(Iterable<ItemStack> list) {
        String ret = "[";
        for (ItemStack stack : list) {
            if (ret.length() > 1) {
                ret = ret + ", ";
            }
            ret = ret + StackUtil.toStringSafe(stack);
        }
        ret = ret + "]";
        return ret;
    }

    public static String toStringSafe(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return stack.field_77994_a + "x(null)@(unknown)";
        }
        return stack.toString();
    }

    @Deprecated
    public static void consumeInventoryItem(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(stack)) continue;
            player.field_71071_by.func_70298_a(i, 1);
            return;
        }
    }

    public static boolean storeInventoryItem(ItemStack stack, EntityPlayer player, boolean simulate) {
        if (simulate) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack invStack = player.field_71071_by.field_70462_a[i];
                if (invStack != null && (!StackUtil.checkItemEqualityStrict(stack, invStack) || invStack.field_77994_a + stack.field_77994_a > Math.min(player.field_71071_by.func_70297_j_(), invStack.func_77976_d()))) continue;
                return true;
            }
        } else if (player.field_71071_by.func_70441_a(stack)) {
            return true;
        }
        return false;
    }

    public static int getRawMeta(ItemStack stack) {
        return Items.field_151100_aR.getDamage(stack);
    }

    public static void setRawMeta(ItemStack stack, int meta) {
        if (meta < 0) {
            throw new IllegalArgumentException("negative meta");
        }
        Items.field_151100_aR.setDamage(stack, meta);
    }

    public static void copyStack(ItemStack src, ItemStack dst) {
        dst.func_150996_a(src.func_77973_b());
        StackUtil.setRawMeta(dst, StackUtil.getRawMeta(src));
        dst.func_77982_d(src.func_77978_p());
    }

    public static class AdjacentInv {
        public final IInventory inv;
        public final EnumFacing dir;

        private AdjacentInv(IInventory inv, EnumFacing dir) {
            this.inv = inv;
            this.dir = dir;
        }
    }
}

