/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.core.IC2;
import ic2.core.Ic2Player;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import ic2.core.util.ItemComparableItemStack;
import ic2.core.util.LogCategory;
import ic2.core.util.PriorityExecutor;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class DropScan {
    private EntityPlayer player;
    private final Map<ItemComparableItemStack, MutableInt> drops = new HashMap<ItemComparableItemStack, MutableInt>();
    private static final ConcurrentMap<IBlockState, DropDesc> typicalDrops = new ConcurrentHashMap<IBlockState, DropDesc>();
    private static final Object generatorLock = new Object();
    private static AtomicInteger uuScanProgress = new AtomicInteger();
    private static int uuScanAmount;

    public static void start(World world, int area, int areaCount, int range) {
        if (range < 3) {
            throw new IllegalArgumentException("range has to be at least 3");
        }
        uuScanProgress.set(0);
        uuScanAmount = areaCount;
        ArrayList<Callable<Calculation>> tasks = new ArrayList<Callable<Calculation>>(areaCount);
        for (int i = 0; i < areaCount; ++i) {
            int x = IC2.random.nextInt(area) - area / 2;
            int z = IC2.random.nextInt(area) - area / 2;
            tasks.add(new Calculation(world, x, z, range));
        }
        List futures = IC2.getInstance().threadPool.submitAll(tasks);
        DropScan.analyze(futures);
    }

    private static void analyze(List<? extends Future<Iterable<ItemStack>>> futures) {
        double normalizeBy;
        HashMap<ItemComparableItemStack, MutableLong> result = new HashMap<ItemComparableItemStack, MutableLong>();
        for (Future<Iterable<ItemStack>> future : futures) {
            try {
                Iterable<ItemStack> partialResult = future.get();
                for (ItemStack stack : partialResult) {
                    ItemComparableItemStack key = new ItemComparableItemStack(stack, false);
                    MutableLong amount = (MutableLong)result.get(key);
                    if (amount == null) {
                        amount = new MutableLong();
                        result.put(key.copy(), amount);
                    }
                    amount.add((long)stack.field_77994_a);
                }
            }
            catch (Exception e) {
                IC2.log.warn(LogCategory.Uu, e, "Scan failed.");
            }
        }
        ItemComparableItemStack cobblestone = new ItemComparableItemStack(new ItemStack(Blocks.field_150347_e), false);
        ItemComparableItemStack netherrack = new ItemComparableItemStack(new ItemStack(Blocks.field_150424_aL), false);
        if (!result.containsKey(cobblestone)) {
            if (!result.containsKey(netherrack)) {
                IC2.log.warn(LogCategory.Uu, "UU scan failed, there was no cobblestone or netherrack dropped");
                return;
            }
            normalizeBy = ((MutableLong)result.get(netherrack)).getValue().longValue();
        } else {
            normalizeBy = ((MutableLong)result.get(cobblestone)).getValue().longValue();
            if (result.containsKey(netherrack)) {
                normalizeBy = Math.max(normalizeBy, (double)((MutableLong)result.get(netherrack)).getValue().longValue());
            }
        }
        Config config = MainConfig.get().getSub("balance/uu-values/world scan");
        if (config == null) {
            config = MainConfig.get().getSub("balance/uu-values").addSub("world scan", "Initial uu values from scanning the world.\nRun /ic2 uu-world-scan <small|medium|large> to calibrate them for your world.\nDelete this whole section to revert to the default predefined values.");
        }
        ArrayList sorted = new ArrayList(result.entrySet());
        result.clear();
        Collections.sort(sorted, new Comparator<Map.Entry<ItemComparableItemStack, MutableLong>>(){

            @Override
            public int compare(Map.Entry<ItemComparableItemStack, MutableLong> a, Map.Entry<ItemComparableItemStack, MutableLong> b) {
                return Long.compare(b.getValue().getValue(), a.getValue().getValue());
            }
        });
        IC2.log.info(LogCategory.Uu, "total");
        for (Map.Entry entry : sorted) {
            ItemStack stack = ((ItemComparableItemStack)entry.getKey()).toStack();
            long count = ((MutableLong)entry.getValue()).getValue();
            IC2.log.info(LogCategory.Uu, "%d %s", count, stack.func_77973_b().func_77653_i(stack));
            config.set(ConfigUtil.fromStack(stack), normalizeBy / (double)count);
        }
        MainConfig.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<ItemStack> scanArea(World originalWorld, int xStart, int zStart, int range) {
        IChunkProvider generator;
        DummyWorld world = new DummyWorld(originalWorld, range);
        world.getChunkProvider().generator = generator = world.field_73011_w.func_76555_c();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(Util.square(range));
        ArrayList<Chunk> pendingChunks = new ArrayList<Chunk>(Util.square(range - 2));
        Object object = generatorLock;
        synchronized (object) {
            for (int x = xStart; x < xStart + range; ++x) {
                for (int i = zStart; i < zStart + range; ++i) {
                    Chunk chunk = generator.func_73154_d(x, i);
                    chunks.add(chunk);
                    if (x == xStart || x == xStart + range || i == zStart || i == zStart + range) continue;
                    pendingChunks.add(chunk);
                }
            }
            world.getChunkProvider().setChunks(chunks, xStart, zStart);
            for (Chunk chunk : pendingChunks) {
                chunk.func_76624_a((IChunkProvider)world.getChunkProvider(), (IChunkProvider)world.getChunkProvider(), chunk.field_76635_g, chunk.field_76647_h);
            }
            world.getChunkProvider().disableGenerate();
        }
        this.player = Ic2Player.get(world);
        for (Chunk chunk : pendingChunks) {
            this.scanChunk(world, chunk);
        }
        world.getChunkProvider().clear();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.drops.size());
        for (Map.Entry entry : this.drops.entrySet()) {
            ItemComparableItemStack isw = (ItemComparableItemStack)entry.getKey();
            int count = ((MutableInt)entry.getValue()).getValue();
            stacks.add(isw.toStack(count));
        }
        Collections.sort(stacks, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack a, ItemStack b) {
                return b.field_77994_a - a.field_77994_a;
            }
        });
        return stacks;
    }

    private void scanChunk(DummyWorld world, Chunk chunk) {
        assert (world.func_72964_e(chunk.field_76635_g, chunk.field_76647_h) == chunk);
        int xMax = (chunk.field_76635_g + 1) * 16;
        int yMax = world.func_72800_K();
        int zMax = (chunk.field_76647_h + 1) * 16;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < yMax; ++y) {
            for (int z = chunk.field_76647_h * 16; z < zMax; ++z) {
                for (int x = chunk.field_76635_g * 16; x < xMax; ++x) {
                    pos.func_181079_c(x, y, z);
                    IBlockState state = chunk.func_177435_g((BlockPos)pos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150350_a) continue;
                    for (ItemStack drop : this.getDrops(world, (BlockPos)pos, block, state)) {
                        this.addDrop(drop);
                    }
                }
            }
        }
    }

    private List<ItemStack> getDrops(DummyWorld world, BlockPos pos, Block block, IBlockState state) {
        DropDesc typicalDrop = (DropDesc)typicalDrops.get(state);
        if (typicalDrop == null || typicalDrop.dropCount.get() < 1000) {
            DropDesc prevValue;
            block.func_176208_a((World)world, pos, state, this.player);
            if (block.removedByPlayer((World)world, pos, this.player, true)) {
                block.func_176206_d((World)world, pos, state);
                block.func_176226_b((World)world, pos, state, 0);
            } else {
                IC2.log.info(LogCategory.Uu, "Can't harvest %s.", block);
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(world.spawnedEntities.size());
            for (Entity entity : world.spawnedEntities) {
                if (!(entity instanceof EntityItem)) continue;
                drops.add(((EntityItem)entity).func_92059_d());
            }
            world.spawnedEntities.clear();
            if (typicalDrop == null && (prevValue = typicalDrops.putIfAbsent(state, typicalDrop = new DropDesc(drops))) != null) {
                typicalDrop = prevValue;
            }
            if (typicalDrop.dropCount.get() >= 0) {
                boolean equal;
                boolean bl = equal = typicalDrop.drops.size() == drops.size();
                if (equal) {
                    Iterator it = drops.iterator();
                    Iterator<ItemStack> it2 = typicalDrop.drops.iterator();
                    while (it.hasNext()) {
                        ItemStack b;
                        ItemStack a = (ItemStack)it.next();
                        if (ItemStack.func_77989_b((ItemStack)a, (ItemStack)(b = it2.next()))) continue;
                        equal = false;
                        break;
                    }
                }
                if (equal) {
                    int prev = typicalDrop.dropCount.incrementAndGet();
                    if (prev < 0) {
                        typicalDrop.dropCount.set(Integer.MIN_VALUE);
                    }
                } else {
                    typicalDrop.dropCount.set(Integer.MIN_VALUE);
                }
            }
            return drops;
        }
        return typicalDrop.drops;
    }

    private void addDrop(ItemStack stack) {
        ItemComparableItemStack key = new ItemComparableItemStack(stack, false);
        MutableInt amount = this.drops.get(key);
        if (amount == null) {
            amount = new MutableInt();
            this.drops.put(key.copy(), amount);
        }
        amount.add(stack.field_77994_a);
    }

    private static final class DropDesc {
        List<ItemStack> drops;
        AtomicInteger dropCount = new AtomicInteger();

        DropDesc(List<ItemStack> drops) {
            this.drops = drops;
        }
    }

    static class DummyChunkProvider
    implements IChunkProvider {
        private final World world;
        private final Chunk emptyChunk;
        private final Map<Long, Chunk> extraChunks = new HashMap<Long, Chunk>();
        private final Chunk[] chunks;
        private final int range;
        private int xStart;
        private int zStart;
        private boolean disableGenerate;
        public IChunkProvider generator;

        public DummyChunkProvider(World world, int range) {
            this.world = world;
            this.emptyChunk = new EmptyChunk(world, 0, 0);
            this.chunks = new Chunk[Util.square(range)];
            this.range = range;
        }

        public void setChunks(List<Chunk> newChunks, int xStart, int zStart) {
            this.clear();
            this.xStart = xStart;
            this.zStart = zStart;
            for (Chunk chunk : newChunks) {
                int index = this.getIndex(chunk.field_76635_g, chunk.field_76647_h);
                if (index < 0) {
                    throw new IllegalArgumentException("out of range");
                }
                this.chunks[index] = chunk;
            }
        }

        public void disableGenerate() {
            this.disableGenerate = true;
        }

        public void clear() {
            this.extraChunks.clear();
            Arrays.fill(this.chunks, null);
        }

        public boolean func_73157_c() {
            return false;
        }

        public boolean func_73149_a(int x, int z) {
            int index = this.getIndex(x, z);
            if (index >= 0) {
                return this.chunks[index] != null;
            }
            return this.extraChunks.containsKey(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        }

        public BlockPos func_180513_a(World world, String structureName, BlockPos position) {
            return null;
        }

        public int func_73152_e() {
            return 1;
        }

        public List<BiomeGenBase.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
            return Collections.emptyList();
        }

        public String func_73148_d() {
            return "Dummy";
        }

        public void func_73153_a(IChunkProvider provider, int x, int z) {
            Chunk chunk = this.func_73154_d(x, z);
            if (!chunk.func_177419_t()) {
                chunk.func_150809_p();
                if (this.generator != null) {
                    this.generator.func_73153_a(provider, x, z);
                    GameRegistry.generateWorld((int)x, (int)z, (World)this.world, (IChunkProvider)this.generator, (IChunkProvider)provider);
                    chunk.func_76630_e();
                }
            }
        }

        public Chunk func_73154_d(int x, int z) {
            int index = this.getIndex(x, z);
            Chunk ret = index >= 0 ? this.chunks[index] : this.extraChunks.get(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
            if (ret == null) {
                if (this.disableGenerate) {
                    return this.emptyChunk;
                }
                ret = this.generator.func_73154_d(x, z);
                if (index >= 0) {
                    this.chunks[index] = ret;
                } else {
                    this.extraChunks.put(ChunkCoordIntPair.func_77272_a((int)x, (int)z), ret);
                }
            }
            return ret;
        }

        public Chunk func_177459_a(BlockPos pos) {
            return this.func_73154_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }

        public void func_180514_a(Chunk chunk, int x, int z) {
        }

        public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
            return true;
        }

        public boolean func_177460_a(IChunkProvider provider, Chunk chunk, int x, int z) {
            if (this.generator != null && this.generator.func_177460_a(provider, chunk, x, z)) {
                chunk = this.func_73154_d(x, z);
                chunk.func_76630_e();
                return true;
            }
            return false;
        }

        public void func_104112_b() {
        }

        public boolean func_73156_b() {
            return false;
        }

        private int getIndex(int x, int z) {
            if ((x -= this.xStart) < 0 || x >= this.range || (z -= this.zStart) < 0 || z >= this.range) {
                return -1;
            }
            return x * this.range + z;
        }
    }

    static class DummyWorld
    extends World {
        List<Entity> spawnedEntities = new ArrayList<Entity>();

        public DummyWorld(World world, int range) {
            super(world.func_72860_G(), world.func_72912_H(), WorldProvider.func_76570_a((int)world.field_73011_w.func_177502_q()), world.field_72984_F, false);
            this.field_73020_y = new DummyChunkProvider(this, range);
        }

        public DummyChunkProvider getChunkProvider() {
            return (DummyChunkProvider)super.func_72863_F();
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public Entity func_73045_a(int i) {
            return null;
        }

        public boolean func_180501_a(BlockPos pos, IBlockState state, int flags) {
            if (pos.func_177956_o() >= 256 || pos.func_177956_o() < 0) {
                return false;
            }
            Chunk chunk = this.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunk.func_177436_a(pos, state) != null;
        }

        public boolean func_180500_c(EnumSkyBlock lightType, BlockPos pos) {
            return true;
        }

        public boolean func_72838_d(Entity entity) {
            this.spawnedEntities.add(entity);
            return true;
        }

        protected int func_152379_p() {
            return 3;
        }
    }

    static class Calculation
    implements Callable<Iterable<ItemStack>>,
    PriorityExecutor.CustomPriority {
        private final World world;
        private final int x;
        private final int z;
        private final int range;

        Calculation(World world1, int x1, int z1, int range1) {
            this.world = world1;
            this.x = x1;
            this.z = z1;
            this.range = range1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<ItemStack> call() throws Exception {
            Iterable ret;
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("Server thread");
            try {
                ret = new DropScan().scanArea(this.world, this.x, this.z, this.range);
            }
            finally {
                Thread.currentThread().setName(threadName);
            }
            int done = uuScanProgress.incrementAndGet();
            if (done % 50 == 0) {
                IC2.log.info(LogCategory.Uu, "World scan progress: %d%%.", 100 * done / uuScanAmount);
            }
            return ret;
        }

        @Override
        public PriorityExecutor.Priority getPriority() {
            return PriorityExecutor.Priority.Low;
        }
    }
}

