/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BasicSource
extends TileEntity
implements IEnergySource,
ITickable {
    public final TileEntity parent;
    protected double capacity;
    protected int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSource(TileEntity parent1, double capacity1, int tier1) {
        double power = EnergyNet.instance.getPowerFromTier(tier1);
        this.parent = parent1;
        this.capacity = capacity1 < power ? power : capacity1;
        this.tier = tier1;
    }

    public void func_73660_a() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !this.parent.func_145831_w().field_72995_K && Info.isIc2Available()) {
            this.field_145850_b = this.parent.func_145831_w();
            this.field_174879_c = this.parent.func_174877_v();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("IC2BasicSource");
        this.energyStored = data.func_74769_h("energy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        try {
            super.func_189515_b(tag);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energyStored);
        tag.func_74782_a("IC2BasicSource", (NBTBase)data);
        return tag;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity1) {
        double power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (capacity1 < power) {
            capacity1 = power;
        }
        this.capacity = capacity1;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier1) {
        double power = EnergyNet.instance.getPowerFromTier(tier1);
        if (this.capacity < power) {
            this.capacity = power;
        }
        this.tier = tier1;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public double getFreeCapacity() {
        return this.capacity - this.energyStored;
    }

    public double addEnergy(double amount) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        if (amount > this.capacity - this.energyStored) {
            amount = this.capacity - this.energyStored;
        }
        this.energyStored += amount;
        return amount;
    }

    public boolean charge(ItemStack stack) {
        if (stack == null || !Info.isIc2Available()) {
            return false;
        }
        double amount = ElectricItem.manager.charge(stack, this.energyStored, this.tier, false, false);
        this.energyStored -= amount;
        return amount > 0.0;
    }

    @Deprecated
    public void onupdate() {
        this.func_73660_a();
    }

    @Deprecated
    public void onInvalidate() {
        this.func_145843_s();
    }

    @Deprecated
    public void onOnChunkUnload() {
        this.onChunkUnload();
    }

    @Deprecated
    public void onReadFromNbt(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Deprecated
    public void onWriteToNbt(NBTTagCompound tag) {
        this.func_189515_b(tag);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.energyStored;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }
}

