/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BasicMachineRecipeManager
implements IMachineRecipeManager {
    private final Map<IRecipeInput, RecipeOutput> recipes = new HashMap<IRecipeInput, RecipeOutput>();

    @Override
    public void addRecipe(IRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] == null) {
                throw new NullPointerException("The output ItemStack #" + i + " is null (counting from 0)");
            }
            outputs[i] = outputs[i].func_77946_l();
        }
        for (IRecipeInput existingInput : this.recipes.keySet()) {
            for (ItemStack is : input.getInputs()) {
                if (!existingInput.matches(is)) continue;
                throw new RuntimeException("ambiguous recipe: [" + is + " -> " + Arrays.asList(outputs) + "]" + ", conflicts with [" + existingInput.getInputs() + " -> " + this.recipes.get((Object)existingInput).items + "]");
            }
        }
        this.recipes.put(input, new RecipeOutput(metadata, outputs));
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        if (input == null) {
            return null;
        }
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.recipes.entrySet()) {
            IRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(input)) continue;
            if (input.field_77994_a < recipeInput.getAmount() || input.func_77973_b().func_77634_r() && input.field_77994_a != recipeInput.getAmount()) break;
            if (adjustInput) {
                if (input.func_77973_b().func_77634_r()) {
                    ItemStack container = input.func_77973_b().getContainerItemStack(input);
                    input.field_77993_c = container.field_77993_c;
                    input.field_77994_a = container.field_77994_a;
                    input.func_77964_b(container.func_77960_j());
                    input.field_77990_d = container.field_77990_d;
                } else {
                    input.field_77994_a -= recipeInput.getAmount();
                }
            }
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<IRecipeInput, RecipeOutput> getRecipes() {
        return this.recipes;
    }
}

