/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotConsumableLinked;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.personal.ContainerEnergyOMatClosed;
import ic2.core.block.personal.ContainerEnergyOMatOpen;
import ic2.core.block.personal.GuiEnergyOMatClosed;
import ic2.core.block.personal.GuiEnergyOMatOpen;
import ic2.core.block.personal.IPersonalBlock;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityEnergyOMat
extends TileEntityInventory
implements IPersonalBlock,
IHasGui,
IEnergySink,
IEnergySource,
INetworkClientTileEntityEventListener {
    public int euOffer = 1000;
    public String owner = "null";
    private boolean addedToEnergyNet = false;
    public int paidFor;
    public double euBuffer;
    private int euBufferMax = 10000;
    private int maxOutputRate = 32;
    public final InvSlot demandSlot = new InvSlot(this, "demand", 0, InvSlot.Access.NONE, 1);
    public final InvSlotConsumableLinked inputSlot = new InvSlotConsumableLinked((TileEntityInventory)this, "input", 1, 1, this.demandSlot);
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, -1, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 2, 1);

    @Override
    public String func_70303_b() {
        return "Energy-O-Mat";
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.owner = nbttagcompound.func_74779_i("owner");
        this.euOffer = nbttagcompound.func_74762_e("euOffer");
        this.paidFor = nbttagcompound.func_74762_e("paidFor");
        try {
            this.euBuffer = nbttagcompound.func_74769_h("euBuffer");
        }
        catch (Exception e) {
            this.euBuffer = nbttagcompound.func_74762_e("euBuffer");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74768_a("euOffer", this.euOffer);
        nbttagcompound.func_74768_a("paidFor", this.paidFor);
        nbttagcompound.func_74780_a("euBuffer", this.euBuffer);
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return this.permitsAccess(entityPlayer);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (IC2.platform.isSimulating()) {
            int sent;
            int transferred;
            ItemStack tradedIn;
            boolean invChanged = false;
            this.euBufferMax = 10000;
            this.maxOutputRate = 32;
            this.chargeSlot.setTier(1);
            if (!this.upgradeSlot.isEmpty()) {
                if (this.upgradeSlot.get().func_77969_a(Ic2Items.energyStorageUpgrade)) {
                    this.euBufferMax = 10000 * (this.upgradeSlot.get().field_77994_a + 1);
                } else if (this.upgradeSlot.get().func_77969_a(Ic2Items.transformerUpgrade)) {
                    this.maxOutputRate = 32 * (int)Math.pow(4.0, Math.min(4, this.upgradeSlot.get().field_77994_a));
                    this.chargeSlot.setTier(1 + this.upgradeSlot.get().field_77994_a);
                }
            }
            if ((tradedIn = this.inputSlot.consumeLinked(true)) != null && (transferred = StackUtil.distribute(this, tradedIn, true)) == tradedIn.field_77994_a) {
                StackUtil.distribute(this, this.inputSlot.consumeLinked(false), false);
                this.paidFor += this.euOffer;
                invChanged = true;
            }
            if (this.euBuffer >= 1.0 && (sent = this.chargeSlot.charge((int)this.euBuffer)) > 0) {
                this.euBuffer -= (double)sent;
                invChanged = true;
            }
            if (invChanged) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public boolean permitsAccess(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.owner.equals("null")) {
            if (IC2.platform.isSimulating()) {
                this.owner = player.field_71092_bJ;
                IC2.network.updateTileEntityField(this, "owner");
            }
            return true;
        }
        if (MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71262_S()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.field_71092_bJ);
    }

    @Override
    public boolean permitsAccess(String username) {
        return this.owner.equals(username);
    }

    @Override
    public String getUsername() {
        return this.owner;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side && this.permitsAccess(entityPlayer);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.facingMatchesDirection(direction);
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min((double)this.maxOutputRate, this.euBuffer);
    }

    @Override
    public void drawEnergy(double amount) {
        this.euBuffer -= amount;
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.min((double)this.paidFor, (double)this.euBufferMax - this.euBuffer);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        double toAdd = Math.min(Math.min(amount, (double)this.paidFor), (double)this.euBufferMax - this.euBuffer);
        this.paidFor = (int)((double)this.paidFor - toAdd);
        this.euBuffer += toAdd;
        return amount - toAdd;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        if (this.permitsAccess(entityPlayer)) {
            return new ContainerEnergyOMatOpen(entityPlayer, this);
        }
        return new ContainerEnergyOMatClosed(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        if (this.permitsAccess(entityPlayer)) {
            return new GuiEnergyOMatOpen(new ContainerEnergyOMatOpen(entityPlayer, this));
        }
        return new GuiEnergyOMatClosed(new ContainerEnergyOMatClosed(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (!this.permitsAccess(player)) {
            return;
        }
        switch (event) {
            case 0: {
                this.attemptSet(-100000);
                break;
            }
            case 1: {
                this.attemptSet(-10000);
                break;
            }
            case 2: {
                this.attemptSet(-1000);
                break;
            }
            case 3: {
                this.attemptSet(-100);
                break;
            }
            case 4: {
                this.attemptSet(100000);
                break;
            }
            case 5: {
                this.attemptSet(10000);
                break;
            }
            case 6: {
                this.attemptSet(1000);
                break;
            }
            case 7: {
                this.attemptSet(100);
            }
        }
    }

    private void attemptSet(int amount) {
        this.euOffer += amount;
        if (this.euOffer < 100) {
            this.euOffer = 100;
        }
    }
}

