/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.migration;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.init.DefaultIds;
import ic2.core.init.InternalName;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockMigrate
extends Block {
    private final boolean wildcardMeta;
    private final Integer[] newIds;

    public BlockMigrate(Configuration config, InternalName internalName, boolean wildcardMeta1, Integer ... newIds1) {
        super(IC2.getBlockIdFor(config, internalName, DefaultIds.get(internalName)), Material.field_76243_f);
        this.wildcardMeta = wildcardMeta1;
        this.newIds = newIds1;
        this.func_71907_b(true);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        this.migrate(world, x, y, z);
    }

    public boolean migrate(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (!(this.wildcardMeta || meta < this.newIds.length && this.newIds[meta] != null)) {
            IC2.log.warning("can't migrate block " + this.field_71990_ca + ":" + meta + " at " + x + "/" + y + "/" + z + ", no id mapping");
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityBlock) {
            world.func_72832_d(x, y, z, Ic2Items.teBlock.field_77993_c, 0, 6);
            ((TileEntityBlock)te).tileEntityId = this.newIds[this.wildcardMeta ? 0 : meta];
            return true;
        }
        IC2.log.warning("can't migrate block " + this.field_71990_ca + ":" + meta + " at " + x + "/" + y + "/" + z + ", no suitable te");
        return false;
    }
}

