/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.core.IC2;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class DataEncoder {
    public static Object decode(DataInputStream is) throws IOException {
        byte type = is.readByte();
        switch (type) {
            case 0: {
                return is.readInt();
            }
            case 1: {
                int length = is.readShort();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readInt();
                }
                return data;
            }
            case 2: {
                return is.readShort();
            }
            case 3: {
                int length = is.readShort();
                short[] data = new short[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readShort();
                }
                return data;
            }
            case 4: {
                return is.readByte();
            }
            case 5: {
                int length = is.readShort();
                byte[] data = new byte[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readByte();
                }
                return data;
            }
            case 6: {
                return is.readLong();
            }
            case 7: {
                int length = is.readShort();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readLong();
                }
                return data;
            }
            case 8: {
                return is.readBoolean();
            }
            case 9: {
                int length = is.readShort();
                boolean[] data = new boolean[length];
                byte b = 0;
                for (int i = 0; i < length; ++i) {
                    if (i % 8 == 0) {
                        b = is.readByte();
                    }
                    data[i] = (b & 1 << i % 8) != 0;
                }
                return data;
            }
            case 10: {
                int length = is.readShort();
                char[] data = new char[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readChar();
                }
                return new String(data);
            }
            case 11: {
                int length = is.readShort();
                String[] data = new String[length];
                for (int i = 0; i < length; ++i) {
                    int slength = is.readShort();
                    char[] sdata = new char[slength];
                    for (int j = 0; j < slength; ++j) {
                        sdata[j] = is.readChar();
                    }
                    data[i] = new String(sdata);
                }
                return data;
            }
            case 12: {
                short id = is.readShort();
                if (id == 0) {
                    return null;
                }
                byte stackSize = is.readByte();
                short meta = is.readShort();
                ItemStack stack = new ItemStack((int)id, (int)stackSize, (int)meta);
                if (is.readBoolean()) {
                    stack.field_77990_d = CompressedStreamTools.func_74794_a((DataInput)is);
                }
                return stack;
            }
            case 13: {
                return NBTBase.func_74739_b((DataInput)is);
            }
            case 14: {
                byte kind = is.readByte();
                int id = is.readInt();
                switch (kind) {
                    case 0: {
                        return Block.field_71973_m[id];
                    }
                    case 1: {
                        return Item.field_77698_e[id];
                    }
                    case 2: {
                        return AchievementList.field_76007_e.get(id);
                    }
                    case 3: {
                        return Potion.field_76425_a[id];
                    }
                    case 4: {
                        return Enchantment.field_77331_b[id];
                    }
                }
            }
            case 15: {
                byte kind = is.readByte();
                int x = is.readInt();
                int y = 0;
                if (kind == 1 || kind == 2) {
                    y = is.readInt();
                }
                int z = is.readInt();
                switch (kind) {
                    case 0: {
                        return new ChunkCoordIntPair(x, z);
                    }
                    case 1: {
                        return new ChunkCoordinates(x, y, z);
                    }
                    case 2: {
                        return new ChunkPosition(x, y, z);
                    }
                }
            }
            case 16: {
                int dimension = is.readInt();
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                return DimensionManager.getWorld((int)dimension).func_72796_p(x, y, z);
            }
            case 17: {
                int dimension = is.readInt();
                return DimensionManager.getWorld((int)dimension);
            }
            case 18: {
                return Float.valueOf(is.readFloat());
            }
            case 19: {
                int length = is.readShort();
                float[] data = new float[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readFloat();
                }
                return data;
            }
            case 20: {
                return is.readDouble();
            }
            case 21: {
                int length = is.readShort();
                double[] data = new double[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readDouble();
                }
                return data;
            }
            case 22: {
                int fluidId = is.readInt();
                if (fluidId == Integer.MIN_VALUE) {
                    int capacity = is.readInt();
                    return new FluidTank(capacity);
                }
                int amount = is.readInt();
                NBTTagCompound tag = is.readBoolean() ? CompressedStreamTools.func_74794_a((DataInput)is) : null;
                int capacity = is.readInt();
                return new FluidTank(new FluidStack(fluidId, amount, tag), capacity);
            }
            case 126: {
                return is.readInt();
            }
            case 127: {
                return null;
            }
        }
        IC2.platform.displayError("An unknown data type was received over multiplayer to be decoded.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: type ID " + type + ")");
        return null;
    }

    public static void encode(DataOutputStream os, Object o) throws IOException {
        if (o instanceof Integer) {
            os.writeByte(0);
            os.writeInt((Integer)o);
        } else if (o instanceof int[]) {
            os.writeByte(1);
            int[] oa = (int[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeInt(oa[i]);
            }
        } else if (o instanceof Short) {
            os.writeByte(2);
            os.writeShort(((Short)o).shortValue());
        } else if (o instanceof short[]) {
            os.writeByte(3);
            short[] oa = (short[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i]);
            }
        } else if (o instanceof Byte) {
            os.writeByte(4);
            os.writeByte(((Byte)o).byteValue());
        } else if (o instanceof byte[]) {
            os.writeByte(5);
            byte[] oa = (byte[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeByte(oa[i]);
            }
        } else if (o instanceof Long) {
            os.writeByte(6);
            os.writeLong((Long)o);
        } else if (o instanceof long[]) {
            os.writeByte(7);
            long[] oa = (long[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeLong(oa[i]);
            }
        } else if (o instanceof Boolean) {
            os.writeByte(8);
            os.writeBoolean((Boolean)o);
        } else if (o instanceof boolean[]) {
            os.writeByte(9);
            boolean[] oa = (boolean[])o;
            os.writeShort(oa.length);
            int b = 0;
            for (int i = 0; i < oa.length; ++i) {
                if (i % 8 == 0 && i > 0) {
                    os.writeByte(b);
                    b = 0;
                }
                b = (byte)(b | (oa[i] ? 1 : 0) << i % 8);
            }
            os.writeByte(b);
        } else if (o instanceof String) {
            os.writeByte(10);
            String oa = (String)o;
            os.writeShort(oa.length());
            os.writeChars(oa);
        } else if (o instanceof String[]) {
            os.writeByte(11);
            String[] oa = (String[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i].length());
                os.writeChars(oa[i]);
            }
        } else if (o instanceof ItemStack) {
            os.writeByte(12);
            ItemStack oa = (ItemStack)o;
            os.writeShort(oa.field_77993_c);
            if (oa.field_77993_c == 0) {
                return;
            }
            os.writeByte(oa.field_77994_a);
            os.writeShort(oa.func_77960_j());
            if ((Item.field_77698_e[oa.field_77993_c].func_77645_m() || Item.field_77698_e[oa.field_77993_c].func_77651_p()) && oa.field_77990_d != null) {
                os.writeBoolean(true);
                CompressedStreamTools.func_74800_a((NBTTagCompound)oa.field_77990_d, (DataOutput)os);
            } else {
                os.writeBoolean(false);
            }
        } else if (o instanceof NBTBase) {
            os.writeByte(13);
            NBTBase.func_74731_a((NBTBase)((NBTBase)o), (DataOutput)os);
        } else if (o instanceof Block) {
            os.writeByte(14);
            os.writeByte(0);
            os.writeInt(((Block)o).field_71990_ca);
        } else if (o instanceof Item) {
            os.writeByte(14);
            os.writeByte(1);
            os.writeInt(((Item)o).field_77779_bT);
        } else if (o instanceof Achievement) {
            os.writeByte(14);
            os.writeByte(2);
            os.writeInt(((Achievement)o).field_75975_e);
        } else if (o instanceof Potion) {
            os.writeByte(14);
            os.writeByte(3);
            os.writeInt(((Potion)o).field_76415_H);
        } else if (o instanceof Enchantment) {
            os.writeByte(14);
            os.writeByte(4);
            os.writeInt(((Enchantment)o).field_77352_x);
        } else if (o instanceof ChunkCoordinates) {
            os.writeByte(15);
            os.writeByte(0);
            ChunkCoordinates oa = (ChunkCoordinates)o;
            os.writeInt(oa.field_71574_a);
            os.writeInt(oa.field_71572_b);
            os.writeInt(oa.field_71573_c);
        } else if (o instanceof ChunkCoordIntPair) {
            os.writeByte(15);
            os.writeByte(1);
            ChunkCoordIntPair oa = (ChunkCoordIntPair)o;
            os.writeInt(oa.field_77276_a);
            os.writeInt(oa.func_77274_b() - 8 >> 4);
        } else if (o instanceof ChunkPosition) {
            os.writeByte(15);
            os.writeByte(1);
            ChunkPosition oa = (ChunkPosition)o;
            os.writeInt(oa.field_76930_a);
            os.writeInt(oa.field_76928_b);
            os.writeInt(oa.field_76929_c);
        } else if (o instanceof TileEntity) {
            os.writeByte(16);
            TileEntity oa = (TileEntity)o;
            os.writeInt(oa.field_70331_k.field_73011_w.field_76574_g);
            os.writeInt(oa.field_70329_l);
            os.writeInt(oa.field_70330_m);
            os.writeInt(oa.field_70327_n);
        } else if (o instanceof World) {
            os.writeByte(17);
            os.writeInt(((World)o).field_73011_w.field_76574_g);
        } else if (o instanceof Float) {
            os.writeByte(18);
            os.writeFloat(((Float)o).floatValue());
        } else if (o instanceof float[]) {
            os.writeByte(19);
            float[] oa = (float[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeFloat(oa[i]);
            }
        } else if (o instanceof Double) {
            os.writeByte(20);
            os.writeDouble((Double)o);
        } else if (o instanceof double[]) {
            os.writeByte(21);
            double[] oa = (double[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeDouble(oa[i]);
            }
        } else if (o instanceof FluidTank) {
            os.writeByte(22);
            FluidTank tank = (FluidTank)o;
            FluidStack fs = tank.getFluid();
            if (fs == null) {
                os.writeInt(Integer.MIN_VALUE);
            } else {
                os.writeInt(fs.fluidID);
                os.writeInt(fs.amount);
                if (fs.tag != null) {
                    os.writeBoolean(true);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)fs.tag, (DataOutput)os);
                } else {
                    os.writeBoolean(false);
                }
            }
            os.writeInt(tank.getCapacity());
        } else if (o instanceof Enum) {
            os.writeByte(126);
            os.writeInt(((Enum)o).ordinal());
        } else if (o == null) {
            os.writeByte(127);
        } else {
            IC2.platform.displayError("An unknown data type was attempted to be encoded for sending through\nmultiplayer.\nThis could happen due to a bug.\n\n(Technical information: " + o.getClass().getName() + ")");
        }
    }

    public static <T> boolean copyValue(T src, T dst) {
        if (dst instanceof ItemStack) {
            ItemStack srcT = (ItemStack)src;
            ItemStack dstT = (ItemStack)dst;
            dstT.field_77993_c = srcT.field_77993_c;
            dstT.func_77964_b(srcT.func_77960_j());
            dstT.field_77990_d = srcT.field_77990_d;
            return true;
        }
        if (dst instanceof FluidTank) {
            FluidTank srcT = (FluidTank)src;
            FluidTank dstT = (FluidTank)dst;
            dstT.setFluid(srcT.getFluid());
            dstT.setCapacity(srcT.getCapacity());
        }
        return false;
    }
}

