/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.wiring.ContainerTransformer;
import ic2.core.block.wiring.GuiTransformer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTransformer
extends TileEntityInventory
implements IEnergySink,
IEnergySource,
IHasGui,
INetworkClientTileEntityEventListener {
    public int mode;
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public double energy = 0.0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    public String getTyp() {
        switch (this.lowOutput) {
            case 32: {
                return "LV";
            }
            case 128: {
                return "MV";
            }
            case 512: {
                return "HV";
            }
            case 2048: {
                return "EV";
            }
        }
        return "";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.mode = nbttagcompound.func_74762_e("mode");
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74762_e("energy");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74768_a("mode", this.mode);
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                if (this.mode == 0) break;
                this.mode = 0;
                break;
            }
            case 1: {
                if (this.mode == 1) break;
                this.mode = 1;
                break;
            }
            case 2: {
                if (this.mode == 2) break;
                this.mode = 2;
            }
        }
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.updateRedstone();
    }

    public void updateRedstone() {
        boolean red;
        switch (this.mode) {
            case 0: {
                red = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 1: {
                red = false;
                break;
            }
            case 2: {
                red = true;
                break;
            }
            default: {
                throw new RuntimeException("invalid mode: " + this.mode);
            }
        }
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.energy = 0.0;
            this.redstone = red;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (this.redstone) {
            if (this.energy >= (double)this.highOutput) {
                return this.highOutput;
            }
        } else if (this.energy >= (double)this.lowOutput) {
            return this.lowOutput;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.maxStorage - this.energy;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        if (this.redstone) {
            return this.lowOutput;
        }
        if (this.highOutput < 8192) {
            return this.highOutput;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.energy = 0.0;
        super.setFacing(side);
        if (this.addedToEnergyNet) {
            this.addedToEnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    public ContainerBase<TileEntityTransformer> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerTransformer(entityPlayer, this, 166);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiTransformer(new ContainerTransformer(entityPlayer, this, 166));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

