/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.command;

import cpw.mods.fml.common.registry.GameData;
import ic2.api.recipe.IRecipeInput;
import ic2.core.util.ConfigUtil;
import ic2.core.util.StackUtil;
import ic2.core.uu.DropScan;
import ic2.core.uu.UuGraph;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class CommandIc2
extends CommandBase {
    public String func_71517_b() {
        return "ic2";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/ic2 uu-world-scan <small|medium|large> | debug (dumpUuValues | resolveIngredient <name>)";
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"uu-world-scan", "debug"});
        }
        if (args.length == 2 && args[0].equals("uu-world-scan")) {
            return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"small", "medium", "large"});
        }
        if (args.length >= 2 && args[0].equals("debug")) {
            if (args.length == 2) {
                return CommandIc2.func_71530_a((String[])args, (String[])new String[]{"dumpUuValues", "resolveIngredient"});
            }
            if (args.length == 3 && args[1].equals("resolveIngredient")) {
                ArrayList<String> possibilities = new ArrayList<String>(Item.field_150901_e.func_148742_b());
                for (String name : OreDictionary.getOreNames()) {
                    possibilities.add("OreDict:" + name);
                }
                for (String name : FluidRegistry.getRegisteredFluids().keySet()) {
                    possibilities.add("Fluid:" + name);
                }
                return CommandIc2.func_71531_a((String[])args, possibilities);
            }
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length == 2 && args[0].equals("uu-world-scan")) {
            this.cmdUuWorldScan(sender, args[1]);
        } else if (args[0].equals("debug")) {
            if (args.length == 2 && args[1].equals("dumpUuValues")) {
                this.cmdDumpUuValues(sender);
            } else if (args.length == 3 && args[1].equals("resolveIngredient")) {
                this.cmdDebugResolveIngredient(sender, args[2]);
            } else {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public int compareTo(Object o) {
        return super.compareTo((ICommand)o);
    }

    private void cmdUuWorldScan(ICommandSender sender, String arg) {
        int areaCount;
        if (arg.equals("small")) {
            areaCount = 1024;
        } else if (arg.equals("medium")) {
            areaCount = 2048;
        } else if (arg.equals("large")) {
            areaCount = 4096;
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        int time = areaCount / 1024 * 3;
        sender.func_145747_a((IChatComponent)new ChatComponentText("Starting world scan, this will take about " + time + " minutes with a powerful cpu."));
        sender.func_145747_a((IChatComponent)new ChatComponentText("The server will not respond while the calculations are running."));
        EntityPlayerMP player = CommandIc2.func_71521_c((ICommandSender)sender);
        int area = 50000;
        int range = 5;
        DropScan.start(player.field_70170_p, area, areaCount, range);
    }

    private void cmdDumpUuValues(ICommandSender sender) {
        ArrayList<Map.Entry<ItemStack, Double>> list = new ArrayList<Map.Entry<ItemStack, Double>>();
        Iterator<Map.Entry<ItemStack, Double>> it = UuGraph.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new Comparator<Map.Entry<ItemStack, Double>>(){

            @Override
            public int compare(Map.Entry<ItemStack, Double> a, Map.Entry<ItemStack, Double> b) {
                return a.getKey().func_77973_b().func_77653_i(a.getKey()).compareTo(b.getKey().func_77973_b().func_77653_i(b.getKey()));
            }
        });
        sender.func_145747_a((IChatComponent)new ChatComponentText("UU Values:"));
        for (Map.Entry entry : list) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.format("  %s: %s", ((ItemStack)entry.getKey()).func_77973_b().func_77653_i((ItemStack)entry.getKey()), entry.getValue())));
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText("(check console for full list)"));
    }

    private void cmdDebugResolveIngredient(ICommandSender sender, String arg) {
        try {
            IRecipeInput input = ConfigUtil.asRecipeInput(arg);
            if (input == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("No match"));
            } else {
                List<ItemStack> inputs = input.getInputs();
                sender.func_145747_a((IChatComponent)new ChatComponentText(inputs.size() + " matches:"));
                for (ItemStack stack : inputs) {
                    if (stack == null) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(" null"));
                        continue;
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText(String.format(" %s (%s, od: %s)", StackUtil.toStringSafe(stack), GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()), this.getOreDictNames(stack))));
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Error: " + e));
        }
    }

    private String getOreDictNames(ItemStack stack) {
        try {
            String ret = "";
            Field field = OreDictionary.class.getDeclaredField("oreStacks");
            field.setAccessible(true);
            HashMap oreStacks = (HashMap)field.get(null);
            for (Map.Entry entry : oreStacks.entrySet()) {
                for (ItemStack target : (ArrayList)entry.getValue()) {
                    if (stack.func_77973_b() != target.func_77973_b() || target.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != target.func_77960_j()) continue;
                    if (!ret.isEmpty()) {
                        ret = ret + ", ";
                    }
                    ret = ret + OreDictionary.getOreName((int)((Integer)entry.getKey()));
                }
            }
            return ret.isEmpty() ? "<none>" : ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack)) + " (fallback)";
        }
    }
}

