/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.core.IC2;
import ic2.core.energy.Grid;
import ic2.core.energy.Node;
import ic2.core.energy.NodeType;
import ic2.core.energy.Tile;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public final class EnergyNetLocal {
    public static final boolean useMaxPowerTransferModel = false;
    public static final double sourceParallelResistanceFactor = 20.0;
    public static final double sourceSeriesResistance = 0.2;
    public static final double loadParallelResistanceFactor = 20.0;
    public static final boolean enableCache = true;
    private static int nextGridUid = 0;
    private static int nextNodeUid = 0;
    protected final Set<Grid> grids = new HashSet<Grid>();
    protected Map<TileEntity, Double> changes = new HashMap<TileEntity, Double>();
    private final Map<ChunkCoordinates, Tile> registeredTiles = new HashMap<ChunkCoordinates, Tile>();
    private Map<TileEntity, Integer> pendingAdds = new WeakHashMap<TileEntity, Integer>();
    private final Map<TileEntity, Object> removed = new WeakHashMap<TileEntity, Object>();
    private boolean locked = false;

    protected void addTileEntity(TileEntity te) {
        this.addTileEntity(te, 0);
    }

    protected void addTileEntity(TileEntity te, int retry) {
        if (this.locked) {
            throw new IllegalStateException("addTileEntity isn't allowed from this context");
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warn("EnergyNet.addTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        if (te.func_145837_r()) {
            IC2.log.warn("EnergyNet.addTileEntity: " + te + " is invalid (TileEntity.isInvalid()), aborting");
            return;
        }
        Tile tile = new Tile(this, te);
        List<TileEntity> positions = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Arrays.asList(te);
        ListIterator<TileEntity> it = positions.listIterator();
        while (it.hasNext()) {
            TileEntity pos = it.next();
            ChunkCoordinates coords = new ChunkCoordinates(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e);
            if (this.registeredTiles.containsKey(coords)) {
                if (retry < 2) {
                    if (retry == 0) {
                        IC2.log.debug("EnergyNet.addTileEntity: " + pos + " (" + te + ") is conflicting with " + this.registeredTiles.get((Object)coords).entity + " using the same position (already added, prev. te not removed, overlapping), vanilla/forge race condition?, postponing");
                    }
                    this.pendingAdds.put(te, retry + 1);
                } else {
                    IC2.log.warn("EnergyNet.addTileEntity: " + pos + " (" + te + ") is still conflicting with " + this.registeredTiles.get((Object)coords).entity + " using the same position (already added, prev. te not removed, overlapping), aborting");
                }
                it.previous();
                while (it.hasPrevious()) {
                    pos = it.previous();
                    coords = new ChunkCoordinates(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e);
                    this.registeredTiles.remove(coords);
                }
                return;
            }
            if (!te.func_145831_w().func_72899_e(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e)) {
                if (retry < 1) {
                    IC2.log.warn("EnergyNet.addTileEntity: " + pos + " (" + te + ") was added too early, postponing");
                    this.pendingAdds.put(te, retry + 1);
                } else {
                    IC2.log.info("EnergyNet.addTileEntity: " + pos + " (" + te + ") unloaded, aborting");
                }
                it.previous();
                while (it.hasPrevious()) {
                    pos = it.previous();
                    coords = new ChunkCoordinates(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e);
                    this.registeredTiles.remove(coords);
                }
                return;
            }
            this.registeredTiles.put(coords, tile);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = pos.field_145851_c + dir.offsetX;
                int y = pos.field_145848_d + dir.offsetY;
                int z = pos.field_145849_e + dir.offsetZ;
                if (!te.func_145831_w().func_72899_e(x, y, z)) continue;
                te.func_145831_w().func_147460_e(x, y, z, Blocks.field_150350_a);
            }
        }
        this.addTileToGrids(tile);
        this.removed.remove(te);
    }

    protected void removeTileEntity(TileEntity te) {
        if (this.locked) {
            throw new IllegalStateException("removeTileEntity isn't allowed from this context");
        }
        if (!(te instanceof IEnergyTile)) {
            IC2.log.warn("EnergyNet.removeTileEntity: " + te + " doesn't implement IEnergyTile, aborting");
            return;
        }
        this.pendingAdds.remove(te);
        List<TileEntity> positions = te instanceof IMetaDelegate ? ((IMetaDelegate)te).getSubTiles() : Arrays.asList(te);
        boolean destroyed = false;
        for (TileEntity pos : positions) {
            ChunkCoordinates coords = new ChunkCoordinates(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e);
            Tile tile = this.registeredTiles.get(coords);
            if (tile == null) {
                IC2.log.warn("EnergyNet.removeTileEntity: " + pos + " (" + te + ") wasn't found (added), skipping");
                continue;
            }
            if (!destroyed) {
                this.removeTileFromGrids(tile);
                this.removed.put(te, null);
                destroyed = true;
            }
            this.registeredTiles.remove(coords);
            if (!te.func_145831_w().func_72899_e(pos.field_145851_c, pos.field_145848_d, pos.field_145849_e)) continue;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int x = pos.field_145851_c + dir.offsetX;
                int y = pos.field_145848_d + dir.offsetY;
                int z = pos.field_145849_e + dir.offsetZ;
                if (!te.func_145831_w().func_72899_e(x, y, z)) continue;
                te.func_145831_w().func_147460_e(x, y, z, Blocks.field_150350_a);
            }
        }
    }

    protected long getTotalEnergyEmitted(TileEntity tileEntity) {
        ChunkCoordinates coords = new ChunkCoordinates(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        Tile tile = this.registeredTiles.get(coords);
        if (tile == null) {
            IC2.log.warn("EnergyNet.getTotalEnergyEmitted: " + tileEntity + " is not added to the enet, aborting");
            return 0L;
        }
        long ret = 0L;
        return ret;
    }

    protected long getTotalEnergySunken(TileEntity tileEntity) {
        ChunkCoordinates coords = new ChunkCoordinates(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        Tile tile = this.registeredTiles.get(coords);
        if (tile == null) {
            IC2.log.warn("EnergyNet.getTotalEnergySunken: " + tileEntity + " is not added to the enet, aborting");
            return 0L;
        }
        long ret = 0L;
        return ret;
    }

    protected TileEntity getTileEntity(int x, int y, int z) {
        Tile ret = this.registeredTiles.get(new ChunkCoordinates(x, y, z));
        if (ret == null) {
            return null;
        }
        return ret.entity;
    }

    protected TileEntity getNeighbor(TileEntity te, Direction dir) {
        switch (dir) {
            case XN: {
                return this.getTileEntity(te.field_145851_c - 1, te.field_145848_d, te.field_145849_e);
            }
            case XP: {
                return this.getTileEntity(te.field_145851_c + 1, te.field_145848_d, te.field_145849_e);
            }
            case YN: {
                return this.getTileEntity(te.field_145851_c, te.field_145848_d - 1, te.field_145849_e);
            }
            case YP: {
                return this.getTileEntity(te.field_145851_c, te.field_145848_d + 1, te.field_145849_e);
            }
            case ZN: {
                return this.getTileEntity(te.field_145851_c, te.field_145848_d, te.field_145849_e - 1);
            }
            case ZP: {
                return this.getTileEntity(te.field_145851_c, te.field_145848_d, te.field_145849_e + 1);
            }
        }
        return null;
    }

    public boolean dumpDebugInfo(PrintStream console, PrintStream chat, int x, int y, int z) {
        Tile tile = this.registeredTiles.get(new ChunkCoordinates(x, y, z));
        if (tile == null) {
            return false;
        }
        HashSet<Grid> processedGrids = new HashSet<Grid>();
        for (Node node : tile.nodes) {
            if (processedGrids.contains(node.grid)) continue;
            node.grid.dumpNodeInfo(chat, node);
            node.grid.dumpStats(chat);
            node.grid.dumpMatrix(console);
            console.println("dumping graph for " + node.grid);
            node.grid.dumpGraph();
            processedGrids.add(node.grid);
        }
        return true;
    }

    protected void onTickEnd() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        for (Grid grid : this.grids) {
            grid.finishCalculation();
        }
        this.changes.keySet().removeAll(this.removed.keySet());
        this.removed.clear();
        for (Map.Entry entry : this.changes.entrySet()) {
            double intAmount;
            double amount = (Double)entry.getValue();
            if (Math.abs(amount - (intAmount = Math.rint(amount))) < 0.001) {
                amount = intAmount;
            }
            if (amount < 0.0) {
                ((IEnergySource)entry.getKey()).drawEnergy(amount);
                continue;
            }
            if (!(amount > 0.0)) continue;
            ((IEnergySink)entry.getKey()).injectEnergyUnits(ForgeDirection.UNKNOWN, amount);
        }
        this.changes.clear();
        Map<TileEntity, Integer> currentPendingAdds = this.pendingAdds;
        this.pendingAdds = new WeakHashMap<TileEntity, Integer>();
        for (Map.Entry<TileEntity, Integer> entry : currentPendingAdds.entrySet()) {
            this.addTileEntity(entry.getKey(), entry.getValue());
        }
        HashSet<IEnergySource> hashSet = new HashSet<IEnergySource>();
        this.locked = true;
        for (Grid grid : this.grids) {
            grid.prepareCalculation(hashSet);
        }
        this.locked = false;
        for (Grid grid : this.grids) {
            grid.startCalculation();
        }
        for (IEnergySource source : hashSet) {
            source.drawEnergy(source.getOfferedEnergy());
        }
    }

    protected void addChange(TileEntity subject, double amount) {
        if (this.changes.containsKey(subject)) {
            this.changes.put(subject, this.changes.get(subject) + amount);
        } else {
            this.changes.put(subject, amount);
        }
    }

    protected static int getNextGridUid() {
        return nextGridUid++;
    }

    protected static int getNextNodeUid() {
        return nextNodeUid++;
    }

    private void addTileToGrids(Tile tile) {
        ArrayList<Node> extraNodes = new ArrayList<Node>();
        for (Node node : tile.nodes) {
            Grid grid;
            ArrayList<Node> neighbors = new ArrayList<Node>();
            List<TileEntity> positions = node.tile.entity instanceof IMetaDelegate ? ((IMetaDelegate)node.tile.entity).getSubTiles() : Arrays.asList(node.tile.entity);
            for (TileEntity pos : positions) {
                for (Direction dir : Direction.directions) {
                    ForgeDirection fdir = dir.toForgeDirection();
                    ChunkCoordinates coords = new ChunkCoordinates(pos.field_145851_c + fdir.offsetX, pos.field_145848_d + fdir.offsetY, pos.field_145849_e + fdir.offsetZ);
                    Tile neighborTile = this.registeredTiles.get(coords);
                    if (neighborTile == null || neighborTile == node.tile) continue;
                    for (Node neighbor : neighborTile.nodes) {
                        boolean canEmit = false;
                        if ((node.nodeType == NodeType.Source || node.nodeType == NodeType.Conductor) && neighbor.nodeType != NodeType.Source) {
                            IEnergyEmitter emitter = (IEnergyEmitter)(pos instanceof IEnergyEmitter ? pos : node.tile.entity);
                            TileEntity neighborSubTe = neighborTile.getSubEntityAt(coords);
                            IEnergyAcceptor acceptor = (IEnergyAcceptor)(neighborSubTe instanceof IEnergyAcceptor ? neighborSubTe : neighbor.tile.entity);
                            canEmit = emitter.emitsEnergyTo(neighbor.tile.entity, dir.toForgeDirection()) && acceptor.acceptsEnergyFrom(node.tile.entity, dir.getInverse().toForgeDirection());
                        }
                        boolean canAccept = false;
                        if (!(canEmit || node.nodeType != NodeType.Sink && node.nodeType != NodeType.Conductor || neighbor.nodeType == NodeType.Sink)) {
                            IEnergyAcceptor acceptor = (IEnergyAcceptor)(pos instanceof IEnergyAcceptor ? pos : node.tile.entity);
                            TileEntity neighborSubTe = neighborTile.getSubEntityAt(coords);
                            IEnergyEmitter emitter = (IEnergyEmitter)(neighborSubTe instanceof IEnergyEmitter ? neighborSubTe : neighbor.tile.entity);
                            boolean bl = canAccept = acceptor.acceptsEnergyFrom(neighbor.tile.entity, dir.toForgeDirection()) && emitter.emitsEnergyTo(node.tile.entity, dir.getInverse().toForgeDirection());
                        }
                        if (!canEmit && !canAccept) continue;
                        neighbors.add(neighbor);
                    }
                }
            }
            if (neighbors.isEmpty()) {
                grid = new Grid(this);
                grid.add(node, neighbors);
                continue;
            }
            switch (node.nodeType) {
                case Conductor: {
                    grid = null;
                    for (Node neighbor : neighbors) {
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) continue;
                        grid = neighbor.grid;
                    }
                    if (grid == null) {
                        grid = new Grid(this);
                    }
                    ListIterator<Node> it = neighbors.listIterator();
                    while (it.hasNext()) {
                        Node neighbor;
                        neighbor = (Node)it.next();
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) {
                            neighbor = new Node(this, neighbor.tile, neighbor.nodeType);
                            neighbor.tile.addExtraNode(neighbor);
                            grid.add(neighbor, Collections.<Node>emptyList());
                            it.set(neighbor);
                            continue;
                        }
                        if (neighbor.grid == grid) continue;
                        grid.merge(neighbor.grid);
                    }
                    grid.add(node, neighbors);
                    break;
                }
                case Sink: 
                case Source: {
                    for (int i = 0; i < neighbors.size(); ++i) {
                        Node neighbor = (Node)neighbors.get(i);
                        if (neighbor.nodeType != NodeType.Conductor && !neighbor.links.isEmpty()) {
                            neighbor = new Node(this, neighbor.tile, neighbor.nodeType);
                            neighbor.tile.addExtraNode(neighbor);
                            new Grid(this).add(neighbor, Collections.<Node>emptyList());
                        }
                        Node currentNode = node;
                        if (i != 0) {
                            currentNode = new Node(this, tile, node.nodeType);
                            currentNode.isExtraNode = true;
                            extraNodes.add(currentNode);
                        }
                        neighbor.grid.add(currentNode, Arrays.asList(neighbor));
                    }
                    break;
                }
            }
        }
        for (Node node : extraNodes) {
            tile.addExtraNode(node);
        }
    }

    private void removeTileFromGrids(Tile tile) {
        for (Node node : tile.nodes) {
            node.grid.remove(node);
        }
    }
}

