/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import cpw.mods.fml.common.registry.IThrowableEntity;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.util.Quaternion;
import ic2.core.util.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityParticle
extends Entity
implements IThrowableEntity {
    private double coreSize;
    private double influenceSize;
    private int lifeTime;
    private Entity owner;
    private Vector3[] radialTestVectors;

    public EntityParticle(World world) {
        super(world);
        this.field_70145_X = true;
        this.lifeTime = 6000;
    }

    public EntityParticle(World world, EntityLivingBase owner1, float speed, double coreSize1, double influenceSize1) {
        this(world);
        this.coreSize = coreSize1;
        this.influenceSize = influenceSize1;
        this.owner = owner1;
        this.func_70107_b(owner1.field_70165_t, owner1.field_70163_u + (double)owner1.func_70047_e(), owner1.field_70161_v);
        Vector3 motion = new Vector3(owner1.func_70040_Z());
        Vector3 ortho = motion.copy().cross(Vector3.UP).scaleTo(influenceSize1);
        double stepAngle = Math.atan(0.5 / influenceSize1) * 2.0;
        int steps = (int)Math.ceil(Math.PI * 2 / stepAngle);
        Quaternion q = new Quaternion().setFromAxisAngle(motion, stepAngle);
        this.radialTestVectors = new Vector3[steps];
        this.radialTestVectors[0] = ortho.copy();
        for (int i = 1; i < steps; ++i) {
            q.rotate(ortho);
            this.radialTestVectors[i] = ortho.copy();
        }
        motion.scale(speed);
        this.func_70016_h(motion.x, motion.y, motion.z);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public Entity getThrower() {
        return this.owner;
    }

    public void setThrower(Entity entity) {
        this.owner = entity;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        Vector3 start = new Vector3(this.field_70169_q, this.field_70167_r, this.field_70166_s);
        Vector3 end = new Vector3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        MovingObjectPosition hit = this.field_70170_p.func_72901_a(start.toVec3Pool(this.field_70170_p), end.toVec3Pool(this.field_70170_p), true);
        if (hit != null) {
            end.set(hit.field_72307_f);
            this.field_70165_t = hit.field_72307_f.field_72450_a;
            this.field_70163_u = hit.field_72307_f.field_72448_b;
            this.field_70161_v = hit.field_72307_f.field_72449_c;
        }
        List entitiesToCheck = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)this.field_70169_q, (double)this.field_70167_r, (double)this.field_70166_s, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v).func_72314_b(this.influenceSize, this.influenceSize, this.influenceSize));
        ArrayList<MovingObjectPosition> entitiesInfluences = new ArrayList<MovingObjectPosition>();
        double minDistanceSq = start.distanceSquared(end);
        for (Entity entity : entitiesToCheck) {
            double distanceSq;
            MovingObjectPosition entityInfluence;
            if (entity == this.owner || !entity.func_70067_L() || (entityInfluence = entity.field_70121_D.func_72314_b(this.influenceSize, this.influenceSize, this.influenceSize).func_72327_a(start.toVec3Pool(this.field_70170_p), end.toVec3Pool(this.field_70170_p))) == null) continue;
            entitiesInfluences.add(entityInfluence);
            MovingObjectPosition entityHit = entity.field_70121_D.func_72314_b(this.coreSize, this.coreSize, this.coreSize).func_72327_a(start.toVec3Pool(this.field_70170_p), end.toVec3Pool(this.field_70170_p));
            if (entityHit == null || !((distanceSq = start.distanceSquared(entityHit.field_72307_f)) < minDistanceSq)) continue;
            hit = entityHit;
            minDistanceSq = distanceSq;
        }
        double maxInfluenceDistance = Math.sqrt(minDistanceSq) + this.influenceSize;
        for (MovingObjectPosition entityInfluence : entitiesInfluences) {
            if (!(start.distance(entityInfluence.field_72307_f) <= maxInfluenceDistance)) continue;
            this.onInfluence(entityInfluence);
        }
        if (this.radialTestVectors != null) {
            Vector3 vForward = end.copy().sub(start);
            double len = vForward.length();
            vForward.scale(1.0 / len);
            Vector3 origin = new Vector3(start);
            Vector3 tmp = new Vector3();
            int d = 0;
            while ((double)d < len) {
                for (int i = 0; i < this.radialTestVectors.length; ++i) {
                    origin.copy(tmp).add(this.radialTestVectors[i]);
                    MovingObjectPosition influence = this.field_70170_p.func_72901_a(origin.toVec3Pool(this.field_70170_p), tmp.toVec3Pool(this.field_70170_p), true);
                    if (influence == null) continue;
                    this.onInfluence(influence);
                }
                origin.add(vForward);
                ++d;
            }
        }
        if (hit != null) {
            this.onImpact(hit);
            this.func_70106_y();
        } else {
            --this.lifeTime;
            if (this.lifeTime <= 0) {
                this.func_70106_y();
            }
        }
    }

    protected void onImpact(MovingObjectPosition hit) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        System.out.println("hit " + hit.field_72313_a + " " + hit.field_72307_f + " sim=" + IC2.platform.isSimulating());
        if (hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || IC2.platform.isSimulating()) {
            // empty if block
        }
        ExplosionIC2 explosion = new ExplosionIC2(this.field_70170_p, this.owner, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 18.0f, 0.95f, ExplosionIC2.Type.Heat);
        explosion.doExplosion();
    }

    protected void onInfluence(MovingObjectPosition hit) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        System.out.println("influenced " + hit.field_72313_a + " " + hit.field_72307_f + " sim=" + IC2.platform.isSimulating());
        if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && IC2.platform.isSimulating()) {
            Block block = this.field_70170_p.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                this.field_70170_p.func_147468_f(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            } else {
                ItemStack existing = new ItemStack(block, 1, this.field_70170_p.func_72805_g(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d));
                ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(existing);
                if (smelted != null && smelted.func_77973_b() instanceof ItemBlock) {
                    this.field_70170_p.func_147465_d(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, ((ItemBlock)smelted.func_77973_b()).field_150939_a, smelted.func_77960_j(), 3);
                } else {
                    ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[hit.field_72310_e];
                    if (block.isFlammable((IBlockAccess)this.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, side)) {
                        int x = hit.field_72311_b - side.offsetX;
                        int y = hit.field_72312_c - side.offsetY;
                        int z = hit.field_72309_d - side.offsetZ;
                        this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                    }
                }
            }
        }
    }
}

