/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.core.IC2;
import ic2.core.util.ItemStackWrapper;
import ic2.core.util.StackUtil;
import ic2.core.uu.ILateRecipeResolver;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.RecipeTransformation;
import ic2.core.uu.UuIndex;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.item.ItemStack;

public class UuGraph {
    private static final Map<ItemStackWrapper, Node> nodes = new HashMap<ItemStackWrapper, Node>();
    private static final List<InitialValue> initialValues = new ArrayList<InitialValue>();
    private static volatile Future<?> calculation = null;

    public static void build() {
        if (calculation != null) {
            throw new IllegalStateException("uu graph building is already in progress.");
        }
        nodes.clear();
        long startTime = System.currentTimeMillis();
        final ArrayList<RecipeTransformation> transformations = new ArrayList<RecipeTransformation>();
        for (IRecipeResolver iRecipeResolver : UuIndex.instance.resolvers) {
            transformations.addAll(iRecipeResolver.getTransformations());
        }
        for (RecipeTransformation recipeTransformation : transformations) {
            for (ItemStack output : recipeTransformation.outputs) {
                assert (output.func_77960_j() != Short.MAX_VALUE) : output;
                UuGraph.getInternal(output);
            }
        }
        for (InitialValue initialValue : initialValues) {
            UuGraph.getInternal(initialValue.stack);
        }
        for (ILateRecipeResolver iLateRecipeResolver : UuIndex.instance.lateResolvers) {
            transformations.addAll(iLateRecipeResolver.getTransformations(nodes.keySet()));
        }
        IC2.log.info("{} UU recipe transformations fetched after {} ms.", new Object[]{transformations.size(), System.currentTimeMillis() - startTime});
        calculation = IC2.getInstance().threadPool.submit(new Runnable(){

            @Override
            public void run() {
                UuGraph.processRecipes(transformations);
            }
        });
    }

    public static void set(ItemStack stack, double value) {
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            throw new IllegalArgumentException("setting values for wilcard meta stacks isn't supported.");
        }
        if (calculation != null) {
            throw new IllegalStateException("setting values isn't allowed while the calculation is running, set them earlier.");
        }
        initialValues.add(new InitialValue(stack, value));
    }

    public static double get(ItemStack stack) {
        UuGraph.finishCalculation();
        ItemStackWrapper key = new ItemStackWrapper(stack);
        Node ret = nodes.get(key);
        if (ret == null) {
            return Double.POSITIVE_INFINITY;
        }
        return ret.value;
    }

    public static ItemStack find(ItemStack stack) {
        UuGraph.finishCalculation();
        ItemStackWrapper key = new ItemStackWrapper(stack);
        Node exactNode = nodes.get(key);
        if (exactNode != null) {
            return exactNode.stack;
        }
        ItemStack search = stack.func_77946_l();
        search.func_77964_b(Short.MAX_VALUE);
        List<Node> nodes = UuGraph.getAll(search);
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get((int)0).stack;
        }
        ItemStack ret = null;
        int minDmgDiff = Integer.MAX_VALUE;
        for (Node node : nodes) {
            int dmgDiff = Math.abs(stack.func_77960_j() - node.stack.func_77960_j());
            if (dmgDiff >= minDmgDiff) continue;
            ret = node.stack;
            minDmgDiff = dmgDiff;
        }
        return ret;
    }

    public static Iterator<Map.Entry<ItemStack, Double>> iterator() {
        UuGraph.finishCalculation();
        return new ValueIterator();
    }

    private static void processRecipes(List<RecipeTransformation> transformations) {
        long startTime = System.currentTimeMillis();
        for (RecipeTransformation transform : transformations) {
            transform.merge();
            UuGraph.registerTransform(transform);
        }
        for (InitialValue initialValue : initialValues) {
            UuGraph.setInternal(initialValue.stack, initialValue.value);
        }
        initialValues.clear();
        for (Node node : nodes.values()) {
            node.provides = null;
        }
        IC2.log.info("UU graph built with {} nodes after {} ms.", new Object[]{nodes.size(), System.currentTimeMillis() - startTime});
    }

    private static void setInternal(ItemStack stack, double value) {
        UuGraph.getInternal(stack).setValue(value);
    }

    private static Node getInternal(ItemStack stack) {
        assert (stack.func_77960_j() != Short.MAX_VALUE);
        ItemStackWrapper key = new ItemStackWrapper(stack = StackUtil.copyWithSize(stack, 1));
        Node ret = nodes.get(key);
        if (ret == null) {
            ret = new Node(stack);
            nodes.put(key, ret);
        }
        return ret;
    }

    private static List<Node> getAll(ItemStack stack) {
        if (stack.func_77960_j() != Short.MAX_VALUE) {
            return new ArrayList<Node>(Arrays.asList(UuGraph.getInternal(stack)));
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : nodes.values()) {
            if (node.stack.func_77973_b() != stack.func_77973_b()) continue;
            ret.add(node);
        }
        return ret;
    }

    private static void registerTransform(RecipeTransformation transform) {
        NodeTransform nt = new NodeTransform(transform);
        for (List<ItemStack> inputs : transform.inputs) {
            for (ItemStack input : inputs) {
                for (Node node : UuGraph.getAll(input)) {
                    nt.in.add(node);
                    node.provides.add(nt);
                }
            }
        }
        for (ItemStack output : transform.outputs) {
            Node node = UuGraph.getInternal(output);
            nt.out.add(node);
        }
    }

    private static void finishCalculation() {
        if (calculation != null) {
            try {
                calculation.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                nodes.clear();
            }
            calculation = null;
        }
    }

    static /* synthetic */ Map access$300() {
        return nodes;
    }

    private static class ValueIterator
    implements Iterator<Map.Entry<ItemStack, Double>> {
        private final Iterator<Node> parentIterator = UuGraph.access$300().values().iterator();

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public Map.Entry<ItemStack, Double> next() {
            Node node = this.parentIterator.next();
            return new AbstractMap.SimpleImmutableEntry<ItemStack, Double>(node.stack, node.value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class InitialValue {
        ItemStack stack;
        double value;

        InitialValue(ItemStack stack, double value) {
            this.stack = stack;
            this.value = value;
        }
    }

    private static class NodeTransform {
        RecipeTransformation transform;
        Set<Node> in = new HashSet<Node>();
        Set<Node> out = new HashSet<Node>();

        NodeTransform(RecipeTransformation transform) {
            this.transform = transform;
        }

        int getOutputSize(ItemStack output) {
            for (ItemStack stack : this.transform.outputs) {
                if (!StackUtil.isStackEqual(stack, output)) continue;
                return stack.field_77994_a;
            }
            return 0;
        }
    }

    private static class Node {
        ItemStack stack;
        double value = Double.POSITIVE_INFINITY;
        Set<NodeTransform> provides = new HashSet<NodeTransform>();

        Node(ItemStack stack) {
            assert (stack.func_77960_j() != Short.MAX_VALUE);
            this.stack = stack;
        }

        void setValue(double value) {
            if (value >= this.value) {
                return;
            }
            this.value = value;
            for (NodeTransform nt : this.provides) {
                for (Node node : nt.out) {
                    int outputSize = nt.getOutputSize(node.stack);
                    if (outputSize <= 0) {
                        IC2.log.warn("UU update: Invalid output size {} in recipetransform {}, expected {}.", new Object[]{outputSize, nt.transform, node.stack});
                        assert (false);
                        continue;
                    }
                    if (!(node.value > value / (double)outputSize)) continue;
                    node.updateValue(nt, outputSize);
                }
            }
        }

        private void updateValue(NodeTransform nt, int outputSize) {
            double newValue = nt.transform.transformCost;
            for (List<ItemStack> inputs : nt.transform.inputs) {
                double minValue = Double.POSITIVE_INFINITY;
                for (ItemStack input : inputs) {
                    double minValue2 = Double.POSITIVE_INFINITY;
                    for (Node node : UuGraph.getAll(input)) {
                        if (!(node.value < minValue2)) continue;
                        minValue2 = node.value;
                    }
                    if (!((minValue2 *= (double)input.field_77994_a) < minValue)) continue;
                    minValue = minValue2;
                }
                newValue += minValue;
            }
            this.setValue(newValue / (double)outputSize);
        }
    }
}

