/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.tile.IRotorProvider;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.block.generator.gui.GuiWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByList;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import ic2.core.util.Util;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWaterGenerator
extends TileEntityBaseGenerator
implements IRotorProvider {
    private static final int tickRate = 128;
    private static final double energyMultiplier = ConfigUtil.getDouble(MainConfig.get(), "balance/energy/generator/water");
    private static final boolean allowAutomation = ConfigUtil.getBool(MainConfig.get(), "balance/watermillAutomation");
    private static final float rotationSpeed = 0.15f;
    private static final ResourceLocation rotorTexture = new ResourceLocation(IC2.textureDomain, "textures/items/rotor/iron_rotor_model.png");
    public final InvSlotConsumableLiquid fuelSlot;
    private int ticker = IC2.random.nextInt(128);
    public int water = 0;
    public int microStorage = 0;
    public int maxWater = 2000;
    private float angle = 0.0f;
    private long lastcheck;

    public TileEntityWaterGenerator() {
        super(2.0, 1, 4);
        this.production = 2.0;
        this.fuelSlot = new InvSlotConsumableLiquidByList((TileEntityInventory)this, "fuel", allowAutomation ? InvSlot.Access.IO : InvSlot.Access.NONE, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain, FluidRegistry.WATER);
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        this.updateWaterCount();
    }

    public int gaugeFuelScaled(int i) {
        return Util.limit(this.fuel * i / this.maxWater, 0, i);
    }

    @Override
    public boolean gainFuel() {
        if (this.fuel + 500 > this.maxWater) {
            return false;
        }
        if (!this.fuelSlot.isEmpty()) {
            ItemStack liquid = this.fuelSlot.consume(1);
            if (liquid == null) {
                return false;
            }
            this.fuel += 500;
            this.production = liquid.func_77973_b().hasContainerItem(liquid) ? 1.0 : 2.0;
            return true;
        }
        if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage = (int)((double)this.microStorage - this.production * 100.0);
            if (this.production > 0.0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxWater;
    }

    public void flowPower() {
        if (++this.ticker % 128 == 0) {
            this.updateWaterCount();
        }
        this.water = (int)Math.round((double)this.water * energyMultiplier);
        if (this.water > 0) {
            this.microStorage += this.water;
        }
    }

    public void updateWaterCount() {
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, y, z)).func_177230_c();
                    if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                    ++count;
                }
            }
        }
        this.water = count;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WatermillLoop.ogg";
    }

    @Override
    protected boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public int getRotorDiameter() {
        return 2;
    }

    @Override
    public float getAngle() {
        if (this.getActive()) {
            this.angle += (float)(System.currentTimeMillis() - this.lastcheck) * 0.15f;
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public ResourceLocation getRotorRenderTexture() {
        return rotorTexture;
    }

    public ContainerBase<TileEntityWaterGenerator> getGuiContainer(EntityPlayer player) {
        return new ContainerWaterGenerator(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiWaterGenerator(new ContainerWaterGenerator(player, this));
    }
}

