/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.container.ContainerFluidDistributor;
import ic2.core.block.machine.gui.GuiFluidDistributor;
import ic2.core.util.LiquidUtil;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityFluidDistributor
extends TileEntityLiquidTankInventory
implements IHasGui,
INetworkClientTileEntityEventListener {
    public final InvSlotConsumableLiquidByTank inputSlot = new InvSlotConsumableLiquidByTank(this, "inputSlot", InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.getFluidTank());
    public final InvSlotOutput OutputSlot = new InvSlotOutput(this, "OutputSlot", 1);

    public TileEntityFluidDistributor() {
        super(1);
    }

    @Override
    protected void updateEntityServer() {
        block10: {
            EnumFacing[] outputinputSlot;
            super.updateEntityServer();
            if (this.getFluidTank().getFluidAmount() > 0 && (outputinputSlot = this.processInputSlot(true)) != null) {
                this.processInputSlot(false);
                List<ItemStack> processResult = outputinputSlot.items;
                this.OutputSlot.add(processResult);
            }
            if (this.getFluidTank().getFluidAmount() <= 0) break block10;
            if (this.getActive()) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    int amount;
                    EnumFacing side;
                    TileEntity target;
                    if (dir != this.getFacing() || !LiquidUtil.isFluidTile(target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir)), side = dir.func_176734_d()) || (amount = LiquidUtil.fillTile(target, side, this.getFluidTank().getFluid(), false)) <= 0) continue;
                    this.getFluidTank().drain(amount, true);
                }
            } else {
                int amount;
                EnumSet<EnumFacing> acceptingNeighbors = EnumSet.noneOf(EnumFacing.class);
                int acceptedVolume = 0;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    int amount2;
                    EnumFacing side;
                    TileEntity target;
                    if (dir == this.getFacing() || !LiquidUtil.isFluidTile(target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir)), side = dir.func_176734_d()) || (amount2 = LiquidUtil.fillTile(target, side, this.getFluidTank().getFluid(), true)) <= 0) continue;
                    acceptingNeighbors.add(dir);
                    acceptedVolume += amount2;
                }
                block2: while (!acceptingNeighbors.isEmpty() && (amount = Math.min(acceptedVolume, this.getFluidTank().getFluidAmount())) > 0) {
                    int cAmount;
                    FluidStack fs;
                    EnumFacing side;
                    TileEntity target;
                    if ((amount /= acceptingNeighbors.size()) > 0) {
                        Iterator it = acceptingNeighbors.iterator();
                        while (it.hasNext()) {
                            EnumFacing dir = (EnumFacing)it.next();
                            target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                            side = dir.func_176734_d();
                            fs = this.getFluidTank().getFluid().copy();
                            if (fs.amount <= 0) continue block2;
                            fs.amount = Math.min(amount, fs.amount);
                            cAmount = LiquidUtil.fillTile(target, side, fs, false);
                            this.getFluidTank().drain(cAmount, true);
                            acceptedVolume -= cAmount;
                            if (cAmount >= fs.amount) continue;
                            it.remove();
                        }
                        continue;
                    }
                    for (EnumFacing dir : acceptingNeighbors) {
                        target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                        side = dir.func_176734_d();
                        fs = this.getFluidTank().getFluid().copy();
                        fs.amount = Math.min(acceptedVolume, fs.amount);
                        if (fs.amount > 0) {
                            cAmount = LiquidUtil.fillTile(target, side, fs, false);
                            this.getFluidTank().drain(cAmount, true);
                            acceptedVolume -= cAmount;
                            continue;
                        }
                        break block10;
                    }
                    break;
                }
            }
        }
    }

    private RecipeOutput processInputSlot(boolean simulate) {
        if (!this.inputSlot.isEmpty()) {
            MutableObject output = new MutableObject();
            if (this.inputSlot.transferFromTank((IFluidTank)this.getFluidTank(), (MutableObject<ItemStack>)output, simulate) && (output.getValue() == null || this.OutputSlot.canAdd((ItemStack)output.getValue()))) {
                if (output.getValue() == null) {
                    return new RecipeOutput(null, new ItemStack[0]);
                }
                return new RecipeOutput(null, (ItemStack)output.getValue());
            }
        }
        return null;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.setActive(!this.getActive());
    }

    public ContainerBase<TileEntityFluidDistributor> getGuiContainer(EntityPlayer player) {
        return new ContainerFluidDistributor(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiFluidDistributor(new ContainerFluidDistributor(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.getActive() ? from == this.getFacing() : from != this.getFacing()) {
            return false;
        }
        if (this.getFluidTank().getFluidAmount() == 0) {
            return true;
        }
        return this.getFluidTank().getFluid().getFluid().equals(fluid);
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.getFluidTank().fill(resource, doFill);
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }
}

