/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.api.energy.EnergyNet;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Energy;
import ic2.core.block.wiring.TileEntityTransformer;
import ic2.core.init.Localization;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.ref.BlockName;
import ic2.core.ref.TeBlock;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTileEntity
extends ItemBlockIC2 {
    public ItemBlockTileEntity(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        TeBlock teBlock = ItemBlockTileEntity.getTeBlock(stack);
        String name = teBlock == null ? "invalid" : teBlock.name();
        return super.func_77658_a() + "." + name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        TileEntityBlock te;
        TeBlock block = ItemBlockTileEntity.getTeBlock(stack);
        if (block != null && block.getDummyTe() != null && (te = block.getDummyTe()).hasComponent(Energy.class)) {
            Energy energy = te.getComponent(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("ic2.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("ic2.item.tooltip.PowerTier", energy.getSinkTier()));
            }
            if (te instanceof IEnergyStorage) {
                IEnergyStorage storage = (IEnergyStorage)((Object)te);
                tooltip.add(String.format("%s %.0f %s %s %d %s", Localization.translate("ic2.item.tooltip.Output"), EnergyNet.instance.getPowerFromTier(energy.getSourceTier()), Localization.translate("ic2.generic.text.EUt"), Localization.translate("ic2.item.tooltip.Capacity"), storage.getCapacity(), Localization.translate("ic2.generic.text.EU")));
                tooltip.add(Localization.translate("ic2.item.tooltip.Store") + " " + (long)StackUtil.getOrCreateNbtData(stack).func_74769_h("energy") + " " + Localization.translate("ic2.generic.text.EU"));
            }
            if (te instanceof TileEntityTransformer) {
                tooltip.add(String.format("%s %.0f %s %s %.0f %s", Localization.translate("ic2.item.tooltip.Low"), EnergyNet.instance.getPowerFromTier(energy.getSinkTier()), Localization.translate("ic2.generic.text.EUt"), Localization.translate("ic2.item.tooltip.High"), EnergyNet.instance.getPowerFromTier(energy.getSourceTier() + 1), Localization.translate("ic2.generic.text.EUt")));
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        assert (newState.func_177230_c() == this.field_150939_a);
        TeBlock teBlock = ItemBlockTileEntity.getTeBlock(stack);
        if (teBlock == null) {
            return false;
        }
        Class<? extends TileEntityBlock> teClass = teBlock.getTeClass();
        if (teClass == null) {
            return false;
        }
        TileEntityBlock te = TileEntityBlock.instantiate(teClass);
        return ItemBlockTileEntity.placeTeBlock(stack, (EntityLivingBase)player, world, pos, side, te);
    }

    public static boolean placeTeBlock(ItemStack stack, EntityLivingBase placer, World world, BlockPos pos, EnumFacing side, TileEntityBlock te) {
        IBlockState oldState = world.func_180495_p(pos);
        IBlockState newState = BlockName.te.getInstance().func_176223_P();
        if (!world.func_180501_a(pos, newState, 0)) {
            return false;
        }
        world.func_175690_a(pos, (TileEntity)te);
        te.onPlaced(stack, placer, side);
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, newState, 3);
        if (!world.field_72995_K) {
            IC2.network.get(true).sendInitialData(te);
        }
        return true;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        TeBlock teblock = ItemBlockTileEntity.getTeBlock(stack);
        return teblock != null ? teblock.rarity : EnumRarity.COMMON;
    }

    private static TeBlock getTeBlock(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return TeBlock.get(stack.func_77952_i());
    }
}

