/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.EntityHelper;
import journeymap.client.model.MapType;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.properties.MapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class MapState {
    public final int minZoom = 0;
    public final int maxZoom = 5;
    public AtomicBoolean follow = new AtomicBoolean(true);
    public String playerLastPos = "0,0";
    private StatTimer refreshTimer = StatTimer.get("MapState.refresh");
    private StatTimer generateDrawStepsTimer = StatTimer.get("MapState.generateDrawSteps");
    private MapType lastMapType;
    private File worldDir = null;
    private long lastRefresh = 0L;
    private long lastMapTypeChange = 0L;
    private boolean underground = false;
    private IntegerField lastSlice = new IntegerField(Category.Hidden, "", 0, 15, 4);
    private boolean surfaceMappingAllowed = false;
    private boolean caveMappingAllowed = false;
    private List<DrawStep> drawStepList = new ArrayList<DrawStep>();
    private List<DrawWayPointStep> drawWaypointStepList = new ArrayList<DrawWayPointStep>();
    private String playerBiome = "";
    private InGameMapProperties lastMapProperties = null;
    private List<EntityDTO> entityList = new ArrayList<EntityDTO>(32);
    private int lastPlayerChunkX = 0;
    private int lastPlayerChunkZ = 0;
    private boolean highQuality;

    public void refresh(Minecraft mc, EntityPlayer player, InGameMapProperties mapProperties) {
        try {
            this.refreshTimer.start();
            this.lastMapProperties = mapProperties;
            if (this.lastMapType == null) {
                this.lastMapType = this.getMapType();
            }
            this.surfaceMappingAllowed = FeatureManager.isAllowed(Feature.MapSurface);
            this.caveMappingAllowed = FeatureManager.isAllowed(Feature.MapCaves);
            this.worldDir = FileHandler.getJMWorldDir(mc);
            if (mc.field_71441_e != null && mc.field_71441_e.func_72940_L() != 256 && this.lastSlice.getMaxValue() != 15) {
                int maxSlice = mc.field_71441_e.func_72940_L() / 16 - 1;
                int seaLevel = Math.round(mc.field_71441_e.func_181545_F() / 16);
                int currentSlice = this.lastSlice.get();
                this.lastSlice = new IntegerField(Category.Hidden, "", 0, maxSlice, seaLevel);
                this.lastSlice.set(currentSlice);
            }
            this.underground = this.caveMappingAllowed && this.lastMapType.isUnderground();
            this.lastPlayerChunkX = player.field_70176_ah;
            this.lastPlayerChunkZ = player.field_70164_aj;
            this.highQuality = Journeymap.getClient().getCoreProperties().tileHighDisplayQuality.get();
            if (player.field_71093_bK != this.getMapType().dimension) {
                this.follow.set(true);
            } else if (!this.worldDir.equals(this.worldDir)) {
                this.follow.set(true);
            } else if (this.lastMapType == null) {
                this.follow.set(true);
            }
            this.playerBiome = DataCache.getPlayer().biome;
            this.updateLastRefresh();
            this.refreshTimer.stop();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error refreshing MapState: " + LogFormatter.toPartialString(e));
        }
    }

    public void setMapType(MapType.Name mapTypeName) {
        this.setMapType(MapType.from(mapTypeName, DataCache.getPlayer()));
    }

    public MapType toggleMapType() {
        EntityDTO player = DataCache.getPlayer();
        MapType currentMapType = this.getMapType();
        EntityLivingBase playerEntity = (EntityLivingBase)player.entityLivingRef.get();
        if (playerEntity == null) {
            return currentMapType;
        }
        boolean mapTopo = Journeymap.getClient().getCoreProperties().mapTopography.get();
        if (currentMapType.isUnderground()) {
            this.setMapType(MapType.day(player));
        } else if (currentMapType.isDay()) {
            this.setMapType(MapType.night(player));
        } else if (currentMapType.isNight() && mapTopo) {
            this.setMapType(MapType.topo(player));
        } else if (currentMapType.isNight() || currentMapType.isTopo()) {
            if (this.underground && this.caveMappingAllowed) {
                this.lastMapProperties.showCaves.set(true);
                this.setMapType(MapType.underground(player));
            } else {
                this.setMapType(MapType.day(player));
            }
        }
        return currentMapType;
    }

    public void setMapType(MapType mapType) {
        if (mapType.isAllowed()) {
            if (!mapType.isUnderground() && this.lastMapProperties.preferredMapType.get() != mapType.name) {
                this.lastMapProperties.preferredMapType.set(mapType.name);
                this.lastMapProperties.save();
            }
            if (mapType.isUnderground()) {
                this.lastSlice.set(mapType.vSlice);
            }
            this.setLastMapTypeChange(mapType);
            this.requireRefresh();
        }
    }

    public MapType getMapType() {
        MapType mapType = this.lastMapType;
        if (mapType == null) {
            try {
                mapType = MapType.from((MapType.Name)((Object)this.lastMapProperties.preferredMapType.get()), DataCache.getPlayer());
            }
            catch (Exception e) {
                mapType = MapType.day(DataCache.getPlayer());
            }
        }
        if (!Objects.equal((Object)mapType, (Object)this.lastMapType)) {
            this.setLastMapTypeChange(mapType);
        }
        return mapType;
    }

    public long getLastMapTypeChange() {
        return this.lastMapTypeChange;
    }

    private void setLastMapTypeChange(MapType mapType) {
        if (this.lastMapType == null || this.lastMapType.name != mapType.name) {
            this.lastMapTypeChange = System.currentTimeMillis();
        }
        this.lastMapType = mapType;
    }

    public boolean isUnderground() {
        return this.underground;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<? extends DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public List<DrawWayPointStep> getDrawWaypointSteps() {
        return this.drawWaypointStepList;
    }

    public void generateDrawSteps(Minecraft mc, GridRenderer gridRenderer, WaypointDrawStepFactory waypointRenderer, RadarDrawStepFactory radarRenderer, InGameMapProperties mapProperties, boolean checkWaypointDistance) {
        this.generateDrawStepsTimer.start();
        this.lastMapProperties = mapProperties;
        this.drawStepList.clear();
        this.drawWaypointStepList.clear();
        this.entityList.clear();
        ClientAPI.INSTANCE.getDrawSteps(this.drawStepList, gridRenderer.getUIState());
        if (FeatureManager.isAllowed(Feature.RadarAnimals) && (mapProperties.showAnimals.get().booleanValue() || mapProperties.showPets.get().booleanValue())) {
            this.entityList.addAll(DataCache.INSTANCE.getAnimals(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarVillagers) && mapProperties.showVillagers.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getVillagers(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarMobs) && mapProperties.showMobs.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getMobs(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarPlayers) && mapProperties.showPlayers.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getPlayers(false).values());
        }
        if (!this.entityList.isEmpty()) {
            Collections.sort(this.entityList, EntityHelper.entityMapComparator);
            this.drawStepList.addAll(radarRenderer.prepareSteps(this.entityList, gridRenderer, mapProperties));
        }
        if (mapProperties.showWaypoints.get().booleanValue()) {
            boolean showLabel = mapProperties.showWaypointLabels.get();
            this.drawWaypointStepList.addAll(waypointRenderer.prepareSteps(DataCache.INSTANCE.getWaypoints(false), gridRenderer, checkWaypointDistance, showLabel));
        }
        this.generateDrawStepsTimer.stop();
    }

    public boolean zoomIn() {
        if (this.lastMapProperties.zoomLevel.get() < 5) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() + 1);
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.lastMapProperties.zoomLevel.get() > 0) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() - 1);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 5 || zoom < 0 || zoom == this.lastMapProperties.zoomLevel.get()) {
            return false;
        }
        this.lastMapProperties.zoomLevel.set(zoom);
        this.requireRefresh();
        return true;
    }

    public int getZoom() {
        return this.lastMapProperties.zoomLevel.get();
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(Minecraft mc, MapProperties mapProperties) {
        EntityDTO player = DataCache.getPlayer();
        if (ClientAPI.INSTANCE.isDrawStepsUpdateNeeded()) {
            return true;
        }
        if (MapPlayerTask.getlastTaskCompleted() - this.lastRefresh > 500L) {
            return true;
        }
        if (this.getMapType().dimension != player.dimension) {
            return true;
        }
        if (this.underground != player.underground) {
            return true;
        }
        if (!(this.getMapType().vSlice == null || player.underground.booleanValue() && this.getMapType().vSlice == player.chunkCoordY)) {
            return true;
        }
        int diffX = Math.abs(this.lastPlayerChunkX - player.chunkCoordX);
        if (diffX > 2) {
            return true;
        }
        int diffZ = Math.abs(this.lastPlayerChunkZ - player.chunkCoordZ);
        if (diffZ > 2) {
            return true;
        }
        if (this.lastMapProperties == null || !this.lastMapProperties.equals(mapProperties)) {
            return true;
        }
        this.lastPlayerChunkX = player.chunkCoordX;
        this.lastPlayerChunkZ = player.chunkCoordZ;
        return false;
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public boolean isCaveMappingAllowed() {
        return this.caveMappingAllowed;
    }

    public boolean isSurfaceMappingAllowed() {
        return this.surfaceMappingAllowed;
    }

    public int getDimension() {
        return this.getMapType().dimension;
    }

    public IntegerField getLastSlice() {
        return this.lastSlice;
    }
}

