/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import journeymap.client.model.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;

public class EntityDTO
implements Serializable {
    public final String entityId;
    public transient WeakReference<LivingEntity> entityLivingRef;
    public transient ResourceLocation entityIconLocation;
    public String iconLocation;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public double heading;
    public String customName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public int dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean npc;
    public int color;

    private EntityDTO(LivingEntity entity) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entity);
        this.entityId = entity.func_110124_au().toString();
    }

    public void update(LivingEntity entity, boolean hostile) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity currentPlayer = Minecraft.func_71410_x().field_71439_g;
        this.dimension = entity.field_71093_bK.func_186068_a();
        this.posX = entity.field_70165_t;
        this.posY = entity.field_70163_u;
        this.posZ = entity.field_70161_v;
        this.chunkCoordX = entity.field_70176_ah;
        this.chunkCoordY = entity.field_70162_ai;
        this.chunkCoordZ = entity.field_70164_aj;
        this.heading = Math.round(entity.field_70759_as % 360.0f);
        this.invisible = currentPlayer != null ? entity.func_98034_c((PlayerEntity)currentPlayer) : false;
        this.sneaking = entity.func_70093_af();
        CoreProperties coreProperties = Journeymap.getClient().getCoreProperties();
        ResourceLocation entityIcon = null;
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        ScorePlayerTeam team = null;
        try {
            team = mc.field_71441_e.func_96441_U().func_96509_i(entity.func_189512_bd());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof PlayerEntity) {
            String name;
            this.username = name = StringUtils.func_76338_a((String)entity.func_200200_C_().func_150254_d());
            try {
                playerColor = team != null ? team.func_178775_l().func_175746_b() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entityIcon = DefaultPlayerSkin.func_177335_a();
            try {
                ClientPlayNetHandler client = Minecraft.func_71410_x().func_147114_u();
                NetworkPlayerInfo info = client.func_175102_a(entity.func_110124_au());
                if (info != null) {
                    entityIcon = info.func_178837_g();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            entityIcon = EntityHelper.getIconTextureLocation((Entity)entity);
        }
        if (entityIcon != null) {
            this.entityIconLocation = entityIcon;
            this.iconLocation = entityIcon.toString();
        }
        String owner = null;
        if (entity instanceof TameableEntity) {
            LivingEntity ownerEntity = ((TameableEntity)entity).func_70902_q();
            if (ownerEntity != null) {
                owner = ownerEntity.func_200200_C_().func_150254_d();
            }
        } else if (entity instanceof HorseEntity) {
            UUID ownerUuid = ((HorseEntity)entity).func_184780_dh();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.func_110124_au().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        owner = currentPlayer.func_200200_C_().func_150254_d();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        this.owner = owner;
        String customName = null;
        boolean passive = false;
        if (entity instanceof LivingEntity) {
            LivingEntity attackTarget;
            LivingEntity entityLiving = entity;
            if (entity.func_145818_k_() && entityLiving.func_94059_bO()) {
                customName = StringUtils.func_76338_a((String)entity.func_200201_e().func_150254_d());
            }
            if (!hostile && currentPlayer != null && (attackTarget = entity.func_94060_bK()) != null && attackTarget.func_110124_au().equals(currentPlayer.func_110124_au())) {
                hostile = true;
            }
            if (EntityHelper.isPassive(entity)) {
                passive = true;
            }
        }
        if (entity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)entity;
            this.profession = villager.func_213700_eh().func_221130_b().func_221149_b().getRegistryName().func_110623_a();
        } else if (entity instanceof INPC) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        this.customName = customName;
        this.hostile = hostile;
        this.color = entity instanceof PlayerEntity ? playerColor : (team != null ? team.func_178775_l().func_175746_b() : (!Strings.isNullOrEmpty((String)owner) ? coreProperties.getColor(coreProperties.colorPet) : (this.profession != null || this.npc ? coreProperties.getColor(coreProperties.colorVillager) : (hostile ? coreProperties.getColor(coreProperties.colorHostile) : coreProperties.getColor(coreProperties.colorPassive)))));
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, EntityDTO> {
        public EntityDTO load(LivingEntity entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

