/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import javax.annotation.Nullable;
import journeymap.client.data.DataCache;
import journeymap.client.model.ChunkMD;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.IFluidState;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

@MethodsReturnNonnullByDefault
public enum JmBlockAccess implements IEnviromentBlockReader
{
    INSTANCE;


    public TileEntity func_175625_s(BlockPos pos) {
        return this.getWorld().func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (!this.isValid(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk()) {
            return chunkMD.getChunk().func_180495_p(new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public IFluidState func_204610_c(BlockPos blockPos) {
        return this.getWorld().func_204610_c(blockPos);
    }

    public int func_217298_h(BlockPos p_217298_1_) {
        return 0;
    }

    public int func_201572_C() {
        return this.getWorld().func_201572_C();
    }

    public int func_217301_I() {
        return this.getWorld().func_217301_I();
    }

    public BlockRayTraceResult func_217299_a(RayTraceContext context) {
        return this.getWorld().func_217299_a(context);
    }

    @Nullable
    public BlockRayTraceResult func_217296_a(Vec3d vec3d, Vec3d vec3d_1, BlockPos blockPos, VoxelShape voxelShape, BlockState blockState) {
        return this.getWorld().func_217296_a(vec3d, vec3d_1, blockPos, voxelShape, blockState);
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.getBiome(pos, Biomes.field_76772_c);
    }

    @Nullable
    public Biome getBiome(BlockPos pos, Biome defaultBiome) {
        IntegratedServer server;
        Biome biome;
        ChunkMD chunkMD = this.getChunkMDFromBlockCoords(pos);
        if (chunkMD != null && chunkMD.hasChunk() && (biome = chunkMD.getBiome(pos)) != null) {
            return biome;
        }
        if (Minecraft.func_71410_x().func_71356_B() && (server = Minecraft.func_71410_x().func_71401_C()) != null) {
            return server.func_71218_a(Minecraft.func_71410_x().field_71439_g.field_71093_bK).func_180494_b(pos);
        }
        return defaultBiome;
    }

    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private boolean isValid(BlockPos pos) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256;
    }

    @Nullable
    private ChunkMD getChunkMDFromBlockCoords(BlockPos pos) {
        return DataCache.INSTANCE.getChunkMD(new ChunkPos(pos));
    }

    public int func_175642_b(LightType lightType, BlockPos blockPos) {
        return 0;
    }
}

