/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import journeymap.client.JourneymapClient;
import journeymap.common.CommonProxy;
import journeymap.common.network.PacketRegistry;
import journeymap.common.version.Version;
import journeymap.server.JourneymapServer;
import journeymap.server.config.ForgeConfig;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.PropertiesManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="journeymap")
@Mod.EventBusSubscriber(modid="journeymap")
public class Journeymap {
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = "JourneyMap";
    public static final Version JM_VERSION = Version.from("5", "7", "0", "b3", new Version(5, 7, 0, "dev"));
    public static final String FORGE_VERSION = "1.14.4-28.2.18";
    public static final String MC_VERSION = "1.14.4";
    public static final String WEBSITE_URL = "http://journeymap.info/";
    public static final String PATREON_URL = "http://patreon.com/techbrew";
    public static final String DOWNLOAD_URL = "http://minecraft.curseforge.com/projects/journeymap/files/";
    public static final String VERSION_URL = "https://api.cfwidget.com/minecraft/mc-mods/journeymap";
    public static final CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> JourneymapClient::new, () -> JourneymapServer::new);

    public Journeymap() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetupEvent);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCompleteEvent);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetupEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcHandle);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverStartingEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ForgeConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverConfig);
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)MOD_ID);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)("journeymap/" + name));
    }

    private void commonSetupEvent(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            Journeymap.getLogger().info("Initializing Packet Registry");
            PacketRegistry.init();
        });
        proxy.commonSetupEvent(event);
    }

    private void dedicatedServerSetupEvent(FMLDedicatedServerSetupEvent event) {
        proxy.dedicatedServerSetupEvent(event);
    }

    private void clientSetupEvent(FMLClientSetupEvent event) {
        proxy.clientSetupEvent(event);
    }

    private void loadCompleteEvent(FMLLoadCompleteEvent event) {
        proxy.loadCompleteEvent(event);
    }

    private void serverConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            ForgeConfig.load();
        }
    }

    private void serverStartingEvent(FMLServerStartingEvent event) {
        new WorldNbtIDSaveHandler().getWorldID();
        PropertiesManager.getInstance();
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        proxy.imcEnqueue(event);
    }

    private void imcHandle(InterModProcessEvent event) {
        proxy.imcHandle(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static JourneymapClient getClient() {
        return (JourneymapClient)proxy;
    }

    public static JourneymapServer getServer() {
        return (JourneymapServer)proxy;
    }
}

