/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.dimension.DimensionType;

public class PlayerRadarManager {
    private final Map<UUID, PlayerEntity> playersOnServer;
    private static PlayerRadarManager INSTANCE;
    private final Object lock = new Object();

    private PlayerRadarManager() {
        this.playersOnServer = new HashMap<UUID, PlayerEntity>();
    }

    public static PlayerRadarManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerRadarManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, PlayerEntity> getPlayers() {
        Object object = this.lock;
        synchronized (object) {
            return this.playersOnServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(PlayerEntity player) {
        Object object = this.lock;
        synchronized (object) {
            this.playersOnServer.put(player.func_110124_au(), player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNetworkPlayers() {
        Object object = this.lock;
        synchronized (object) {
            this.playersOnServer.clear();
        }
    }

    private void updateClientPlayer(JsonObject player) {
        PlayerEntity clientPlayer = this.getPlayers().get(UUID.fromString(player.get("playerId").getAsString()));
        if (clientPlayer != null) {
            this.updatePlayer(clientPlayer, player);
        } else {
            this.addPlayer(this.buildPlayerFromJson(player));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayers(JsonArray playerList) {
        Object object = this.lock;
        synchronized (object) {
            for (JsonElement p : playerList) {
                JsonObject player = p.getAsJsonObject();
                this.updateClientPlayer(player);
            }
        }
    }

    private void updatePlayer(PlayerEntity player, JsonObject json) {
        player.field_70165_t = json.get("posX").getAsInt();
        player.field_70163_u = json.get("posY").getAsInt();
        player.field_70161_v = json.get("posZ").getAsInt();
        player.field_70176_ah = json.get("chunkX").getAsInt();
        player.field_70162_ai = json.get("chunkY").getAsInt();
        player.field_70164_aj = json.get("chunkZ").getAsInt();
        player.field_70759_as = json.get("rotation").getAsFloat();
        player.func_70095_a(json.get("sneaking").getAsBoolean());
        player.field_71093_bK = DimensionType.func_186069_a((int)json.get("dim").getAsInt());
    }

    private PlayerEntity buildPlayerFromJson(JsonObject player) {
        Minecraft mc = Minecraft.func_71410_x();
        UUID playerUUID = UUID.fromString(player.get("playerId").getAsString());
        String playerName = player.get("name").getAsString();
        if (!playerUUID.equals(mc.field_71439_g.func_110124_au())) {
            RemoteClientPlayerEntity playerMp = new RemoteClientPlayerEntity(mc.field_71441_e, new GameProfile(playerUUID, playerName));
            this.updatePlayer((PlayerEntity)playerMp, player);
            playerMp.func_184221_a(playerUUID);
            playerMp.field_70175_ag = true;
            return playerMp;
        }
        return null;
    }
}

