/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import journeymap.common.network.impl.JsonResponse;
import journeymap.common.network.impl.Message;
import journeymap.common.network.impl.NetworkHandler;
import journeymap.common.network.impl.Response;
import journeymap.common.network.impl.utils.AsyncCallback;
import journeymap.common.network.impl.utils.CallbackService;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.ConnectionType;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class MessageProcessor {
    private static final String MESSAGE_KEY = "message_id";
    static final String OBJECT_KEY = "container_object";
    static final String DATA_KEY = "data";
    static final String MOD_VERSION_KEY = "mod_version";
    static final String MOD_ID_KEY = "mod_id";
    protected static Gson gson = new GsonBuilder().serializeNulls().create();
    private JsonObject data;
    private String clazz;
    protected UUID id;
    protected LogicalSide side;
    protected PlayerEntity player;
    protected String modId;
    protected String modVersion;

    protected abstract JsonObject onServer(Response var1);

    protected abstract JsonObject onClient(Response var1);

    private void reply(JsonObject data) {
        this.data = new JsonObject();
        this.data.addProperty(MESSAGE_KEY, this.getId().toString());
        this.data.addProperty(OBJECT_KEY, this.clazz);
        this.data.add(DATA_KEY, (JsonElement)data);
        if (this.side.isServer()) {
            this.sendToPlayer(data, (ServerPlayerEntity)this.player);
        } else {
            this.send(data);
        }
    }

    public static void process(JsonObject response, Object object, Class clazz) {
        MessageProcessor messageProcessor = null;
        try {
            NetworkEvent.Context ctx = (NetworkEvent.Context)object;
            messageProcessor = (MessageProcessor)clazz.newInstance();
            messageProcessor.handleResponse(response, ctx);
        }
        catch (IllegalAccessException | InstantiationException e) {
            NetworkHandler.getLogger().warn("Unable to initialize message processor: " + response.get(OBJECT_KEY).getAsString() + " :", (Throwable)e);
        }
    }

    protected void handleResponse(JsonObject message, NetworkEvent.Context ctx) {
        CallbackService callbackService = CallbackService.getInstance();
        JsonObject reply = null;
        this.side = ctx.getDirection().getReceptionSide();
        this.data = message.get(DATA_KEY).getAsJsonObject();
        this.id = UUID.fromString(message.get(MESSAGE_KEY).getAsString());
        this.clazz = message.get(OBJECT_KEY).getAsString();
        this.modId = message.get(MOD_ID_KEY).getAsString();
        this.modVersion = message.get(MOD_VERSION_KEY).getAsString();
        JsonResponse response = new JsonResponse(message, ctx);
        if (this.side.isServer()) {
            try {
                this.player = ctx.getSender();
                reply = this.onServer(response);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling response on server: " + this.clazz + " :", (Throwable)e);
            }
        } else {
            try {
                reply = this.onClient(response);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling response on client: " + this.clazz + " :", (Throwable)e);
            }
        }
        if (reply != null) {
            try {
                this.reply(reply);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling reply on " + ctx.getDirection().getReceptionSide().name() + ": " + this.clazz + " :", (Throwable)e);
            }
            return;
        }
        if (callbackService.getCallback(this.id) != null) {
            try {
                callbackService.getCallback(this.id).onSuccess(response);
                callbackService.removeCallback(this.id);
            }
            catch (Exception e) {
                NetworkHandler.getLogger().warn("Error handling callback on " + ctx.getDirection().getReceptionSide().name() + ": " + this.clazz + " :", (Throwable)e);
            }
        }
    }

    protected void buildRequest(JsonObject requestData) {
        if (requestData == null) {
            requestData = new JsonObject();
        }
        this.data = new JsonObject();
        this.data.addProperty(MESSAGE_KEY, this.getId().toString());
        this.data.addProperty(OBJECT_KEY, this.getClass().getName());
        this.data.addProperty(MOD_ID_KEY, NetworkHandler.getInstance().getModId());
        this.data.addProperty(MOD_VERSION_KEY, NetworkHandler.getInstance().getModVersion());
        this.data.add(DATA_KEY, (JsonElement)requestData);
    }

    private UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
            return this.id;
        }
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send() {
        this.send(new JsonObject());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(JsonObject requestData) {
        this.buildRequest(requestData);
        NetworkHandler.getInstance().sendToServer(new Message(gson.toJson((JsonElement)this.data)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(AsyncCallback callback) {
        this.buildRequest(null);
        CallbackService.getInstance().saveCallback(this.id, callback);
        NetworkHandler.getInstance().sendToServer(new Message(gson.toJson((JsonElement)this.data)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void send(JsonObject requestData, AsyncCallback callback) {
        this.buildRequest(requestData);
        CallbackService.getInstance().saveCallback(this.id, callback);
        NetworkHandler.getInstance().sendToServer(new Message(gson.toJson((JsonElement)this.data)));
    }

    public void sendToPlayer(JsonObject requestData, ServerPlayerEntity player) {
        this.buildRequest(requestData);
        if (NetworkHooks.getConnectionType(() -> player.field_71135_a.field_147371_a).equals((Object)ConnectionType.MODDED)) {
            NetworkHandler.getInstance().sendTo(new Message(gson.toJson((JsonElement)this.data)), player);
        }
    }

    public void sendToPlayer(JsonObject requestData, ServerPlayerEntity player, AsyncCallback callback) {
        this.buildRequest(requestData);
        CallbackService.getInstance().saveCallback(this.id, callback);
        if (NetworkHooks.getConnectionType(() -> player.field_71135_a.field_147371_a).equals((Object)ConnectionType.MODDED)) {
            NetworkHandler.getInstance().sendTo(new Message(gson.toJson((JsonElement)this.data)), player);
        }
    }
}

