// https://cadiboo.github.io/tutorials/1.14.4/forge/99.99-coremod/

function initializeCoreMod() {

    /*Class/Interface*/
    Opcodes = Java.type("org.objectweb.asm.Opcodes");
    /*Class*/
    ASMAPI = Java.type("net.minecraftforge.coremod.api.ASMAPI");

    /*Class*/
    InsnList = Java.type("org.objectweb.asm.tree.InsnList");
    /*Class*/
    LabelNode = Java.type("org.objectweb.asm.tree.LabelNode");

    /*Class*/
    FieldNode = Java.type("org.objectweb.asm.tree.FieldNode");
    /*Class*/
    MethodNode = Java.type("org.objectweb.asm.tree.MethodNode");

    /*Class*/
    AbstractInsnNode = Java.type("org.objectweb.asm.tree.AbstractInsnNode");
    /*Class*/
    InsnNode = Java.type("org.objectweb.asm.tree.InsnNode");
    /*Class*/
    VarInsnNode = Java.type("org.objectweb.asm.tree.VarInsnNode");
    /*Class*/
    FieldInsnNode = Java.type("org.objectweb.asm.tree.FieldInsnNode");
    /*Class*/
    MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");
    /*Class*/
    JumpInsnNode = Java.type("org.objectweb.asm.tree.JumpInsnNode");
    /*Class*/
    TypeInsnNode = Java.type("org.objectweb.asm.tree.TypeInsnNode");

    var targetMethodName = ASMAPI.mapMethod("func_215319_a");
    var targetClass = "net.minecraft.client.renderer.WorldRenderer";
//"markForRerender(IIIZ)V"
    var targetMethodSrg = "func_215319_a";
    var targetMethodDesc = "(IIIZ)V";


    return {
        'WorldRenderer.markForRerender': {
            'target': {
                'type': 'METHOD',
                'class': targetClass,
                'methodName': targetMethodName,
                'methodDesc': targetMethodDesc
            },
            "transformer": function (methodNode) {


                var instList = new InsnList();

                //get customlistener
                var methodInsnNode = new MethodInsnNode(Opcodes.INVOKESTATIC, "journeymap/client/world/CustomListeners", "getInstance", "()Ljourneymap/client/world/CustomListeners;", false);
                instList.add(methodInsnNode);

                var x = new VarInsnNode(Opcodes.ILOAD, 1);
                var y = new VarInsnNode(Opcodes.ILOAD, 2);
                var z = new VarInsnNode(Opcodes.ILOAD, 3);
                instList.add(x);
                instList.add(y);
                instList.add(z);
                var methodInsnNode2 = new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "journeymap/client/world/CustomListeners", "notifyWorldEventListeners", "(III)V", false);
                instList.add(methodInsnNode2);
                instList.add(new LabelNode());

                // we want to add it to the end of the method, find the 2nd label and insert.
                var instructions = methodNode.instructions;
                var labels = 0;
                for (var i = 0; i < instructions.size(); ++i) {
                    if (AbstractInsnNode.LABEL === instructions.get(i).getType()) {
                        labels++;
                        if (labels === 2) {
                            instructions.insert(instructions.get(i), instList);
                            break;
                        }
                    }
                }

                return methodNode;
            }
        }
    }
}