/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.mojang.authlib.GameProfile;
import java.util.function.Function;
import journeymap.common.Journeymap;
import journeymap.common.feature.Location;
import journeymap.server.JourneymapServer;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayerEntity) {
            creative = ((ServerPlayerEntity)entity).field_71075_bZ.field_75098_d;
            cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(entity.func_110124_au(), entity.func_200200_C_().func_150254_d()));
            if (mcServer == null) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || JourneymapServer.isOp((PlayerEntity)((ServerPlayerEntity)entity))) {
                if (!entity.func_70089_S()) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                ServerWorld destinationWorld = mcServer.func_71218_a(location.getDimType());
                if (destinationWorld == null) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            entity.func_145747_a((ITextComponent)new StringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(location.getDim());
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(entity.field_71093_bK.func_186068_a());
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(ServerWorld destinationWorld, Entity player, final Location location) {
        boolean changedWorld;
        ServerWorld startWorld = (ServerWorld)player.field_70170_p;
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof ServerPlayerEntity) {
            if (changedWorld) {
                ((ServerPlayerEntity)player).changeDimension(destinationWorld.field_73011_w.func_186058_p(), new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity newPosEntity = repositionEntity.apply(false);
                        newPosEntity.func_70634_a(location.getX(), location.getY() + 1.0, location.getZ());
                        return newPosEntity;
                    }
                });
            } else {
                player.func_70634_a(location.getX(), location.getY(), location.getZ());
            }
        }
        return false;
    }
}

