/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import com.google.common.base.Objects;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.IChunkRenderer;
import net.techbrew.journeymap.cartography.render.BaseRenderer;
import net.techbrew.journeymap.cartography.render.CaveRenderer;
import net.techbrew.journeymap.cartography.render.EndRenderer;
import net.techbrew.journeymap.cartography.render.NetherRenderer;
import net.techbrew.journeymap.cartography.render.SurfaceRenderer;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.model.RegionImageSet;
import org.apache.logging.log4j.Level;

public class ChunkRenderController {
    private final IChunkRenderer netherRenderer = new NetherRenderer();
    private final IChunkRenderer endRenderer = new EndRenderer();
    private final SurfaceRenderer overWorldSurfaceRenderer;
    private final IChunkRenderer overWorldCaveRenderer;

    public ChunkRenderController() {
        SurfaceRenderer surfaceRenderer;
        this.overWorldSurfaceRenderer = surfaceRenderer = new SurfaceRenderer();
        this.overWorldCaveRenderer = new CaveRenderer(surfaceRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderChunk(ChunkCoord cCoord, ChunkMD chunkMd, MapType mapType) {
        long start = System.nanoTime();
        Graphics undergroundG2D = null;
        Graphics dayG2D = null;
        Graphics nightG2D = null;
        boolean renderOkay = false;
        RegionCoord rCoord = cCoord.getRegionCoord();
        if (cCoord.isUnderground().booleanValue() != mapType.isUnderground() || !Objects.equal((Object)cCoord.getVerticalSlice(), (Object)mapType.vSlice) || chunkMd.getWorldObj().field_73011_w.field_76574_g != mapType.dimension) {
            JourneyMap.getLogger().error(String.format("Bad data; Coordinates not compatible with MapType: %s, %s, %s ", cCoord, chunkMd, mapType));
            return false;
        }
        try {
            RegionImageSet regionImageSet = RegionImageCache.instance().getRegionImageSet(rCoord);
            if (mapType.isUnderground()) {
                BufferedImage image = regionImageSet.getChunkImage(cCoord, mapType);
                if (image != null) {
                    undergroundG2D = RegionImageHandler.initRenderingHints(image.createGraphics());
                    switch (rCoord.dimension) {
                        case -1: {
                            renderOkay = this.netherRenderer.render((Graphics2D)undergroundG2D, chunkMd, mapType.vSlice);
                            break;
                        }
                        case 1: {
                            renderOkay = this.endRenderer.render((Graphics2D)undergroundG2D, chunkMd, mapType.vSlice);
                            break;
                        }
                        default: {
                            renderOkay = this.overWorldCaveRenderer.render((Graphics2D)undergroundG2D, chunkMd, mapType.vSlice);
                        }
                    }
                    if (renderOkay) {
                        regionImageSet.setChunkImage(cCoord, mapType, image);
                    }
                }
            } else {
                BufferedImage imageDay = regionImageSet.getChunkImage(cCoord, MapType.day(rCoord.dimension));
                BufferedImage imageNight = regionImageSet.getChunkImage(cCoord, MapType.night(rCoord.dimension));
                if (imageDay != null) {
                    dayG2D = RegionImageHandler.initRenderingHints(imageDay.createGraphics());
                    ((Graphics2D)dayG2D).setComposite(BaseRenderer.ALPHA_OPAQUE);
                }
                if (imageNight != null) {
                    nightG2D = RegionImageHandler.initRenderingHints(imageNight.createGraphics());
                    ((Graphics2D)nightG2D).setComposite(BaseRenderer.ALPHA_OPAQUE);
                }
                boolean bl = renderOkay = dayG2D != null && this.overWorldSurfaceRenderer.render((Graphics2D)dayG2D, (Graphics2D)nightG2D, chunkMd);
                if (renderOkay) {
                    regionImageSet.setChunkImage(cCoord, MapType.day(rCoord.dimension), imageDay);
                    regionImageSet.setChunkImage(cCoord, MapType.night(rCoord.dimension), imageNight);
                }
            }
            if (renderOkay) {
                chunkMd.setRendered();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JourneyMap.getLogger().log(Level.WARN, LogFormatter.toString(e));
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
        }
        finally {
            if (dayG2D != null) {
                dayG2D.dispose();
            }
            if (nightG2D != null) {
                nightG2D.dispose();
            }
            if (undergroundG2D != null) {
                undergroundG2D.dispose();
            }
        }
        if (!renderOkay && JourneyMap.getLogger().isDebugEnabled()) {
            JourneyMap.getLogger().debug("Chunk render failed: %s %s %s", new Object[]{rCoord, cCoord, mapType});
        }
        return renderOkay;
    }
}

