/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import java.awt.Color;
import java.awt.Paint;
import java.util.Collection;
import net.techbrew.journeymap.cartography.PixelPaint;

public final class RGB {
    private static final transient PixelPaint PIXEL_PAINT = new PixelPaint();

    private RGB() {
    }

    public static Paint paintOf(int rgb) {
        return PIXEL_PAINT.setColor(rgb);
    }

    public static Integer average(Collection<Integer> colors) {
        int[] out = new int[]{0, 0, 0};
        int used = 0;
        for (Integer color : colors) {
            if (color == null) continue;
            int[] cInts = RGB.ints(color);
            out[0] = out[0] + cInts[0];
            out[1] = out[1] + cInts[1];
            out[2] = out[2] + cInts[2];
            ++used;
        }
        if (used == 0) {
            return null;
        }
        out[0] = out[0] / used;
        out[1] = out[1] / used;
        out[2] = out[2] / used;
        return RGB.toInteger(out);
    }

    public static Integer average(Integer ... colors) {
        int[] out = new int[]{0, 0, 0};
        int used = 0;
        for (Integer color : colors) {
            if (color == null) continue;
            int[] cInts = RGB.ints(color);
            out[0] = out[0] + cInts[0];
            out[1] = out[1] + cInts[1];
            out[2] = out[2] + cInts[2];
            ++used;
        }
        if (used == 0) {
            return null;
        }
        out[0] = out[0] / used;
        out[1] = out[1] / used;
        out[2] = out[2] / used;
        return RGB.toInteger(out);
    }

    public static Integer max(Integer ... colors) {
        int[] out = new int[]{0, 0, 0};
        int used = 0;
        for (Integer color : colors) {
            if (color == null) continue;
            int[] cInts = RGB.ints(color);
            out[0] = Math.max(out[0], cInts[0]);
            out[1] = Math.max(out[1], cInts[1]);
            out[2] = Math.max(out[2], cInts[2]);
            ++used;
        }
        if (used == 0) {
            return null;
        }
        return RGB.toInteger(out);
    }

    public static int toInteger(float r, float g, float b) {
        return 0xFF000000 | ((int)((double)(r * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(g * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(b * 255.0f) + 0.5) & 0xFF;
    }

    public static int toInteger(float[] rgb) {
        return 0xFF000000 | ((int)((double)(rgb[0] * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(rgb[1] * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(rgb[2] * 255.0f) + 0.5) & 0xFF;
    }

    public static int toInteger(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int toInteger(int[] rgb) {
        return 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
    }

    public static Color toColor(Integer rgb) {
        return rgb == null ? null : new Color(rgb);
    }

    public static String toString(Integer rgb) {
        if (rgb == null) {
            return "null";
        }
        int[] ints = RGB.ints(rgb);
        return String.format("r=%s,g=%s,b=%s", ints[0], ints[1], ints[2]);
    }

    public static int darken(int rgb, float factor) {
        if (factor == 1.0f) {
            return rgb;
        }
        return RGB.toInteger(RGB.clampFloats(RGB.floats(rgb), factor));
    }

    public static int bevelSlope(int rgb, float factor) {
        float bluer = factor < 1.0f ? 0.85f : 1.0f;
        float[] floats = RGB.floats(rgb);
        floats[0] = floats[0] * bluer * factor;
        floats[1] = floats[1] * bluer * factor;
        floats[2] = floats[2] * factor;
        return RGB.toInteger(RGB.clampFloats(floats, 1.0f));
    }

    public static int darkenAmbient(int rgb, float factor, float[] ambient) {
        float[] floats = RGB.floats(rgb);
        floats[0] = floats[0] * (factor + ambient[0]);
        floats[1] = floats[1] * (factor + ambient[1]);
        floats[2] = floats[2] * (factor + ambient[2]);
        return RGB.toInteger(RGB.clampFloats(floats, 1.0f));
    }

    public static int[] ints(int rgb) {
        return new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF};
    }

    public static float[] floats(int rgb) {
        return new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }

    public static int blendWith(int rgb, int otherRgb, float otherAlpha) {
        if (otherAlpha == 1.0f) {
            return otherRgb;
        }
        if (otherAlpha == 0.0f) {
            return rgb;
        }
        float[] floats = RGB.floats(rgb);
        float[] otherFloats = RGB.floats(otherRgb);
        floats[0] = otherFloats[0] * otherAlpha / 1.0f + floats[0] * (1.0f - otherAlpha);
        floats[1] = otherFloats[1] * otherAlpha / 1.0f + floats[1] * (1.0f - otherAlpha);
        floats[2] = otherFloats[2] * otherAlpha / 1.0f + floats[2] * (1.0f - otherAlpha);
        return RGB.toInteger(floats);
    }

    public static float clampFloat(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public static float[] clampFloats(float[] rgbFloats, float factor) {
        float r = rgbFloats[0] * factor;
        float g = rgbFloats[1] * factor;
        float b = rgbFloats[2] * factor;
        float f = r < 0.0f ? 0.0f : (rgbFloats[0] = r > 1.0f ? 1.0f : r);
        float f2 = g < 0.0f ? 0.0f : (rgbFloats[1] = g > 1.0f ? 1.0f : g);
        rgbFloats[2] = b < 0.0f ? 0.0f : (b > 1.0f ? 1.0f : b);
        return rgbFloats;
    }

    public static int clampInt(int value) {
        return value < 0 ? 0 : (value > 255 ? 255 : value);
    }
}

