/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.data.ImagesData;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.model.Waypoint;

public class AllData
extends CacheLoader<Long, Map> {
    public Map load(Long since) throws Exception {
        DataCache cache = DataCache.instance();
        LinkedHashMap<Key, Object> props = new LinkedHashMap<Key, Object>();
        props.put(Key.world, (Object)cache.getWorld(false));
        props.put(Key.player, cache.getPlayer(false));
        props.put(Key.images, new ImagesData(since));
        if (JourneyMap.getWebMapProperties().showWaypoints.get()) {
            int currentDimension = cache.getPlayer((boolean)false).dimension;
            Collection<Waypoint> waypoints = cache.getWaypoints(false);
            HashMap<String, Waypoint> wpMap = new HashMap<String, Waypoint>();
            for (Waypoint waypoint : waypoints) {
                if (!waypoint.getDimensions().contains(currentDimension)) continue;
                wpMap.put(waypoint.getId(), waypoint);
            }
            props.put(Key.waypoints, wpMap);
        } else {
            props.put(Key.waypoints, Collections.emptyMap());
        }
        if (!WorldData.isHardcoreAndMultiplayer()) {
            if (JourneyMap.getWebMapProperties().showAnimals.get() || JourneyMap.getWebMapProperties().showPets.get()) {
                props.put(Key.animals, cache.getAnimals(false));
            } else {
                props.put(Key.animals, Collections.emptyMap());
            }
            if (JourneyMap.getWebMapProperties().showMobs.get()) {
                props.put(Key.mobs, cache.getMobs(false));
            } else {
                props.put(Key.mobs, Collections.emptyMap());
            }
            if (JourneyMap.getWebMapProperties().showPlayers.get()) {
                props.put(Key.players, cache.getPlayers(false));
            } else {
                props.put(Key.players, Collections.emptyMap());
            }
            if (JourneyMap.getWebMapProperties().showVillagers.get()) {
                props.put(Key.villagers, cache.getVillagers(false));
            } else {
                props.put(Key.villagers, Collections.emptyMap());
            }
        }
        return ImmutableMap.copyOf(props);
    }

    public long getTTL() {
        return JourneyMap.getCoreProperties().renderDelay.get() * 2000;
    }

    public static enum Key {
        animals,
        images,
        mobs,
        player,
        players,
        villagers,
        waypoints,
        world;

    }
}

