/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.IconSetFileHandler;
import net.techbrew.journeymap.io.RealmsHelper;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.Display;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    int dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneyMap.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.instance().getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            String serverName = RealmsHelper.getRealmsServerName();
            if (serverName != null) {
                return serverName;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            ServerData serverData = mc.func_147104_D();
            if (serverData != null && (serverName = serverData.field_78847_a) != null) {
                if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                    serverName = serverData.field_78845_b;
                }
                return serverName;
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return WorldData.getLegacyServerName();
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            NetworkManager netManager = FMLClientHandler.instance().getClientToServerNetworkManager();
            if (netManager != null && (socketAddress = netManager.func_74430_c()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWorldName(Minecraft mc, boolean useLegacyName) {
        String worldName = null;
        if (mc.func_71356_B()) {
            if (!useLegacyName) return mc.func_71401_C().func_71270_I();
            worldName = mc.func_71401_C().func_71221_J();
        } else {
            if (mc.field_71441_e == null) {
                return "offline";
            }
            worldName = mc.field_71441_e.func_72912_H().func_76065_j();
            String serverName = WorldData.getServerName();
            worldName = !"MpServer".equals(worldName) ? serverName + "_" + worldName : serverName;
        }
        worldName = useLegacyName ? WorldData.getLegacyUrlEncodedWorldName(worldName) : worldName.trim();
        if (!Strings.isNullOrEmpty((String)worldName.trim())) return worldName;
        return "unnamed";
    }

    private static String getLegacyUrlEncodedWorldName(String worldName) {
        try {
            return URLEncoder.encode(worldName, "UTF-8").replace("+", " ");
        }
        catch (UnsupportedEncodingException e) {
            return worldName;
        }
    }

    public static List<WorldProvider> getDimensionProviders(List<Integer> requiredDimensionList) {
        try {
            WorldProvider provider;
            HashSet<Integer> requiredDims = new HashSet<Integer>(requiredDimensionList);
            HashMap<Integer, WorldProvider> dimProviders = new HashMap<Integer, WorldProvider>();
            Level logLevel = Level.DEBUG;
            JourneyMap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            Integer[] dims = DimensionManager.getIDs();
            JourneyMap.getLogger().log(logLevel, String.format("DimensionManager has dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            dims = DimensionManager.getStaticDimensionIDs();
            JourneyMap.getLogger().log(logLevel, String.format("DimensionManager has static dims: %s", Arrays.asList(dims)));
            requiredDims.addAll(Arrays.asList(dims));
            WorldProvider playerProvider = FMLClientHandler.instance().getClient().field_71439_g.field_70170_p.field_73011_w;
            dimProviders.put(playerProvider.field_76574_g, playerProvider);
            requiredDims.remove(playerProvider.field_76574_g);
            JourneyMap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", playerProvider.field_76574_g, WorldData.getSafeDimensionName(playerProvider)));
            for (int dim : requiredDims) {
                if (dimProviders.containsKey(dim)) continue;
                if (DimensionManager.getWorld((int)dim) != null) {
                    try {
                        WorldProvider dimProvider = DimensionManager.getProvider((int)dim);
                        dimProvider.func_80007_l();
                        dimProviders.put(dim, dimProvider);
                        JourneyMap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", dim, WorldData.getSafeDimensionName(dimProvider)));
                    }
                    catch (Throwable t) {
                        JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", dim, t), t);
                    }
                    continue;
                }
                try {
                    provider = DimensionManager.createProviderFor((int)dim);
                    provider.func_80007_l();
                    provider.field_76574_g = dim;
                    dimProviders.put(dim, provider);
                    JourneyMap.getLogger().log(logLevel, String.format("DimensionManager.createProviderFor(%s): %s", dim, WorldData.getSafeDimensionName(playerProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.createProviderFor(%s) because of error: %s", dim, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (int dim : requiredDims) {
                if (dimProviders.containsKey(dim)) continue;
                provider = new FakeDimensionProvider(dim);
                dimProviders.put(dim, provider);
                JourneyMap.getLogger().warn(String.format("Used FakeDimensionProvider for required dim: %s", dim));
            }
            ArrayList<WorldProvider> providerList = new ArrayList<WorldProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<WorldProvider>(){

                @Override
                public int compare(WorldProvider o1, WorldProvider o2) {
                    return Integer.valueOf(o1.field_76574_g).compareTo(o2.field_76574_g);
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(WorldProvider worldProvider) {
        if (worldProvider == null) {
            return null;
        }
        try {
            return worldProvider.func_80007_l();
        }
        catch (Exception e) {
            return Constants.getString("jm.common.dimension", worldProvider.field_76574_g);
        }
    }

    public WorldData load(Class aClass) throws Exception {
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldInfo worldInfo = mc.field_71441_e.func_72912_H();
        IntegratedServer server = mc.func_71401_C();
        boolean multiplayer = server == null || server.func_71344_c();
        this.name = WorldData.getWorldName(mc, false);
        this.dimension = mc.field_71441_e.field_73011_w.field_76574_g;
        this.hardcore = worldInfo.func_76093_s();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_71441_e.func_72820_D() % 24000L;
        this.features = FeatureManager.getAllowedFeatures();
        this.mod_name = JourneyMap.MOD_NAME;
        this.jm_version = JourneyMap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = Display.getTitle().split("\\s(?=\\d)")[1];
        this.browser_poll = Math.max(1000, JourneyMap.getCoreProperties().browserPoll.get());
        this.iconSetName = JourneyMap.getFullMapProperties().getEntityIconSetName().get();
        this.iconSetNames = IconSetFileHandler.getEntityIconSetNames().toArray(new String[0]);
        return this;
    }

    public long getTTL() {
        return 1000L;
    }

    static class FakeDimensionProvider
    extends WorldProvider {
        FakeDimensionProvider(int dimension) {
            this.field_76574_g = dimension;
        }

        public String func_80007_l() {
            return Constants.getString("jm.common.dimension", this.field_76574_g);
        }
    }
}

