/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import com.google.common.base.Joiner;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import cpw.mods.fml.client.FMLClientHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.Util;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.WorldData;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import org.apache.logging.log4j.Level;
import org.lwjgl.Sys;

public class FileHandler {
    public static final String ASSETS_JOURNEYMAP = "/assets/journeymap";
    public static final String ASSETS_JOURNEYMAP_WEB = "/assets/journeymap/web";
    public static final File MinecraftDirectory = FMLClientHandler.instance().getClient().field_71412_D;
    public static final File JourneyMapDirectory = new File(MinecraftDirectory, Constants.JOURNEYMAP_DIR);
    public static final File StandardConfigDirectory = new File(MinecraftDirectory, Constants.CONFIG_DIR);
    private static WorldClient theLastWorld;

    public static File getMCWorldDir(Minecraft minecraft) {
        if (minecraft.func_71387_A()) {
            String lastMCFolderName = minecraft.func_71401_C().func_71270_I();
            File lastMCWorldDir = new File(minecraft.field_71412_D, "saves" + File.separator + lastMCFolderName);
            return lastMCWorldDir;
        }
        return null;
    }

    public static File getMCWorldDir(Minecraft minecraft, int dimension) {
        File worldDir = FileHandler.getMCWorldDir(minecraft);
        if (worldDir == null) {
            return null;
        }
        if (dimension == 0) {
            return worldDir;
        }
        final String dimString = Integer.toString(dimension);
        File dimDir = null;
        if (dimension == -1 || dimension == 1) {
            dimDir = new File(worldDir, "DIM" + dimString);
        }
        if (dimDir == null || !dimDir.exists()) {
            File[] dims = worldDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("DIM") && name.endsWith(dimString) && !name.endsWith("-" + dimString);
                }
            });
            if (dims.length == 0) {
                dimDir = dims[0];
            } else {
                List<File> list = Arrays.asList(dims);
                Collections.sort(list, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return new Integer(o1.getName().length()).compareTo(o2.getName().length());
                    }
                });
                return list.get(0);
            }
        }
        return dimDir;
    }

    public static File getJourneyMapDir() {
        return JourneyMapDirectory;
    }

    public static File getJMWorldDir(Minecraft minecraft) {
        if (minecraft.field_71441_e == null) {
            return null;
        }
        if (!minecraft.func_71356_B()) {
            return FileHandler.getJMWorldDir(minecraft, JourneyMap.getInstance().getCurrentWorldId());
        }
        return FileHandler.getJMWorldDir(minecraft, null);
    }

    public static synchronized File getJMWorldDir(Minecraft minecraft, String worldId) {
        if (minecraft.field_71441_e == null) {
            theLastWorld = null;
            return null;
        }
        File worldDirectory = null;
        try {
            worldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, worldId);
            if (worldDirectory.exists()) {
                return worldDirectory;
            }
            File defaultWorldDirectory = FileHandler.getJMWorldDirForWorldId(minecraft, null);
            if (worldId != null && defaultWorldDirectory.exists() && !worldDirectory.exists()) {
                JourneyMap.getLogger().log(Level.INFO, "Moving default directory to " + worldDirectory);
                try {
                    FileHandler.migrateLegacyFolderName(defaultWorldDirectory, worldDirectory);
                    return worldDirectory;
                }
                catch (Exception e) {
                    JourneyMap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
                }
            }
            if (!minecraft.func_71356_B()) {
                boolean migrated = false;
                String legacyWorldName = WorldData.getLegacyServerName() + "_0";
                File legacyWorldDir = new File(MinecraftDirectory, Constants.MP_DATA_DIR + legacyWorldName);
                if (legacyWorldDir.exists() && !legacyWorldDir.getName().equals(defaultWorldDirectory.getName()) && !legacyWorldDir.getName().equals(worldDirectory.getName())) {
                    FileHandler.migrateLegacyFolderName(legacyWorldDir, worldDirectory);
                    migrated = true;
                }
                if (worldId != null) {
                    legacyWorldName = WorldData.getWorldName(minecraft, true) + "_" + worldId;
                    legacyWorldDir = new File(MinecraftDirectory, Constants.MP_DATA_DIR + legacyWorldName);
                    if (legacyWorldDir.exists() && !legacyWorldDir.getName().equals(worldDirectory.getName())) {
                        FileHandler.migrateLegacyFolderName(legacyWorldDir, worldDirectory);
                        migrated = true;
                    }
                }
            } else {
                File legacyWorldDir = new File(MinecraftDirectory, Constants.SP_DATA_DIR + WorldData.getWorldName(minecraft, true));
                if (!legacyWorldDir.getName().equals(worldDirectory.getName()) && legacyWorldDir.exists() && worldDirectory.exists()) {
                    JMLogger.logOnce(String.format("Found two directories that might be in conflict. Using:  %s , Ignoring: %s", worldDirectory, legacyWorldDir), null);
                }
                if (legacyWorldDir.exists() && !worldDirectory.exists() && !legacyWorldDir.getName().equals(worldDirectory.getName())) {
                    FileHandler.migrateLegacyFolderName(legacyWorldDir, worldDirectory);
                }
            }
            if (!(worldDirectory.exists() || worldId != null && worldDirectory.getName().equals(defaultWorldDirectory.getName()))) {
                worldDirectory.mkdirs();
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
            throw new RuntimeException(e);
        }
        theLastWorld = minecraft.field_71441_e;
        return worldDirectory;
    }

    public static File getJMWorldDirForWorldId(Minecraft minecraft, String worldId) {
        File testWorldDirectory = null;
        try {
            if (!minecraft.func_71356_B()) {
                if (worldId != null) {
                    worldId = worldId.replaceAll("\\W+", "~");
                }
                String suffix = worldId != null ? "_" + worldId : "";
                testWorldDirectory = new File(MinecraftDirectory, Constants.MP_DATA_DIR + WorldData.getWorldName(minecraft, false) + suffix);
            } else {
                testWorldDirectory = new File(MinecraftDirectory, Constants.SP_DATA_DIR + WorldData.getWorldName(minecraft, false));
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
        }
        return testWorldDirectory;
    }

    private static void migrateLegacyFolderName(File legacyWorldDir, File worldDir) {
        block6: {
            if (legacyWorldDir.getPath().equals(worldDir.getPath())) {
                return;
            }
            boolean success = false;
            try {
                success = legacyWorldDir.renameTo(worldDir);
                if (!success) {
                    throw new IllegalStateException("Need to rename legacy folder, but not able to");
                }
                JourneyMap.getLogger().info(String.format("Migrated legacy folder from %s to %s", legacyWorldDir.getName(), worldDir.getName()));
            }
            catch (Exception e) {
                JMLogger.logOnce(String.format("Failed to migrate legacy folder from %s to %s", legacyWorldDir.getName(), worldDir.getName()), e);
                String tempName = worldDir.getName() + "__OLD";
                try {
                    success = legacyWorldDir.renameTo(new File(legacyWorldDir.getParentFile(), tempName));
                }
                catch (Exception e2) {
                    success = false;
                }
                if (success) break block6;
                JMLogger.logOnce(String.format("Failed to even rename legacy folder from %s to %s", legacyWorldDir.getName(), tempName), e);
            }
        }
    }

    public static File getWaypointDir() {
        return FileHandler.getWaypointDir(FileHandler.getJMWorldDir(FMLClientHandler.instance().getClient()));
    }

    public static File getWaypointDir(File jmWorldDir) {
        File waypointDir = new File(jmWorldDir, "waypoints");
        if (!waypointDir.isDirectory()) {
            waypointDir.delete();
        }
        if (!waypointDir.exists()) {
            waypointDir.mkdirs();
        }
        return waypointDir;
    }

    public static BufferedImage getWebImage(String fileName) {
        try {
            String png = "/assets/journeymap/web/img/" + fileName;
            InputStream is = JourneyMap.class.getResourceAsStream(png);
            if (is == null) {
                JourneyMap.getLogger().warn("Image not found: " + png);
                return null;
            }
            BufferedImage img = ImageIO.read(is);
            is.close();
            return img;
        }
        catch (IOException e) {
            String error = "Could not get web image " + fileName + ": " + e.getMessage();
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    public static Properties getLangFile(String fileName) {
        try {
            InputStream is = JourneyMap.class.getResourceAsStream("/assets/journeymap/lang/" + fileName);
            if (is == null) {
                JourneyMap.getLogger().warn("Language file not found: " + fileName);
                return null;
            }
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            return properties;
        }
        catch (IOException e) {
            String error = "Could not get language file " + fileName + ": " + e.getMessage();
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    public static <M> M getMessageModel(Class<M> model, String filePrefix) {
        try {
            String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
            InputStream is = FileHandler.getMessageModelInputStream(filePrefix, lang);
            if (is == null && !lang.equals("en_US")) {
                is = FileHandler.getMessageModelInputStream(filePrefix, "en_US");
            }
            if (is == null) {
                JourneyMap.getLogger().warn("Message file not found: " + filePrefix);
                return null;
            }
            return (M)new GsonBuilder().create().fromJson((Reader)new InputStreamReader(is), model);
        }
        catch (Throwable e) {
            String error = "Could not get Message model " + filePrefix + ": " + e.getMessage();
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    public static InputStream getMessageModelInputStream(String filePrefix, String lang) {
        String file = String.format("/assets/journeymap/lang/message/%s-%s.json", filePrefix, lang);
        return JourneyMap.class.getResourceAsStream(file);
    }

    public static File getWorldConfigDir(boolean fallbackToStandardConfigDir) {
        File worldConfigDir;
        File worldDir = FileHandler.getJMWorldDirForWorldId(FMLClientHandler.instance().getClient(), null);
        if (worldDir != null && worldDir.exists() && (worldConfigDir = new File(worldDir, "config")).exists()) {
            return worldConfigDir;
        }
        return fallbackToStandardConfigDir ? StandardConfigDirectory : null;
    }

    public static BufferedImage getImage(File imageFile) {
        try {
            if (!imageFile.canRead()) {
                return null;
            }
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            String error = "Could not get imageFile " + imageFile + ": " + e.getMessage();
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    public static boolean isInJar() {
        URL location = JourneyMap.class.getProtectionDomain().getCodeSource().getLocation();
        return "jar".equals(location.getProtocol());
    }

    public static File copyColorPaletteHtmlFile(File toDir, String fileName) {
        try {
            final File outFile = new File(toDir, fileName);
            String htmlPath = "/assets/journeymap/web/" + fileName;
            InputStream inputStream = JourneyMap.class.getResource(htmlPath).openStream();
            ByteSink out = new ByteSink(){

                public OutputStream openStream() throws IOException {
                    return new FileOutputStream(outFile);
                }
            };
            out.writeFrom(inputStream);
            return outFile;
        }
        catch (Throwable t) {
            JourneyMap.getLogger().warn("Couldn't copy color palette html: " + t);
            return null;
        }
    }

    public static void open(File file) {
        String path = file.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.OSX) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                return;
            }
            catch (IOException e) {
                JourneyMap.getLogger().error("Could not open path with /usr/bin/open: " + path + " : " + LogFormatter.toString(e));
            }
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String cmd = String.format("cmd.exe /C start \"Open file\" \"%s\"", path);
            try {
                Runtime.getRuntime().exec(cmd);
                return;
            }
            catch (IOException e) {
                JourneyMap.getLogger().error("Could not open path with cmd.exe: " + path + " : " + LogFormatter.toString(e));
            }
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object method = desktopClass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(method, file.toURI());
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error("Could not open path with Desktop: " + path + " : " + LogFormatter.toString(e));
            Sys.openURL((String)("file://" + path));
        }
    }

    public static void copyResources(File targetDirectory, String assetsPath, String setName, boolean overwrite) {
        String fromPath = null;
        File toDir = null;
        try {
            URL resourceDir = JourneyMap.class.getResource(assetsPath);
            String toPath = String.format("%s/%s", assetsPath, setName);
            toDir = new File(targetDirectory, setName);
            boolean inJar = FileHandler.isInJar();
            if (inJar) {
                fromPath = URLDecoder.decode(resourceDir.getPath(), "utf-8").split("file:")[1].split("!/")[0];
                FileHandler.copyFromZip(fromPath, toPath, toDir, overwrite);
            } else {
                File fromDir = new File(JourneyMap.class.getResource(toPath).getFile());
                fromPath = fromDir.getPath();
                FileHandler.copyFromDirectory(fromDir, toDir, overwrite);
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error(String.format("Couldn't unzip resource set from %s to %s: %s", fromPath, toDir, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFromZip(String zipFilePath, String zipEntryName, File destDir, boolean overWrite) throws Throwable {
        if (zipEntryName.startsWith("/")) {
            zipEntryName = zipEntryName.substring(1);
        }
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        try {
            while (entry != null) {
                if (entry.getName().startsWith(zipEntryName)) {
                    File toFile = new File(destDir, entry.getName().split(zipEntryName)[1]);
                    if (!(!overWrite && toFile.exists() || entry.isDirectory())) {
                        Files.createParentDirs((File)toFile);
                        new ZipEntryByteSource(zipFile, entry).copyTo(Files.asByteSink((File)toFile, (FileWriteMode[])new FileWriteMode[0]));
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            zipIn.close();
        }
    }

    static void copyFromDirectory(File fromDir, File toDir, boolean overWrite) throws IOException {
        toDir.mkdir();
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(fromDir + " nas no files");
        }
        for (File from : files) {
            File to = new File(toDir, from.getName());
            if (from.isDirectory()) {
                FileHandler.copyFromDirectory(from, to, overWrite);
                continue;
            }
            if (!overWrite && to.exists()) continue;
            Files.copy((File)from, (File)to);
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        Object[] cmd = null;
        String path = file.getAbsolutePath();
        Util.EnumOS os = Util.func_110647_a();
        switch (os) {
            case WINDOWS: {
                cmd = new String[]{String.format("cmd.exe /C RD /S /Q \"%s\"", path)};
                break;
            }
            case OSX: {
                cmd = new String[]{"rm", "-rf", path};
                break;
            }
            default: {
                cmd = new String[]{"rm", "-rf", path};
            }
        }
        try {
            ProcessBuilder pb = new ProcessBuilder((String[])cmd);
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            p.waitFor();
        }
        catch (Throwable e) {
            JourneyMap.getLogger().error(String.format("Could not delete using: %s : %s", Joiner.on((String)" ").join(cmd), LogFormatter.toString(e)));
        }
        return file.exists();
    }

    public static BufferedImage getIconFromFile(File parentdir, String assetsPath, String setName, String iconPath, BufferedImage defaultImg) {
        BufferedImage img;
        block7: {
            img = null;
            if (iconPath == null) {
                iconPath = "null";
            }
            File iconFile = null;
            try {
                String filePath = Joiner.on((char)File.separatorChar).join((Object)setName, (Object)iconPath.replace('/', File.separatorChar), new Object[0]);
                iconFile = new File(parentdir, filePath);
                if (iconFile.exists()) {
                    img = FileHandler.getImage(iconFile);
                }
                if (img != null) break block7;
                img = FileHandler.getIconFromResource(assetsPath, setName, iconPath);
                if (img == null && defaultImg != null) {
                    img = defaultImg;
                    try {
                        iconFile.getParentFile().mkdirs();
                        ImageIO.write((RenderedImage)img, "png", iconFile);
                    }
                    catch (Exception e) {
                        String error = "FileHandler can't write image: " + iconFile + ": " + e;
                        JourneyMap.getLogger().error(error);
                    }
                    JourneyMap.getLogger().debug("Created image: " + iconFile);
                    break block7;
                }
                String pngPath = Joiner.on((char)'/').join((Object)assetsPath, (Object)setName, new Object[]{iconPath});
                JourneyMap.getLogger().error(String.format("Can't get image from file (%s) nor resource (%s) ", iconFile, pngPath));
            }
            catch (Exception e) {
                JMLogger.logOnce("Couldn't load iconset file: " + iconFile, e);
            }
        }
        return img;
    }

    public static BufferedImage getIconFromResource(String assetsPath, String setName, String iconPath) {
        try {
            InputStream is = FileHandler.getIconStream(assetsPath, setName, iconPath);
            if (is == null) {
                return null;
            }
            BufferedImage img = ImageIO.read(is);
            is.close();
            return img;
        }
        catch (IOException e) {
            String error = String.format("Could not get icon from resource: %s, %s, %s : %s", assetsPath, setName, iconPath, e.getMessage());
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    public static InputStream getIconStream(String assetsPath, String setName, String iconPath) {
        try {
            String pngPath = Joiner.on((char)'/').join((Object)assetsPath, (Object)setName, new Object[]{iconPath});
            InputStream is = JourneyMap.class.getResourceAsStream(pngPath);
            if (is == null) {
                JourneyMap.getLogger().warn(String.format("Icon Set asset not found: " + pngPath, new Object[0]));
                return null;
            }
            return is;
        }
        catch (Throwable e) {
            String error = String.format("Could not get icon stream: %s, %s, %s : %s", assetsPath, setName, iconPath, e.getMessage());
            JourneyMap.getLogger().error(error);
            return null;
        }
    }

    private static class ZipEntryByteSource
    extends ByteSource {
        final ZipFile file;
        final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = file;
            this.entry = entry;
        }

        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            return String.format("ZipEntryByteSource( %s / %s )", this.file, this.entry);
        }
    }
}

