/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.io;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.ui.option.StringListProvider;

public class IconSetFileHandler {
    public static final String ASSETS_JOURNEYMAP_ICON_ENTITY = "/assets/journeymap/icon/entity";
    public static final String MOB_ICON_SET_2D = "2D";
    public static final String MOB_ICON_SET_3D = "3D";
    public static final List<String> MOB_ICON_SETS = Arrays.asList("2D", "3D");

    public static void initialize() {
        JourneyMap.getLogger().info("Initializing icon sets...");
        for (String setName : MOB_ICON_SETS) {
            FileHandler.copyResources(IconSetFileHandler.getEntityIconDir(), ASSETS_JOURNEYMAP_ICON_ENTITY, setName, false);
        }
    }

    public static File getEntityIconDir() {
        File dir = new File(FMLClientHandler.instance().getClient().field_71412_D, Constants.ENTITY_ICON_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static ArrayList<String> getEntityIconSetNames() {
        return IconSetFileHandler.getIconSetNames(IconSetFileHandler.getEntityIconDir(), MOB_ICON_SETS);
    }

    public static ArrayList<String> getIconSetNames(File parentDir, List<String> defaultIconSets) {
        try {
            for (String iconSetName : defaultIconSets) {
                File iconSetDir = new File(parentDir, iconSetName);
                if (iconSetDir.exists() && !iconSetDir.isDirectory()) {
                    iconSetDir.delete();
                }
                iconSetDir.mkdirs();
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().error("Could not prepare iconset directories for " + parentDir + ": " + LogFormatter.toString(t));
        }
        ArrayList<String> names = new ArrayList<String>();
        for (File iconSetDir : parentDir.listFiles()) {
            if (!iconSetDir.isDirectory()) continue;
            names.add(iconSetDir.getName());
        }
        Collections.sort(names);
        return names;
    }

    public static class IconSetStringListProvider
    implements StringListProvider {
        @Override
        public List<String> getStrings() {
            return IconSetFileHandler.getEntityIconSetNames();
        }

        @Override
        public String getDefaultString() {
            return IconSetFileHandler.MOB_ICON_SET_2D;
        }
    }
}

