/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.VersionCheck;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.server.JMServer;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<ChatComponentTranslation> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(IChatComponent chat) {
        ChatComponentTranslation wrap = new ChatComponentTranslation("jm.common.chat_announcement", new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        ChatComponentText chat = new ChatComponentText(message);
        chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(url)));
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceFile(String message, File file) {
        ChatComponentText chat = new ChatComponentText(message);
        try {
            chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getCanonicalPath()));
            chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(file.getCanonicalPath())));
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        ChatComponentText chat = new ChatComponentText(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement((IChatComponent)chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneyMap.getCoreProperties().announceMod.get();
            ChatLog.announceMod(false);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            ChatComponentTranslation message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)message);
            }
            catch (Exception e) {
                try {
                    JourneyMap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    JourneyMap.getLogger().log(logLevel2, StringUtils.func_76338_a((String)message.func_150261_e()));
                    throw throwable;
                }
                logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                JourneyMap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
                continue;
            }
            logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            JourneyMap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod) {
            if (JourneyMap.getWebMapProperties().enabled.get()) {
                try {
                    JMServer jmServer = JourneyMap.getInstance().getJmServer();
                    String keyName = Constants.getKeyName(Constants.KB_MAP);
                    String port = jmServer.getPort() == 80 ? "" : ":" + Integer.toString(jmServer.getPort());
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    JourneyMap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                String keyName = Constants.getKeyName(Constants.KB_MAP);
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneyMap.getCoreProperties().mappingEnabled.get()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    extends ChatComponentText {
        public ErrorChat(String text) {
            super(text);
        }
    }
}

