/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.cache.Cache;
import java.io.File;
import java.util.Objects;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;

public class ChunkCoord {
    private static final Cache<Integer, ChunkCoord> cache = DataCache.instance().getChunkCoords();
    public final File worldDir;
    public final int chunkX;
    public final int chunkZ;
    public final MapType mapType;

    private ChunkCoord(File worldDir, MapType mapType, int chunkX, int chunkZ) {
        this.worldDir = worldDir;
        this.mapType = mapType;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public static ChunkCoord fromChunkMD(File worldDir, MapType mapType, ChunkMD chunkMd) {
        return ChunkCoord.fromChunkPos(worldDir, mapType, chunkMd.getCoord().field_77276_a, chunkMd.getCoord().field_77275_b);
    }

    public static ChunkCoord fromChunkPos(File worldDir, MapType mapType, int chunkX, int chunkZ) {
        int hash = ChunkCoord.toHash(worldDir, mapType, chunkX, chunkZ);
        ChunkCoord chunkCoord = (ChunkCoord)cache.getIfPresent((Object)hash);
        if (chunkCoord == null || chunkCoord.chunkX != chunkX || chunkCoord.chunkZ != chunkZ || !Objects.equals(chunkCoord.mapType, mapType)) {
            chunkCoord = new ChunkCoord(worldDir, mapType, chunkX, chunkZ);
            cache.put((Object)hash, (Object)chunkCoord);
        }
        return chunkCoord;
    }

    public static int toHash(File worldDir, MapType mapType, int chunkX, int chunkZ) {
        int result = worldDir.hashCode();
        result = 31 * result + mapType.hashCode();
        result = 31 * result + chunkX;
        result = 31 * result + chunkZ;
        return result;
    }

    public RegionCoord getRegionCoord() {
        return RegionCoord.fromChunkPos(this.worldDir, this.mapType, this.chunkX, this.chunkZ);
    }

    public Boolean isUnderground() {
        return this.mapType.isUnderground();
    }

    public Integer getVerticalSlice() {
        return this.mapType.vSlice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkCoord that = (ChunkCoord)o;
        if (this.chunkX != that.chunkX) {
            return false;
        }
        if (this.chunkZ != that.chunkZ) {
            return false;
        }
        if (!this.mapType.equals(that.mapType)) {
            return false;
        }
        return this.worldDir.equals(that.worldDir);
    }

    public int hashCode() {
        return ChunkCoord.toHash(this.worldDir, this.mapType, this.chunkX, this.chunkZ);
    }

    public String toString() {
        return "ChunkCoord [" + this.chunkX + "," + this.chunkZ + "]";
    }
}

