/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.base.Objects;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.render.BaseRenderer;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.task.main.ExpireTextureTask;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ImageHolder {
    static final Logger logger = JourneyMap.getLogger();
    final MapType mapType;
    final ReentrantLock writeLock = new ReentrantLock();
    final Path imagePath;
    final int imageSize;
    boolean dirty = true;
    boolean partialUpdate;
    StatTimer writeToDiskTimer = StatTimer.get("ImageHolder.writeToDisk", 2, 1000);
    private volatile TextureImpl texture;

    ImageHolder(MapType mapType, File imageFile, int imageSize) {
        this.mapType = mapType;
        this.imagePath = imageFile.toPath();
        this.imageSize = imageSize;
        this.getTexture();
    }

    public static Graphics2D initRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    File getFile() {
        return this.imagePath.toFile();
    }

    MapType getMapType() {
        return this.mapType;
    }

    BufferedImage getImage() {
        return this.texture.getImage();
    }

    void setImage(BufferedImage image) {
        this.texture.setImage(image, true);
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void partialImageUpdate(BufferedImage imagePart, int x, int y) {
        this.writeLock.lock();
        try {
            if (this.texture != null) {
                BufferedImage textureImage = this.texture.getImage();
                Graphics2D g2D = ImageHolder.initRenderingHints(textureImage.createGraphics());
                g2D.setComposite(BaseRenderer.ALPHA_OPAQUE);
                g2D.drawImage((Image)imagePart, x, y, null);
                g2D.dispose();
                this.partialUpdate = true;
            } else {
                logger.warn(this + " can't partialImageUpdate without a texture.");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishPartialImageUpdates() {
        this.writeLock.lock();
        try {
            if (this.partialUpdate) {
                BufferedImage textureImage = this.texture.getImage();
                this.texture.setImage(textureImage, true);
                this.setDirty();
                this.partialUpdate = false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasTexture() {
        return this.texture != null && !this.texture.isDefunct();
    }

    public TextureImpl getTexture() {
        if (!this.hasTexture()) {
            BufferedImage image = RegionImageHandler.readRegionImage(this.imagePath.toFile(), false);
            if (image == null || image.getWidth() != this.imageSize || image.getHeight() != this.imageSize) {
                image = new BufferedImage(this.imageSize, this.imageSize, 2);
            }
            this.texture = new TextureImpl(null, image, true, false);
            this.texture.setDescription(this.imagePath.toString());
        }
        return this.texture;
    }

    private void setDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToDisk() {
        this.writeToDiskTimer.start();
        if (this.writeLock.tryLock()) {
            try {
                File imageFile = this.imagePath.toFile();
                if (!imageFile.exists()) {
                    imageFile.getParentFile().mkdirs();
                }
                BufferedOutputStream imageOutputStream = new BufferedOutputStream(new FileOutputStream(imageFile));
                ImageIO.write((RenderedImage)this.texture.getImage(), "PNG", imageOutputStream);
                imageOutputStream.close();
                if (logger.isEnabled(Level.DEBUG)) {
                    logger.debug("Wrote to disk: " + imageFile);
                }
                this.dirty = false;
            }
            catch (Throwable e) {
                String error = "Unexpected error writing to disk: " + this + ": " + LogFormatter.toString(e);
                logger.error(error);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            logger.warn("Couldn't get write lock to write to disk: " + this);
        }
        this.writeToDiskTimer.stop();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mapType", (Object)this.mapType).add("textureId", this.texture == null ? null : Integer.valueOf(this.texture.isBound() ? this.texture.getGlTextureId(false) : -1)).add("dirty", this.dirty).add("imagePath", (Object)this.imagePath).toString();
    }

    public void clear() {
        this.writeLock.lock();
        ExpireTextureTask.queue(this.texture);
        this.texture = null;
        this.writeLock.unlock();
    }

    public void finalize() {
        if (this.texture != null) {
            this.clear();
        }
    }

    public long getImageTimestamp() {
        return this.texture.getLastImageUpdate();
    }
}

