/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.EntityHelper;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.properties.InGameMapProperties;
import net.techbrew.journeymap.properties.MapProperties;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.draw.RadarDrawStepFactory;
import net.techbrew.journeymap.render.draw.WaypointDrawStepFactory;
import net.techbrew.journeymap.render.map.GridRenderer;
import net.techbrew.journeymap.task.multi.MapPlayerTask;

public class MapState {
    public final int minZoom = 0;
    public final int maxZoom = 5;
    public AtomicBoolean follow = new AtomicBoolean(true);
    public String playerLastPos = "0,0";
    StatTimer refreshTimer = StatTimer.get("MapState.refresh");
    StatTimer generateDrawStepsTimer = StatTimer.get("MapState.generateDrawSteps");
    private MapType preferredMapType;
    private MapType lastMapType;
    private File worldDir = null;
    private long lastRefresh = 0L;
    private long lastMapTypeChange = 0L;
    private boolean underground = false;
    private boolean caveMappingAllowed = false;
    private List<DrawStep> drawStepList = new ArrayList<DrawStep>();
    private List<DrawWayPointStep> drawWaypointStepList = new ArrayList<DrawWayPointStep>();
    private String playerBiome = "";
    private InGameMapProperties lastMapProperties = null;
    private List<EntityDTO> entityList = new ArrayList<EntityDTO>(32);
    private int lastPlayerChunkX = 0;
    private int lastPlayerChunkZ = 0;
    private boolean highQuality;

    public void refresh(Minecraft mc, EntityClientPlayerMP player, InGameMapProperties mapProperties) {
        this.refreshTimer.start();
        this.lastMapProperties = mapProperties;
        boolean showCaves = mapProperties.showCaves.get();
        if (this.lastMapType == null) {
            this.lastMapType = this.getMapType(showCaves);
        }
        this.caveMappingAllowed = FeatureManager.isAllowed(Feature.MapCaves);
        this.worldDir = FileHandler.getJMWorldDir(mc);
        this.underground = DataCache.getPlayer().underground;
        Integer vSlice = this.underground && showCaves ? Integer.valueOf(player.field_70162_ai) : null;
        this.preferredMapType = MapType.from(mapProperties.getPreferredMapType().get(), vSlice, player.field_71093_bK);
        this.lastPlayerChunkX = player.field_70176_ah;
        this.lastPlayerChunkZ = player.field_70164_aj;
        this.highQuality = JourneyMap.getCoreProperties().tileHighDisplayQuality.get();
        if (player.field_71093_bK != this.getCurrentMapType().dimension) {
            this.follow.set(true);
        } else if (!this.worldDir.equals(this.worldDir)) {
            this.follow.set(true);
        } else if (this.lastMapType == null || this.getMapType(showCaves).isUnderground() != this.lastMapType.isUnderground()) {
            this.follow.set(true);
        }
        this.playerBiome = DataCache.getPlayer().biome;
        this.updateLastRefresh();
        this.refreshTimer.stop();
    }

    public void setMapType(MapType.Name mapTypeName) {
        this.setMapType(MapType.from(mapTypeName, DataCache.getPlayer()));
    }

    public void toggleMapType() {
        EntityDTO player = DataCache.getPlayer();
        MapType currentMapType = this.getCurrentMapType();
        if (currentMapType.isUnderground()) {
            if (!player.entityLiving.field_70170_p.field_73011_w.field_76576_e) {
                this.lastMapProperties.showCaves.set(false);
                this.setMapType(MapType.day(player));
            } else {
                this.setMapType(MapType.underground(player));
            }
        } else if (currentMapType.isDay()) {
            this.setMapType(MapType.night(player));
        } else if (currentMapType.isNight()) {
            if (this.underground && this.caveMappingAllowed) {
                this.lastMapProperties.showCaves.set(true);
                this.setMapType(MapType.underground(player));
            } else {
                this.setMapType(MapType.day(player));
            }
        }
    }

    public void setMapType(MapType mapType) {
        if (!mapType.equals(this.getCurrentMapType()) && !mapType.isUnderground()) {
            this.lastMapProperties.getPreferredMapType().set(mapType.name);
            this.preferredMapType = mapType;
        }
        this.lastMapProperties.save();
        this.setLastMapTypeChange(mapType);
        this.requireRefresh();
    }

    public MapType getCurrentMapType() {
        boolean showCaves = this.lastMapProperties.showCaves.get();
        return this.getMapType(showCaves);
    }

    public MapType getMapType(boolean showCaves) {
        MapType mapType = null;
        if (DataCache.getPlayer().entityLiving.field_70170_p.field_73011_w.field_76576_e) {
            mapType = MapType.underground(DataCache.getPlayer());
        } else if (this.underground && this.caveMappingAllowed && showCaves) {
            mapType = MapType.underground(DataCache.getPlayer());
        } else {
            if (this.preferredMapType == null) {
                this.preferredMapType = MapType.from(this.lastMapProperties.getPreferredMapType().get(), DataCache.getPlayer());
            }
            mapType = this.preferredMapType;
        }
        if (!Objects.equal((Object)mapType, (Object)this.lastMapType)) {
            this.setLastMapTypeChange(mapType);
        }
        return mapType;
    }

    public long getLastMapTypeChange() {
        return this.lastMapTypeChange;
    }

    private void setLastMapTypeChange(MapType mapType) {
        if (!(this.lastMapType == null || mapType.isUnderground() && this.lastMapType.isUnderground())) {
            this.lastMapTypeChange = System.currentTimeMillis();
        }
        this.lastMapType = mapType;
    }

    public boolean isUnderground() {
        return this.underground;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public List<DrawWayPointStep> getDrawWaypointSteps() {
        return this.drawWaypointStepList;
    }

    public void generateDrawSteps(Minecraft mc, GridRenderer gridRenderer, WaypointDrawStepFactory waypointRenderer, RadarDrawStepFactory radarRenderer, InGameMapProperties mapProperties, float drawScale, boolean checkWaypointDistance) {
        this.generateDrawStepsTimer.start();
        this.lastMapProperties = mapProperties;
        this.drawStepList.clear();
        this.drawWaypointStepList.clear();
        this.entityList.clear();
        if (mapProperties.zoomLevel.get() == 0) {
            drawScale *= 0.5f;
        }
        if (FeatureManager.isAllowed(Feature.RadarAnimals) && (mapProperties.showAnimals.get() || mapProperties.showPets.get())) {
            this.entityList.addAll(DataCache.instance().getAnimals(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarVillagers) && mapProperties.showVillagers.get()) {
            this.entityList.addAll(DataCache.instance().getVillagers(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarMobs) && mapProperties.showMobs.get()) {
            this.entityList.addAll(DataCache.instance().getMobs(false).values());
        }
        if (FeatureManager.isAllowed(Feature.RadarPlayers) && mapProperties.showPlayers.get()) {
            this.entityList.addAll(DataCache.instance().getPlayers(false).values());
        }
        if (!this.entityList.isEmpty()) {
            Collections.sort(this.entityList, EntityHelper.entityMapComparator);
            this.drawStepList.addAll(radarRenderer.prepareSteps(this.entityList, gridRenderer, drawScale, mapProperties));
        }
        if (mapProperties.showWaypoints.get()) {
            boolean showLabel = mapProperties.showWaypointLabels.get();
            this.drawWaypointStepList.addAll(waypointRenderer.prepareSteps(DataCache.instance().getWaypoints(false), gridRenderer, checkWaypointDistance, showLabel));
        }
        this.generateDrawStepsTimer.stop();
    }

    public boolean zoomIn() {
        if (this.lastMapProperties.zoomLevel.get() < 5) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() + 1);
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.lastMapProperties.zoomLevel.get() > 0) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() - 1);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 5 || zoom < 0 || zoom == this.lastMapProperties.zoomLevel.get()) {
            return false;
        }
        this.lastMapProperties.zoomLevel.set(zoom);
        this.requireRefresh();
        return true;
    }

    public int getZoom() {
        return this.lastMapProperties.zoomLevel.get();
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(Minecraft mc, MapProperties mapProperties) {
        EntityDTO player = DataCache.getPlayer();
        if (MapPlayerTask.getlastTaskCompleted() - this.lastRefresh > 500L) {
            return true;
        }
        if (this.getCurrentMapType().dimension != player.dimension) {
            return true;
        }
        if (this.underground != player.underground) {
            return true;
        }
        if (!(this.getCurrentMapType().vSlice == null || player.underground.booleanValue() && this.getCurrentMapType().vSlice == player.chunkCoordY)) {
            return true;
        }
        int diffX = Math.abs(this.lastPlayerChunkX - player.chunkCoordX);
        if (diffX > 2) {
            return true;
        }
        int diffZ = Math.abs(this.lastPlayerChunkZ - player.chunkCoordZ);
        if (diffZ > 2) {
            return true;
        }
        if (this.lastMapProperties == null || !this.lastMapProperties.equals(mapProperties)) {
            return true;
        }
        this.lastPlayerChunkX = player.chunkCoordX;
        this.lastPlayerChunkZ = player.chunkCoordZ;
        return false;
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public boolean isCaveMappingAllowed() {
        return this.caveMappingAllowed;
    }

    public int getDimension() {
        return this.getCurrentMapType().dimension;
    }
}

