/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model.mod;

import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.model.mod.ModBlockDelegate;
import net.techbrew.journeymap.waypoint.WaypointStore;

public class OpenBlocks {

    public static class GraveHandler
    implements ModBlockDelegate.IModBlockHandler {
        public static final GameRegistry.UniqueIdentifier UID = new GameRegistry.UniqueIdentifier("OpenBlocks:grave");
        private static final String TAG_PLAYERNAME = "PlayerName";
        private static final String TAG_PLAYERUUID = "PlayerUUID";

        @Override
        public Collection<GameRegistry.UniqueIdentifier> getBlockUids() {
            return Arrays.asList(UID);
        }

        @Override
        public IIcon getIcon(BlockMD blockMD) {
            return null;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
            int blockX = chunkMD.toBlockX(localX);
            int blockZ = chunkMD.toBlockZ(localZ);
            TileEntity tileEntity = chunkMD.getWorldObj().func_147438_o(blockX, y, blockZ);
            if (tileEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tileEntity.func_145841_b(tag);
                String playerName = null;
                playerName = tag.func_82582_d() ? "?" : tag.func_74779_i(TAG_PLAYERNAME);
                if (playerName == null) {
                    playerName = "";
                }
                Waypoint waypoint = new Waypoint(playerName + " " + blockMD.getName(), new ChunkCoordinates(blockX, y, blockZ), Color.red, Waypoint.Type.Death, chunkMD.getWorldObj().field_73011_w.field_76574_g);
                WaypointStore.instance().add(waypoint);
            }
            return blockMD;
        }
    }
}

