/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.properties.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.techbrew.journeymap.JourneyMap;

public class AtomicReferenceSerializer
implements JsonSerializer<AtomicReference>,
JsonDeserializer<AtomicReference> {
    AtomicBoolean configFormatChanged;

    public AtomicReferenceSerializer(AtomicBoolean configFormatChanged) {
        this.configFormatChanged = configFormatChanged;
    }

    public JsonElement serialize(AtomicReference arg0, Type arg1, JsonSerializationContext arg2) {
        if (arg0.get() instanceof Enum) {
            return new JsonPrimitive(((Enum)arg0.get()).name());
        }
        return new JsonPrimitive(arg0.get().toString());
    }

    public AtomicReference deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        String value = null;
        if (arg0.isJsonPrimitive()) {
            value = arg0.getAsString();
        } else {
            this.configFormatChanged.set(true);
            value = arg0.getAsJsonObject().get("value").getAsString();
        }
        Class refClass = (Class)((ParameterizedType)arg1).getActualTypeArguments()[0];
        if (refClass.equals(String.class)) {
            return new AtomicReference<String>(value);
        }
        if (Enum.class.isAssignableFrom(refClass)) {
            try {
                Object enumValue = Enum.valueOf(refClass, value);
                return new AtomicReference(enumValue);
            }
            catch (Exception t) {
                JourneyMap.getLogger().warn("Could not get enum value for " + refClass + " using: " + value);
                Enum enumValue = (Enum)EnumSet.allOf(refClass).iterator().next();
                return new AtomicReference<Enum>(enumValue);
            }
        }
        JourneyMap.getLogger().warn("Could not get AtomicReference type for " + refClass + " using: " + value);
        return new AtomicReference<Object>(null);
    }
}

