/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.Color;
import java.awt.geom.Point2D;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawStep;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.map.GridRenderer;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;

public class DrawWayPointStep
implements DrawStep {
    public final Waypoint waypoint;
    final Color color;
    final Color fontColor;
    final TextureImpl texture;
    final boolean isEdit;
    Point2D.Double lastPosition;
    Point2D.Double lastWindowPosition;
    boolean lastOnScreen;
    boolean showLabel;

    public DrawWayPointStep(Waypoint waypoint) {
        this(waypoint, waypoint.getColor(), waypoint.isDeathPoint() ? Color.red : waypoint.getSafeColor(), false);
    }

    public DrawWayPointStep(Waypoint waypoint, Color color, Color fontColor, boolean isEdit) {
        this.waypoint = waypoint;
        this.color = color;
        this.fontColor = fontColor;
        this.isEdit = isEdit;
        this.texture = waypoint.getTexture();
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    @Override
    public void draw(double xOffset, double yOffset, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        if (!this.waypoint.isInPlayerDimension()) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, gridRenderer, true);
        if (gridRenderer.isOnScreen(pixel)) {
            if (this.showLabel) {
                Point2D labelPoint = gridRenderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, rotation == 0.0 ? -this.texture.getHeight() : this.texture.getHeight());
                DrawUtil.drawLabel(this.waypoint.getName(), labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, Color.black, 180, this.fontColor, 255, fontScale, false, rotation);
            }
            if (this.isEdit) {
                TextureImpl editTex = TextureCache.instance().getWaypointEdit();
                DrawUtil.drawColoredImage(editTex, 255, this.color, pixel.getX() - (double)(editTex.getWidth() / 2), pixel.getY() - (double)(editTex.getHeight() / 2), -rotation);
            }
            DrawUtil.drawColoredImage(this.texture, 255, this.color, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
        } else if (!this.isEdit) {
            gridRenderer.ensureOnScreen(pixel);
            DrawUtil.drawColoredImage(this.texture, 255, this.color, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
        }
    }

    public void drawOffscreen(Point2D pixel, double rotation) {
        DrawUtil.drawColoredImage(this.texture, 255, this.color, pixel.getX() - (double)(this.texture.getWidth() / 2), pixel.getY() - (double)(this.texture.getHeight() / 2), -rotation);
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, GridRenderer gridRenderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        double x = this.waypoint.getX();
        double z = this.waypoint.getZ();
        double halfBlock = Math.pow(2.0, gridRenderer.getZoom()) / 2.0;
        Point2D.Double pixel = gridRenderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        this.lastPosition = pixel;
        this.lastWindowPosition = gridRenderer.getWindowPosition(this.lastPosition);
        return pixel;
    }

    public Point2D.Double getLastWindowPosition() {
        return this.lastWindowPosition;
    }

    public int getTextureHeight() {
        return this.texture.getHeight();
    }

    public int getTextureSize() {
        return Math.max(this.texture.getHeight(), this.texture.getWidth());
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    public static class SimpleCacheLoader
    extends CacheLoader<Waypoint, DrawWayPointStep> {
        public DrawWayPointStep load(Waypoint waypoint) throws Exception {
            return new DrawWayPointStep(waypoint);
        }
    }
}

