/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.JMLogger;
import org.apache.logging.log4j.Logger;
import se.rupy.http.Event;
import se.rupy.http.Query;
import se.rupy.http.Reply;
import se.rupy.http.Service;

public abstract class BaseService
extends Service {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String CALLBACK_PARAM = "callback";
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected String path;

    protected void throwEventException(int code, String message, Event event, boolean isError) throws Event, Exception {
        Logger logger = JourneyMap.getLogger();
        String out = code + " " + message;
        if (isError) {
            Exception ex = null;
            if (code != 404) {
                ex = new Exception(this.debugRequestHeaders(event));
            }
            JMLogger.logOnce(this.getClass().getName() + ": " + out, ex);
        } else if (logger.isTraceEnabled()) {
            JourneyMap.getLogger().trace(out);
        }
        try {
            if (code == 404) {
                event.reply().code("404 Not Found");
            } else {
                event.reply().code(out);
            }
        }
        catch (IOException e) {
            logger.warn("Can't set response code: " + out);
        }
        throw event;
    }

    protected String debugRequestHeaders(Event event) throws Exception {
        StringBuffer sb = new StringBuffer("HTTP Request:");
        if (event.query() != null) {
            event.query().parse();
            sb.append("\n request=").append(event.query().path());
            if (event.query().parameters() != null) {
                sb.append("?").append(event.query().parameters());
            }
            HashMap headers = event.query().header();
            for (Object name : headers.keySet()) {
                Object value = headers.get(name);
                sb.append("\n ").append(name).append("=").append(value);
            }
            sb.append("\n Remote Address:").append(event.remote());
        }
        return sb.toString();
    }

    protected void reportMalformedRequest(Event event) throws Event, Exception {
        String error = "Bad Request: " + event.query().path();
        JourneyMap.getLogger().error(error);
        this.throwEventException(400, error, event, false);
    }

    protected String getParameter(Query map, String key, String defaultValue) {
        Object val = map.get(key);
        return val != null ? val.toString() : defaultValue;
    }

    protected Integer getParameter(Map<String, String[]> map, String key, Integer defaultValue) {
        String[] val = map.get(key);
        Integer intVal = null;
        if (val != null) {
            try {
                intVal = Integer.parseInt((String)val);
            }
            catch (NumberFormatException e) {
                JourneyMap.getLogger().warn("Didn't get numeric query parameter for '" + key + "': " + val);
            }
        }
        return intVal != null ? intVal : defaultValue;
    }

    protected Long getParameter(Map<String, String[]> map, String key, Long defaultValue) {
        String[] val = map.get(key);
        Long longVal = null;
        if (val != null) {
            try {
                longVal = Long.parseLong((String)val);
            }
            catch (NumberFormatException e) {
                JourneyMap.getLogger().warn("Didn't get numeric query parameter for '" + key + "': " + val);
            }
        }
        return longVal != null ? longVal : defaultValue;
    }

    protected void gzipResponse(Event event, String data) throws Exception {
        byte[] bytes = this.gzip(data);
        if (bytes != null) {
            ResponseHeader.on(event).setHeader("Content-encoding", "gzip");
        } else {
            bytes = data.getBytes(UTF8);
        }
        ResponseHeader.on(event).contentLength(bytes.length);
        event.output().write(bytes);
    }

    protected void gzipResponse(Event event, byte[] data) throws Exception {
        byte[] bytes = this.gzip(data);
        if (bytes != null) {
            ResponseHeader.on(event).setHeader("Content-encoding", "gzip");
        } else {
            bytes = data;
        }
        ResponseHeader.on(event).contentLength(bytes.length);
        event.output().write(bytes);
    }

    protected void respondJson(Event event, Map responseObj) throws Exception {
        Query query = event.query();
        StringBuffer jsonData = new StringBuffer();
        boolean useJsonP = query.containsKey(CALLBACK_PARAM);
        if (useJsonP) {
            try {
                jsonData.append(URLEncoder.encode(query.get(CALLBACK_PARAM).toString(), UTF8.name()));
            }
            catch (UnsupportedEncodingException e) {
                jsonData.append(query.get(CALLBACK_PARAM).toString());
            }
            jsonData.append("(");
        } else {
            jsonData.append("data=");
        }
        jsonData.append(GSON.toJson((Object)responseObj));
        if (useJsonP) {
            jsonData.append(")");
        }
        ResponseHeader.on(event).noCache().contentType(ContentType.jsonp);
        this.gzipResponse(event, jsonData.toString());
    }

    protected byte[] gzip(String data) {
        Object bout = null;
        try {
            return this.gzip(data.getBytes(UTF8));
        }
        catch (Exception ex) {
            JourneyMap.getLogger().warn("Failed to UTF8 encode: " + data);
            return null;
        }
    }

    protected byte[] gzip(byte[] data) {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(bout);
            output.write(data);
            output.flush();
            output.close();
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            JourneyMap.getLogger().warn("Failed to gzip encode: " + Arrays.toString(data));
            return null;
        }
    }

    protected void serveImage(Event event, BufferedImage img) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "png", baos);
        baos.flush();
        byte[] bytes = baos.toByteArray();
        baos.close();
        event.output().write(bytes);
    }

    static class ResponseHeader {
        protected static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Constants.getLocale());
        private Reply reply;

        private ResponseHeader(Event event) {
            this.reply = event.reply();
        }

        static ResponseHeader on(Event event) {
            return new ResponseHeader(event);
        }

        ResponseHeader setHeader(String name, String value) {
            if (this.reply == null) {
                throw new IllegalStateException("ResponseHeader builder already cleared.");
            }
            this.reply.header(name, value);
            return this;
        }

        ResponseHeader noCache() {
            this.setHeader("Cache-Control", "no-cache");
            this.setHeader("Pragma", "no-cache");
            this.setHeader("Expires", "0");
            return this;
        }

        ResponseHeader content(File file) {
            this.contentType(ContentType.fromFileName(file.getName()));
            this.contentLength(file.length());
            return this.contentModified(file.lastModified());
        }

        ResponseHeader content(ZipEntry zipEntry) {
            this.contentType(ContentType.fromFileName(zipEntry.getName()));
            long size = zipEntry.getSize();
            long time = zipEntry.getTime();
            if (size > -1L) {
                this.contentLength(size);
            }
            if (time > -1L) {
                this.contentModified(time);
            }
            return this;
        }

        ResponseHeader contentLength(FileInputStream input) {
            try {
                this.contentLength(input.getChannel().size());
            }
            catch (IOException e) {
                JourneyMap.getLogger().warn("Couldn't get content length for FileInputStream");
            }
            return this;
        }

        ResponseHeader contentModified(long timestamp) {
            return this.setHeader("Last-Modified", dateFormat.format(new Date(timestamp)));
        }

        ResponseHeader contentLength(long fileSize) {
            return this.setHeader("Content-Length", Long.toString(fileSize));
        }

        ResponseHeader expires(long timestamp) {
            return this.setHeader("Expires", dateFormat.format(new Date(timestamp)));
        }

        ResponseHeader contentType(ContentType type) {
            if (type != null) {
                this.reply.type(type.getMime());
                if (ContentType.htmlTypes.contains((Object)type)) {
                    this.contentLanguage(Constants.getLocale());
                }
            }
            return this;
        }

        ResponseHeader contentLanguage(Locale locale) {
            this.setHeader("Content-Language", locale.toString());
            return this;
        }

        ResponseHeader inlineFilename(String name) {
            return this.setHeader("Content-Disposition", "inline; filename=\"" + name + "\"");
        }

        void done() {
            this.reply = null;
        }

        static {
            dateFormat.setTimeZone(Constants.GMT);
        }
    }

    static enum ContentType {
        css("text/css; charset=utf-8"),
        gif("image/gif"),
        ico("image/x-icon"),
        htm("text/html; charset=utf-8"),
        html("text/html; charset=utf-8"),
        js("application/javascript; charset=utf-8"),
        json("application/json; charset=utf-8"),
        jsonp("application/javascript; charset=utf-8"),
        png("image/png"),
        jpeg("image/jpeg"),
        jpg("image/jpeg"),
        log("text/plain; charset=utf-8"),
        txt("text/plain; charset=utf-8"),
        UNKNOWN("application/x-unknown");

        static final EnumSet htmlTypes;
        private final String mime;

        private ContentType(String mime) {
            this.mime = mime;
        }

        static ContentType fromFileName(String fileName) {
            String name = fileName.toLowerCase(Locale.ENGLISH);
            String ext = name.substring(name.lastIndexOf(46) + 1);
            try {
                return ContentType.valueOf(ext);
            }
            catch (Exception e) {
                JourneyMap.getLogger().warn("No ContentType match for file: " + name);
                return null;
            }
        }

        String getMime() {
            return this.mime;
        }

        static {
            htmlTypes = EnumSet.of(htm, html, txt);
        }
    }
}

